/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.filter;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.filter.ITupleFilter;
import cutthecrap.utils.striterators.FilterBase;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class TupleRemover<E>
extends FilterBase
implements ITupleFilter<E> {
    private static final long serialVersionUID = 1L;

    @Override
    public ITupleIterator<E> filterOnce(Iterator src, Object context) {
        return new Removerator((ITupleIterator)src, context, this);
    }

    protected abstract boolean remove(ITuple<E> var1);

    private static class Removerator<E>
    implements ITupleIterator<E> {
        private final ITupleIterator<E> src;
        private final Object ctx;
        private final TupleRemover<E> filter;

        public Removerator(ITupleIterator<E> src, Object context, TupleRemover<E> filter) {
            this.src = src;
            this.ctx = context;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            return this.src.hasNext();
        }

        @Override
        public ITuple<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ITuple<E> e = this.src.next();
            if (this.filter.remove(e)) {
                this.src.remove();
            }
            return e;
        }

        @Override
        public void remove() {
            this.src.remove();
        }
    }
}

