/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.keys;

import com.bigdata.btree.BytesUtil;
import java.util.Arrays;

public class KVO<O>
implements Comparable<KVO<O>> {
    public final byte[] key;
    public final byte[] val;
    public final O obj;

    public KVO(byte[] key, byte[] val) {
        this(key, val, null);
    }

    public KVO(byte[] key, byte[] val, O obj) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.key = key;
        this.val = val;
        this.obj = obj;
    }

    public void done() {
    }

    @Override
    public int compareTo(KVO<O> arg0) {
        return BytesUtil.compareBytes(this.key, arg0.key);
    }

    public String toString() {
        return "KVO{key=" + BytesUtil.toString(this.key) + ", val=" + Arrays.toString(this.val) + ", obj=" + this.obj + "}";
    }

    public static byte[][] getKeys(KVO<?>[] chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException();
        }
        byte[][] keys = new byte[chunk.length][];
        for (int i = 0; i < chunk.length; ++i) {
            keys[i] = chunk[i].key;
        }
        return keys;
    }

    public static byte[][] getVals(KVO<?>[] chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException();
        }
        byte[][] vals = new byte[chunk.length][];
        for (int i = 0; i < chunk.length; ++i) {
            vals[i] = chunk[i].val;
        }
        return vals;
    }

    public static <T> KVO<T>[] dense(KVO<T>[] a, int len) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (len < 0 || len > a.length) {
            throw new IllegalArgumentException();
        }
        if (len == a.length) {
            return a;
        }
        KVO[] b = new KVO[len];
        System.arraycopy(a, 0, b, 0, len);
        return b;
    }
}

