/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.raba.codec.IRabaCoder;

public class BatchLookup
extends AbstractKeyArrayIndexProcedure<AbstractKeyArrayIndexProcedure.ResultBuffer>
implements IParallelizableIndexProcedure<AbstractKeyArrayIndexProcedure.ResultBuffer> {
    private static final long serialVersionUID = 8102720738892338403L;

    public BatchLookup() {
    }

    protected BatchLookup(IRabaCoder keysCoder, IRabaCoder valsCoder, int fromIndex, int toIndex, byte[][] keys) {
        super(keysCoder, valsCoder, fromIndex, toIndex, keys, null);
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public AbstractKeyArrayIndexProcedure.ResultBuffer apply(IIndex ndx) {
        int n = this.getKeyCount();
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = ndx.lookup(this.getKey(i));
        }
        return new AbstractKeyArrayIndexProcedure.ResultBuffer(n, ret, ndx.getIndexMetadata().getTupleSerializer().getLeafValuesCoder());
    }

    public static class BatchLookupConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<BatchLookup> {
        public static final BatchLookupConstructor INSTANCE = new BatchLookupConstructor();

        private BatchLookupConstructor() {
        }

        @Override
        public final boolean sendValues() {
            return false;
        }

        @Override
        public BatchLookup newInstance(IRabaCoder keysCoder, IRabaCoder valsCoder, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            assert (vals == null);
            return new BatchLookup(keysCoder, valsCoder, fromIndex, toIndex, keys);
        }
    }
}

