/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba.codec;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.AbstractCodedRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class FixedLengthValueRabaCoder
implements IRabaCoder,
Externalizable {
    private static final long serialVersionUID = 5549200745262968226L;
    private static final byte VERSION0 = 0;
    private int len;
    private static final int SIZEOF_VERSION = 1;
    private static final int SIZEOF_SIZE = 4;
    private static final int O_VERSION = 0;
    private static final int O_SIZE = 1;
    private static final int O_NULLS = 5;

    @Override
    public final boolean isKeyCoder() {
        return false;
    }

    @Override
    public final boolean isValueCoder() {
        return true;
    }

    @Override
    public boolean isDuplicateKeys() {
        return false;
    }

    public final int getLength() {
        return this.len;
    }

    public FixedLengthValueRabaCoder() {
    }

    public FixedLengthValueRabaCoder(int len) {
        this.len = len;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.len);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.len = in.readInt();
    }

    @Override
    public ICodedRaba encodeLive(IRaba raba, DataOutputBuffer buf) {
        if (raba == null) {
            throw new IllegalArgumentException();
        }
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        if (raba.isKeys()) {
            throw new UnsupportedOperationException();
        }
        int size = raba.size();
        int capacity = 5 + BytesUtil.bitFlagByteLength(size) + size * this.len;
        buf.ensureFree(capacity);
        int O_origin = buf.pos();
        assert (buf.pos() == 0 + O_origin);
        buf.putByte((byte)0);
        assert (buf.pos() == 1 + O_origin);
        buf.putInt(size);
        assert (buf.pos() == 5 + O_origin);
        int i = 0;
        while (i < size) {
            byte bits = 0;
            for (int j = 0; j < 8 && i < size; ++j, ++i) {
                if (raba.isNull(i)) {
                    bits = (byte)(bits | 1 << 7 - j);
                    continue;
                }
                if (raba.length(i) == this.len) continue;
                throw new UnsupportedOperationException("Value has wrong length: index=" + i + ", expected=" + this.len + ", actual=" + raba.length(i));
            }
            buf.putByte(bits);
        }
        for (i = 0; i < size; ++i) {
            if (raba.isNull(i)) {
                buf.advancePosAndLimit(this.len);
                continue;
            }
            buf.put(raba.get(i));
        }
        assert (buf.pos() == buf.limit()) : buf.toString() + " : src=" + raba;
        AbstractFixedByteArrayBuffer slice = buf.slice(O_origin, buf.pos() - O_origin);
        return new CodedRabaImpl(this.len, slice, size);
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(IRaba raba, DataOutputBuffer buf) {
        return this.encodeLive(raba, buf).data();
    }

    @Override
    public ICodedRaba decode(AbstractFixedByteArrayBuffer data) {
        return new CodedRabaImpl(this.len, data);
    }

    private static class CodedRabaImpl
    extends AbstractCodedRaba {
        private final int len;
        private final int size;
        private final AbstractFixedByteArrayBuffer data;
        private final int O_values;

        public CodedRabaImpl(int len, AbstractFixedByteArrayBuffer data) {
            if (len <= 0) {
                throw new IllegalArgumentException();
            }
            if (data == null) {
                throw new IllegalArgumentException();
            }
            this.len = len;
            this.data = data;
            byte version = data.getByte(0);
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown version: " + version);
                }
            }
            this.size = data.getInt(1);
            if (this.size < 0) {
                throw new IllegalArgumentException();
            }
            int bitFlagByteCount = BytesUtil.bitFlagByteLength(this.size);
            this.O_values = 5 + bitFlagByteCount;
        }

        public CodedRabaImpl(int len, AbstractFixedByteArrayBuffer data, int size) {
            this.len = len;
            this.data = data;
            this.size = size;
            int bitFlagByteCount = BytesUtil.bitFlagByteLength(size);
            this.O_values = 5 + bitFlagByteCount;
        }

        @Override
        public final AbstractFixedByteArrayBuffer data() {
            return this.data;
        }

        @Override
        public boolean isKeys() {
            return false;
        }

        @Override
        public final int capacity() {
            return this.size;
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public final boolean isFull() {
            return true;
        }

        protected void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public boolean isNull(int index) {
            this.rangeCheck(index);
            return this.data.getBit(40 + index);
        }

        @Override
        public int length(int index) {
            if (this.isNull(index)) {
                throw new NullPointerException();
            }
            return this.len;
        }

        @Override
        public byte[] get(int index) {
            if (this.isNull(index)) {
                return null;
            }
            int offset = this.O_values + index * this.len;
            byte[] a = new byte[this.len];
            this.data.get(offset, a, 0, this.len);
            return a;
        }

        @Override
        public int copy(int index, OutputStream os) {
            if (this.isNull(index)) {
                throw new NullPointerException();
            }
            int offset = this.O_values + index * this.len;
            try {
                this.data.writeOn(os, offset, this.len);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return this.len;
        }

        @Override
        public int search(byte[] key) {
            throw new UnsupportedOperationException();
        }
    }
}

