/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba.codec;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.AbstractCodedRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class SimpleRabaCoder
implements IRabaCoder,
Externalizable {
    private static final long serialVersionUID = 3385188183979794781L;
    private static final byte VERSION0 = 0;
    private static final byte VERSION1 = 1;
    private static final byte CURRENT_VERSION = 1;
    public static final transient SimpleRabaCoder INSTANCE = new SimpleRabaCoder();
    private static final int SIZEOF_VERSION = 1;
    private static final int SIZEOF_FLAGS = 1;
    private static final int SIZEOF_SIZE = 4;
    private static final int SIZEOF_CAPACITY = 4;
    private static final int SIZEOF_OFFSET = 4;
    private static final int O_VERSION = 0;
    private static final int O_FLAGS = 1;
    private static final int O_SIZE = 2;

    @Override
    public final boolean isKeyCoder() {
        return true;
    }

    @Override
    public final boolean isValueCoder() {
        return true;
    }

    @Override
    public boolean isDuplicateKeys() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    private static final int O_NULLS(byte version) {
        if (version == 0) {
            return 6;
        }
        return 10;
    }

    @Override
    public ICodedRaba encodeLive(IRaba raba, DataOutputBuffer buf) {
        int i;
        int O_offsets;
        if (raba == null) {
            throw new IllegalArgumentException();
        }
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        int size = raba.size();
        int capacity = raba.capacity();
        boolean isKeys = raba.isKeys();
        int sizeOfOffsets = (size + 1) * 4;
        int O_origin = buf.pos();
        assert (buf.pos() == 0 + O_origin);
        buf.putByte((byte)1);
        assert (buf.pos() == 1 + O_origin);
        buf.putByte((byte)(isKeys ? 1 : 0));
        assert (buf.pos() == 2 + O_origin);
        buf.putInt(size);
        buf.putInt(capacity);
        if (!isKeys) {
            int i2 = 0;
            while (i2 < size) {
                byte bits = 0;
                for (int j = 0; j < 8 && i2 < size; ++j, ++i2) {
                    if (!raba.isNull(i2)) continue;
                    bits = (byte)(bits | 1 << 7 - j);
                }
                buf.putByte(bits);
            }
        }
        int lastOffset = O_offsets = buf.pos() + sizeOfOffsets - O_origin;
        for (i = 0; i < size; ++i) {
            if (raba.isNull(i)) {
                buf.putInt(lastOffset);
                continue;
            }
            buf.putInt(lastOffset);
            lastOffset += raba.length(i);
        }
        buf.putInt(lastOffset);
        for (i = 0; i < size; ++i) {
            if (raba.isNull(i)) continue;
            buf.put(raba.get(i));
        }
        assert (buf.pos() == buf.limit()) : buf.toString() + " : src=" + raba;
        AbstractFixedByteArrayBuffer slice = buf.slice(O_origin, buf.pos() - O_origin);
        return new CodedRabaImpl(slice, isKeys, size, capacity, 1);
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(IRaba raba, DataOutputBuffer buf) {
        return this.encodeLive(raba, buf).data();
    }

    @Override
    public ICodedRaba decode(AbstractFixedByteArrayBuffer data) {
        return new CodedRabaImpl(data);
    }

    private static class CodedRabaImpl
    extends AbstractCodedRaba {
        private final int size;
        private final int capacity;
        private final int o_nulls;
        private final boolean isKeys;
        private final AbstractFixedByteArrayBuffer data;
        private final int O_offsets;

        public CodedRabaImpl(AbstractFixedByteArrayBuffer data) {
            if (data == null) {
                throw new IllegalArgumentException();
            }
            this.data = data;
            byte version = data.getByte(0);
            switch (version) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown version: " + version);
                }
            }
            this.isKeys = data.getByte(1) != 0;
            this.size = data.getInt(2);
            this.capacity = version >= 1 ? data.getInt(6) : this.size;
            if (this.size < 0) {
                throw new IllegalArgumentException();
            }
            if (this.capacity < 0) {
                throw new IllegalArgumentException();
            }
            int bitFlagByteCount = this.isKeys ? 0 : BytesUtil.bitFlagByteLength(this.size);
            this.o_nulls = SimpleRabaCoder.O_NULLS(version);
            this.O_offsets = this.o_nulls + bitFlagByteCount;
        }

        public CodedRabaImpl(AbstractFixedByteArrayBuffer data, boolean isKeys, int size, int capacity, byte version) {
            this.data = data;
            this.isKeys = isKeys;
            this.size = size;
            this.capacity = capacity;
            int bitFlagByteCount = isKeys ? 0 : BytesUtil.bitFlagByteLength(size);
            this.o_nulls = SimpleRabaCoder.O_NULLS(version);
            this.O_offsets = this.o_nulls + bitFlagByteCount;
        }

        @Override
        public final AbstractFixedByteArrayBuffer data() {
            return this.data;
        }

        @Override
        public boolean isKeys() {
            return this.isKeys;
        }

        @Override
        public final int capacity() {
            return this.capacity;
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public final boolean isFull() {
            return true;
        }

        protected void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public boolean isNull(int index) {
            if (index >= this.size && index < this.capacity) {
                return true;
            }
            this.rangeCheck(index);
            if (this.isKeys) {
                return false;
            }
            return this.data.getBit((this.o_nulls << 3) + index);
        }

        @Override
        public int length(int index) {
            if (this.isNull(index)) {
                throw new NullPointerException();
            }
            int offset = this.data.getInt(this.O_offsets + index * 4);
            int offset2 = this.data.getInt(this.O_offsets + (index + 1) * 4);
            int length = offset2 - offset;
            assert (length >= 0);
            return length;
        }

        @Override
        public byte[] get(int index) {
            if (this.isNull(index)) {
                return null;
            }
            int offset = this.data.getInt(this.O_offsets + index * 4);
            int offset2 = this.data.getInt(this.O_offsets + (index + 1) * 4);
            int length = offset2 - offset;
            assert (length >= 0);
            byte[] a = new byte[length];
            this.data.get(offset, a, 0, length);
            return a;
        }

        @Override
        public int copy(int index, OutputStream os) {
            if (this.isNull(index)) {
                throw new NullPointerException();
            }
            int offset = this.data.getInt(this.O_offsets + index * 4);
            int offset2 = this.data.getInt(this.O_offsets + (index + 1) * 4);
            int length = offset2 - offset;
            assert (length >= 0);
            try {
                this.data.writeOn(os, offset, length);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return length;
        }

        @Override
        public int search(byte[] key) {
            if (!this.isKeys()) {
                throw new UnsupportedOperationException();
            }
            boolean base = false;
            int nmem = this.size;
            int low = 0;
            int high = nmem - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int offset = 0 + mid;
                int aoff = this.data.getInt(this.O_offsets + offset * 4);
                int alen = this.data.getInt(this.O_offsets + (offset + 1) * 4) - aoff;
                int tmp = BytesUtil.compareBytesWithLenAndOffset(this.data.off() + aoff, alen, this.data.array(), 0, key.length, key);
                if (tmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (tmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return offset;
            }
            int offset = 0 + low;
            return -(offset + 1);
        }
    }
}

