/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.view;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleCursor;
import com.bigdata.btree.ITupleCursor2;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.view.FusedTupleIterator;
import java.util.NoSuchElementException;

public class FusedTupleCursor<E>
extends FusedTupleIterator<ITupleCursor<E>, E>
implements ITupleCursor<E> {
    private final IIndex ndx;
    private boolean forward = true;
    private final KeyBuilder lastKeyBuffer = new KeyBuilder(0);

    public FusedTupleCursor(int flags, boolean deleted, ITupleCursor<E>[] srcs, IIndex ndx) {
        super(flags, deleted, (ITupleIterator[])srcs);
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
    }

    @Override
    public final IIndex getIndex() {
        return this.ndx;
    }

    private void setForwardDirection(boolean forward) {
        if (this.forward != forward) {
            byte[] lastKeyVisited;
            if (this.INFO) {
                log.info((Object)("Changing direction: forward=" + forward));
            }
            if (this.lastVisited == -1) {
                lastKeyVisited = null;
            } else {
                lastKeyVisited = this.lastKeyBuffer.getKey();
                if (this.INFO) {
                    log.info((Object)("key for last tuple visited=" + BytesUtil.toString(lastKeyVisited)));
                }
            }
            for (int i = 0; i < this.n; ++i) {
                ITuple tuple = ((ITupleCursor2)((ITupleCursor[])this.sourceIterator)[i]).tuple();
                if (this.INFO) {
                    log.info((Object)("sourceIterator[" + i + "]=" + tuple));
                }
                if (lastKeyVisited != null) {
                    while (tuple != null) {
                        boolean ok;
                        int ret = BytesUtil.compareBytes(tuple.getKey(), lastKeyVisited);
                        boolean bl = forward ? ret > 0 : (ok = ret < 0);
                        if (ok) break;
                        tuple = forward ? (((ITupleCursor[])this.sourceIterator)[i].hasNext() ? ((ITupleCursor[])this.sourceIterator)[i].next() : null) : (((ITupleCursor[])this.sourceIterator)[i].hasPrior() ? ((ITupleCursor[])this.sourceIterator)[i].prior() : null);
                        if (!this.INFO) continue;
                        log.info((Object)("skipping tuple: source=" + i + ", direction=" + (forward ? "next" : "prior") + ", newTuple=" + tuple));
                    }
                }
                this.sourceTuple[i] = tuple;
                if (!this.INFO) continue;
                log.info((Object)("sourceTuple   [" + i + "]=" + this.sourceTuple[i]));
            }
            this.forward = forward;
            this.current = -1;
        }
    }

    @Override
    public boolean hasNext() {
        this.setForwardDirection(true);
        return super.hasNext();
    }

    @Override
    public boolean hasPrior() {
        this.setForwardDirection(false);
        while (true) {
            if (this.current != -1) {
                if (this.INFO) {
                    log.info((Object)("Already matched: source=" + this.current));
                }
                return true;
            }
            int nexhausted = 0;
            for (int i = 0; i < this.n; ++i) {
                if (this.sourceTuple[i] != null) continue;
                if (((ITupleCursor[])this.sourceIterator)[i].hasPrior()) {
                    this.sourceTuple[i] = ((ITupleCursor[])this.sourceIterator)[i].prior();
                    if (!this.DEBUG) continue;
                    log.debug((Object)("read sourceTuple[" + i + "]=" + this.sourceTuple[i]));
                    continue;
                }
                ++nexhausted;
            }
            if (nexhausted == this.n) {
                return false;
            }
            assert (this.current == -1);
            byte[] key = null;
            for (int i = 0; i < this.n; ++i) {
                if (this.sourceTuple[i] == null) continue;
                if (this.current == -1) {
                    this.current = i;
                    key = this.sourceTuple[i].getKey();
                    assert (key != null);
                    continue;
                }
                byte[] tmp = this.sourceTuple[i].getKey();
                int ret = BytesUtil.compareBytes(tmp, key);
                if (ret <= 0) continue;
                this.current = i;
                key = tmp;
            }
            assert (this.current != -1);
            if (!this.sourceTuple[this.current].isDeletedVersion() || this.deleted) break;
            if (this.INFO) {
                log.info((Object)("Skipping deleted: source=" + this.current + ", tuple=" + this.sourceTuple[this.current]));
            }
            this.clearCurrent();
        }
        if (this.INFO) {
            log.info((Object)("Will visit next: source=" + this.current + ", tuple: " + this.sourceTuple[this.current]));
        }
        return true;
    }

    @Override
    public ITuple<E> prior() {
        if (!this.hasPrior()) {
            throw new NoSuchElementException();
        }
        return this.consumeLookaheadTuple();
    }

    @Override
    public ITuple<E> seek(byte[] key) {
        int i;
        this.lastVisited = -1;
        this.current = -1;
        this.lastKeyBuffer.reset().append(key);
        for (i = 0; i < this.n; ++i) {
            this.sourceTuple[i] = ((ITupleCursor[])this.sourceIterator)[i].seek(key);
            if (this.sourceTuple[i] == null || this.current != -1) continue;
            if (this.INFO) {
                log.info((Object)("Found match: source=" + i + ", key=" + BytesUtil.toString(key)));
            }
            this.current = i;
        }
        this.forward = true;
        if (!this.deleted) {
            for (i = 0; i < this.n; ++i) {
                if (this.sourceTuple[i] == null || !this.sourceTuple[i].isDeletedVersion()) continue;
                if (this.INFO) {
                    log.info((Object)("Skipping deleted: source=" + this.current + ", tuple=" + this.sourceTuple[this.current]));
                }
                this.clearCurrent();
                return null;
            }
        }
        if (this.current == -1) {
            return null;
        }
        return this.consumeLookaheadTuple();
    }

    @Override
    protected ITuple<E> consumeLookaheadTuple() {
        assert (this.current != -1);
        this.lastKeyBuffer.reset().append(this.sourceTuple[this.current].getKey());
        return super.consumeLookaheadTuple();
    }

    @Override
    public final ITuple<E> seek(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.seek(this.getIndex().getIndexMetadata().getTupleSerializer().serializeKey(key));
    }

    @Override
    public void remove() {
        if (this.lastVisited == -1) {
            throw new IllegalStateException();
        }
        byte[] key = this.lastKeyBuffer.getKey();
        this.ndx.remove(key);
    }
}

