/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.view;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BloomFilter;
import com.bigdata.btree.IBloomFilter;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleCursor;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.btree.ReadOnlyIndex;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.filter.Reverserator;
import com.bigdata.btree.filter.TupleRemover;
import com.bigdata.btree.filter.WrappedTupleIterator;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.btree.view.FusedTupleCursor;
import com.bigdata.btree.view.FusedTupleIterator;
import com.bigdata.counters.CounterSet;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.service.Split;
import cutthecrap.utils.striterators.IFilter;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FusedView
implements IIndex,
ILocalBTreeView {
    protected static final Logger log = Logger.getLogger(FusedView.class);
    protected static final transient String ERR_RANGE_COUNT_EXCEEDS_MAX_LONG = "The range count can not be expressed as a 64-bit signed integer";
    private final ISources sources;
    private volatile IBloomFilter bloomFilter = null;

    @Override
    public final AbstractBTree[] getSources() {
        return this.sources.getSources();
    }

    @Override
    public final int getSourceCount() {
        return this.sources.getSourceCount();
    }

    @Override
    public final BTree getMutableBTree() {
        return this.sources.getMutableBTree();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{ ");
        sb.append(Arrays.toString(this.getSources()));
        sb.append("}");
        return sb.toString();
    }

    protected void assertNotReadOnly() {
        if (this.getMutableBTree().isReadOnly()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public IResourceMetadata[] getResourceMetadata() {
        int n = this.getSourceCount();
        IResourceMetadata[] resources = new IResourceMetadata[n];
        int i = 0;
        for (AbstractBTree t : this.sources) {
            resources[i++] = t.getStore().getResourceMetadata();
        }
        return resources;
    }

    public FusedView(AbstractBTree src1, AbstractBTree src2) {
        this(new AbstractBTree[]{src1, src2});
    }

    public FusedView(AbstractBTree[] srcs) {
        this.sources = new WeakRefSources(srcs);
    }

    static void checkSources(AbstractBTree[] srcs) {
        if (srcs == null) {
            throw new IllegalArgumentException("sources is null");
        }
        if (srcs.length < 2) {
            throw new IllegalArgumentException("At least two sources are required");
        }
        for (int i = 0; i < srcs.length; ++i) {
            if (srcs[i] == null) {
                throw new IllegalArgumentException("Source null @ index=" + i);
            }
            if (!srcs[i].getIndexMetadata().getDeleteMarkers()) {
                throw new IllegalArgumentException("Source does not maintain delete markers @ index=" + i);
            }
            for (int j = 0; j < i; ++j) {
                if (srcs[i] == srcs[j]) {
                    throw new IllegalArgumentException("Source used more than once");
                }
                if (srcs[i].getIndexMetadata().getIndexUUID().equals(srcs[j].getIndexMetadata().getIndexUUID())) continue;
                throw new IllegalArgumentException("Sources have different index UUIDs @ index=" + i);
            }
        }
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.getMutableBTree().getIndexMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBloomFilter getBloomFilter() {
        if (this.bloomFilter == null) {
            FusedView fusedView = this;
            synchronized (fusedView) {
                this.bloomFilter = new FusedBloomFilter();
            }
        }
        return this.bloomFilter;
    }

    @Override
    public final CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        int i = 0;
        for (AbstractBTree t : this.sources) {
            counterSet.makePath("view[" + i + "]").attach(t.getCounters());
            ++i;
        }
        return counterSet;
    }

    @Override
    public ICounter getCounter() {
        return this.getMutableBTree().getCounter();
    }

    @Override
    public byte[] insert(byte[] key, byte[] value) {
        byte[] oldval = this.lookup(key);
        this.getMutableBTree().insert(key, value);
        return oldval;
    }

    @Override
    public Object insert(Object key, Object val) {
        key = this.getTupleSerializer().serializeKey(key);
        val = this.getTupleSerializer().serializeVal(val);
        Tuple tuple = this.lookup((byte[])key, this.getMutableBTree().getLookupTuple());
        this.getMutableBTree().insert((byte[])key, (byte[])val);
        if (tuple == null || tuple.isDeletedVersion()) {
            return null;
        }
        return tuple.getObject();
    }

    @Override
    public byte[] remove(byte[] key) {
        Tuple tuple = this.lookup(key, this.getMutableBTree().getLookupTuple());
        if (tuple == null || tuple.isDeletedVersion()) {
            return null;
        }
        byte[] oldval = tuple.getValue();
        this.getMutableBTree().remove(key);
        return oldval;
    }

    @Override
    public Object remove(Object key) {
        key = this.getTupleSerializer().serializeKey(key);
        Tuple tuple = this.lookup((byte[])key, this.getMutableBTree().getLookupTuple());
        if (tuple == null || tuple.isDeletedVersion()) {
            return null;
        }
        this.getMutableBTree().remove(key);
        return tuple.getObject();
    }

    @Override
    public final byte[] lookup(byte[] key) {
        Tuple tuple = this.lookup(key, this.getMutableBTree().getLookupTuple());
        if (tuple == null || tuple.isDeletedVersion()) {
            return null;
        }
        return tuple.getValue();
    }

    @Override
    public Object lookup(Object key) {
        key = this.getTupleSerializer().serializeKey(key);
        Tuple tuple = this.lookup((byte[])key, this.getMutableBTree().getLookupTuple());
        if (tuple == null || tuple.isDeletedVersion()) {
            return null;
        }
        return tuple.getObject();
    }

    public final Tuple lookup(byte[] key, Tuple tuple) {
        return this.lookup(0, key, tuple);
    }

    protected final Tuple lookup(int startIndex, byte[] key, Tuple tuple) {
        for (AbstractBTree t : this.sources) {
            if (t.lookup(key, tuple) == null) continue;
            return tuple;
        }
        return null;
    }

    @Override
    public final boolean contains(byte[] key) {
        Tuple tuple = this.lookup(key, this.getMutableBTree().getContainsTuple());
        return tuple != null && !tuple.isDeletedVersion();
    }

    @Override
    public boolean contains(Object key) {
        key = this.getTupleSerializer().serializeKey(key);
        return this.contains((byte[])key);
    }

    private ITupleSerializer getTupleSerializer() {
        return this.getIndexMetadata().getTupleSerializer();
    }

    @Override
    public final long rangeCount() {
        return this.rangeCount(null, null);
    }

    @Override
    public final long rangeCount(byte[] fromKey, byte[] toKey) {
        LocalPartitionMetadata pmd;
        if ((fromKey == null || toKey == null) && (pmd = this.getIndexMetadata().getPartitionMetadata()) != null) {
            if (fromKey == null) {
                fromKey = pmd.getLeftSeparatorKey();
            }
            if (toKey == null) {
                toKey = pmd.getRightSeparatorKey();
            }
        }
        long count = 0L;
        for (AbstractBTree t : this.sources) {
            long inc = t.rangeCount(fromKey, toKey);
            if (count + inc < count) {
                log.warn((Object)ERR_RANGE_COUNT_EXCEEDS_MAX_LONG);
                return Long.MAX_VALUE;
            }
            count += inc;
        }
        return count;
    }

    @Override
    public final long rangeCountExact(byte[] fromKey, byte[] toKey) {
        LocalPartitionMetadata pmd;
        if ((fromKey == null || toKey == null) && (pmd = this.getIndexMetadata().getPartitionMetadata()) != null) {
            if (fromKey == null) {
                fromKey = pmd.getLeftSeparatorKey();
            }
            if (toKey == null) {
                toKey = pmd.getRightSeparatorKey();
            }
        }
        ITupleIterator itr = this.rangeIterator(fromKey, toKey, 0, 0, null);
        long n = 0L;
        while (itr.hasNext()) {
            itr.next();
            if (n == Long.MAX_VALUE) {
                throw new RuntimeException(ERR_RANGE_COUNT_EXCEEDS_MAX_LONG);
            }
            ++n;
        }
        return n;
    }

    @Override
    public long rangeCountExactWithDeleted(byte[] fromKey, byte[] toKey) {
        LocalPartitionMetadata pmd;
        if ((fromKey == null || toKey == null) && (pmd = this.getIndexMetadata().getPartitionMetadata()) != null) {
            if (fromKey == null) {
                fromKey = pmd.getLeftSeparatorKey();
            }
            if (toKey == null) {
                toKey = pmd.getRightSeparatorKey();
            }
        }
        ITupleIterator itr = this.rangeIterator(fromKey, toKey, 0, 4, null);
        long n = 0L;
        while (itr.hasNext()) {
            itr.next();
            if (n == Long.MAX_VALUE) {
                throw new RuntimeException(ERR_RANGE_COUNT_EXCEEDS_MAX_LONG);
            }
            ++n;
        }
        return n;
    }

    @Override
    public ITupleIterator rangeIterator() {
        return this.rangeIterator(null, null);
    }

    @Override
    public final ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey) {
        return this.rangeIterator(fromKey, toKey, 0, 3, null);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        Iterator src;
        boolean removeAll;
        LocalPartitionMetadata pmd;
        if ((fromKey == null || toKey == null) && (pmd = this.getIndexMetadata().getPartitionMetadata()) != null) {
            if (fromKey == null) {
                fromKey = pmd.getLeftSeparatorKey();
            }
            if (toKey == null) {
                toKey = pmd.getRightSeparatorKey();
            }
        }
        boolean reverseScan = (flags & 0x40) != 0;
        boolean cursorMode = (flags & 0x20) != 0;
        boolean readOnly = (flags & 8) != 0;
        boolean deleted = (flags & 4) != 0;
        boolean bl = removeAll = (flags & 0x10) != 0;
        if (readOnly && removeAll) {
            throw new IllegalArgumentException();
        }
        int n = this.sources.getSourceCount();
        if (log.isInfoEnabled()) {
            log.info((Object)("nsrcs=" + n + ", flags=" + flags + ", readOnly=" + readOnly + ", deleted=" + deleted + ", reverseScan=" + reverseScan));
        }
        int sourceFlags = (flags | 1 | 4 | (reverseScan || removeAll ? 32 : 0)) & 0xFFFFFFEF & 0xFFFFFFBF;
        if (cursorMode || removeAll || reverseScan) {
            ITupleCursor[] itrs = new ITupleCursor[n];
            int i = 0;
            for (AbstractBTree t : this.sources) {
                itrs[i++] = (ITupleCursor)t.rangeIterator(fromKey, toKey, capacity, sourceFlags, (IFilter)null);
            }
            src = new FusedTupleCursor(flags, deleted, itrs, readOnly ? new ReadOnlyIndex(this) : this);
        } else {
            ITupleIterator[] itrs = new ITupleIterator[n];
            int i = 0;
            for (AbstractBTree t : this.sources) {
                itrs[i++] = t.rangeIterator(fromKey, toKey, capacity, sourceFlags, (IFilter)null);
            }
            src = new FusedTupleIterator(flags, deleted, itrs);
        }
        if (reverseScan) {
            src = new Reverserator(src);
        }
        if (filter != null) {
            src = new WrappedTupleIterator(filter.filter(src, null));
        }
        if ((flags & 0x10) != 0) {
            this.assertNotReadOnly();
            src = new TupleRemover(){
                private static final long serialVersionUID = 1L;

                protected boolean remove(ITuple e) {
                    return true;
                }
            }.filterOnce(src, null);
        }
        return src;
    }

    @Override
    public final Object submit(byte[] key, ISimpleIndexProcedure proc) {
        return proc.apply(this);
    }

    @Override
    public final void submit(byte[] fromKey, byte[] toKey, IKeyRangeIndexProcedure proc, IResultHandler handler) {
        if (fromKey == null) {
            fromKey = this.getIndexMetadata().getPartitionMetadata().getLeftSeparatorKey();
        }
        if (toKey == null) {
            toKey = this.getIndexMetadata().getPartitionMetadata().getRightSeparatorKey();
        }
        Object result = proc.apply(this);
        if (handler != null) {
            handler.aggregate(result, new Split(null, 0, 0));
        }
    }

    @Override
    public void submit(int fromIndex, int toIndex, byte[][] keys, byte[][] vals, AbstractKeyArrayIndexProcedureConstructor ctor, IResultHandler aggregator) {
        Object result = ctor.newInstance(this, fromIndex, toIndex, keys, vals).apply(this);
        if (aggregator != null) {
            aggregator.aggregate(result, new Split(null, fromIndex, toIndex));
        }
    }

    protected class FusedBloomFilter
    implements IBloomFilter {
        protected FusedBloomFilter() {
        }

        @Override
        public boolean add(byte[] key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(byte[] key) {
            AbstractBTree[] srcs = FusedView.this.getSources();
            for (int i = 0; i < srcs.length; ++i) {
                AbstractBTree src = srcs[i];
                BloomFilter filter = src.getBloomFilter();
                if (!((i == 0 || i == 1) && srcs.length > i + 1 && src instanceof BTree && srcs[i + 1].getBloomFilter() != null ? src.contains(key) : filter == null || filter.contains(key))) continue;
                return true;
            }
            return false;
        }

        @Override
        public void falsePos() {
            BloomFilter filter = FusedView.this.getMutableBTree().getBloomFilter();
            if (filter != null) {
                filter.falsePos();
            }
        }
    }

    private static class WeakRefSources
    implements ISources {
        private final int count;
        private final BTree btree;
        private final BTree[] btreeSources;
        private final IndexSegmentStore[] segmentStores;

        @Override
        public BTree getMutableBTree() {
            return this.btree;
        }

        @Override
        public int getSourceCount() {
            return this.count;
        }

        @Override
        public AbstractBTree[] getSources() {
            AbstractBTree[] a = new AbstractBTree[this.count];
            for (int i = 0; i < this.count; ++i) {
                a[i] = this.btreeSources[i] != null ? this.btreeSources[i] : this.segmentStores[i].loadIndexSegment();
            }
            return a;
        }

        @Override
        public Iterator<AbstractBTree> iterator() {
            return Arrays.asList(this.getSources()).iterator();
        }

        public WeakRefSources(AbstractBTree[] a) {
            FusedView.checkSources(a);
            this.count = a.length;
            this.btree = (BTree)a[0];
            this.btreeSources = new BTree[this.count];
            this.segmentStores = new IndexSegmentStore[this.count];
            for (int i = 0; i < this.count; ++i) {
                if (a[i] instanceof BTree) {
                    this.btreeSources[i] = (BTree)a[i];
                    continue;
                }
                this.segmentStores[i] = ((IndexSegment)a[i]).getStore();
            }
        }
    }

    private static class HardRefSources
    implements ISources {
        private final BTree btree;
        private final AbstractBTree[] srcs;

        @Override
        public BTree getMutableBTree() {
            return this.btree;
        }

        @Override
        public int getSourceCount() {
            return this.srcs.length;
        }

        @Override
        public Iterator<AbstractBTree> iterator() {
            return Arrays.asList(this.srcs).iterator();
        }

        @Override
        public final AbstractBTree[] getSources() {
            return (AbstractBTree[])this.srcs.clone();
        }

        public HardRefSources(AbstractBTree[] a) {
            FusedView.checkSources(a);
            this.btree = (BTree)a[0];
            this.srcs = (AbstractBTree[])a.clone();
        }
    }

    private static interface ISources
    extends Iterable<AbstractBTree> {
        public BTree getMutableBTree();

        public int getSourceCount();

        @Override
        public Iterator<AbstractBTree> iterator();

        public AbstractBTree[] getSources();
    }
}

