/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.BigdataStatics;
import com.bigdata.LRUNexus;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.cache.IGlobalLRU;
import com.bigdata.cache.IHardReferenceGlobalLRU;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.IDataRecordAccess;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IRawStore;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.util.concurrent.BufferedConcurrentHashMap;

public class BCHMGlobalLRU<V>
implements IHardReferenceGlobalLRU<Long, V> {
    private final long maximumBytesInMemory;
    private final ConcurrentWeakValueCache<UUID, InnerCacheImpl> cacheSet;
    private final BufferedConcurrentHashMap<K, V> map;
    private final LRUCounters counters = new LRUCounters();

    public BCHMGlobalLRU(LRUNexus.CacheSettings s) {
        this(s.maximumBytesInMemory, s.minCacheSetSize, s.limitingCacheCapacity, s.loadFactor, s.concurrencyLevel, s.accessPolicy);
    }

    public BCHMGlobalLRU(long maximumBytesInMemory, int minimumCacheSetCapacity, int limitingCacheCapacity, float loadFactor, int concurrencyLevel, LRUNexus.AccessPolicyEnum accessPolicy) {
        BufferedConcurrentHashMap.Eviction evictionMode;
        if (maximumBytesInMemory <= 0L) {
            throw new IllegalArgumentException();
        }
        this.maximumBytesInMemory = maximumBytesInMemory;
        this.cacheSet = new ConcurrentWeakValueCache(minimumCacheSetCapacity);
        switch (accessPolicy) {
            case LRU: {
                evictionMode = BufferedConcurrentHashMap.Eviction.LRU;
                break;
            }
            case LIRS: {
                evictionMode = BufferedConcurrentHashMap.Eviction.LIRS;
                break;
            }
            default: {
                throw new UnsupportedOperationException(accessPolicy.toString());
            }
        }
        BufferedConcurrentHashMap.EvictionListener evictionListener = new BufferedConcurrentHashMap.EvictionListener<K, V>(){
            private static final long serialVersionUID = 1L;

            public void evicted(K key, V value) {
                BCHMGlobalLRU.this.counters.bytesInMemory.addAndGet(key.bytesInMemory);
                BCHMGlobalLRU.this.counters.bytesOnDisk.addAndGet(key.bytesOnDisk);
                BCHMGlobalLRU.this.counters.evictionCount.incrementAndGet();
                BCHMGlobalLRU.this.counters.evictionByteCount.addAndGet(key.bytesInMemory);
            }
        };
        this.map = new BufferedConcurrentHashMap(limitingCacheCapacity, loadFactor, concurrencyLevel, evictionMode, evictionListener);
    }

    @Override
    public int getRecordCount() {
        return this.map.size();
    }

    @Override
    public long getEvictionCount() {
        return this.counters.evictionCount.get();
    }

    public long getEvictionByteCount() {
        return this.counters.evictionByteCount.get();
    }

    @Override
    public long getBytesOnDisk() {
        return this.counters.bytesOnDisk.get();
    }

    @Override
    public long getBytesInMemory() {
        return this.counters.bytesInMemory.get();
    }

    @Override
    public long getMaximumBytesInMemory() {
        return this.maximumBytesInMemory;
    }

    @Override
    public int getCacheSetSize() {
        return this.cacheSet.size();
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public IGlobalLRU.ILRUCache<Long, V> getCache(UUID uuid, IAddressManager am) {
        InnerCacheImpl oldVal;
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        InnerCacheImpl cache = this.cacheSet.get(uuid);
        if (cache == null && (oldVal = this.cacheSet.putIfAbsent(uuid, cache = new InnerCacheImpl(uuid, am))) != null) {
            cache = oldVal;
        }
        return cache;
    }

    @Override
    public void deleteCache(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        InnerCacheImpl cache = this.cacheSet.remove(uuid);
        if (cache != null) {
            cache.clear();
        }
    }

    @Override
    public void discardAllCaches() {
        this.cacheSet.clear();
        this.map.clear();
        this.counters.clear();
    }

    @Override
    public CounterSet getCounterSet() {
        return this.counters.getCounterSet();
    }

    public String toString() {
        String t = this.getCounterSet().toString();
        if (!BigdataStatics.debug) {
            return t;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t);
        Iterator<WeakReference<InnerCacheImpl>> itr = this.cacheSet.iterator();
        while (itr.hasNext()) {
            InnerCacheImpl cache = (InnerCacheImpl)itr.next().get();
            if (cache == null) continue;
            sb.append("\ncache: storeClass=" + cache.getStoreUUID() + ", size=" + cache.size());
        }
        return sb.toString();
    }

    private class InnerCacheImpl
    implements IGlobalLRU.ILRUCache<Long, V> {
        private final UUID storeUUID;
        private final IAddressManager am;

        @Override
        public IAddressManager getAddressManager() {
            return this.am;
        }

        @Override
        public UUID getStoreUUID() {
            return this.storeUUID;
        }

        public InnerCacheImpl(UUID storeUUID, IAddressManager am) {
            if (storeUUID == null) {
                throw new IllegalArgumentException();
            }
            assert (!(am instanceof IRawStore)) : am.getClass().getName() + " implements " + IRawStore.class.getName();
            this.storeUUID = storeUUID;
            this.am = am;
        }

        @Override
        public void clear() {
            Iterator itr = BCHMGlobalLRU.this.map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                if (!((K)e.getKey()).storeUUID.equals(this.storeUUID)) continue;
                itr.remove();
            }
        }

        @Override
        public V get(Long k) {
            return BCHMGlobalLRU.this.map.get((Object)new K(this.storeUUID, k));
        }

        @Override
        public V putIfAbsent(Long k, V v) {
            K k1 = new K(this.storeUUID, k, this.bytesOnDisk(k), this.bytesInMemory(v));
            Object oldVal = BCHMGlobalLRU.this.map.putIfAbsent((Object)k1, v);
            if (oldVal == null) {
                BCHMGlobalLRU.this.counters.bytesOnDisk.addAndGet(k1.bytesOnDisk);
                BCHMGlobalLRU.this.counters.bytesInMemory.addAndGet(k1.bytesInMemory);
            }
            return oldVal;
        }

        @Override
        public V remove(Long k) {
            Object v = BCHMGlobalLRU.this.map.remove((Object)new K(this.storeUUID, k));
            if (v != null) {
                BCHMGlobalLRU.this.counters.bytesOnDisk.addAndGet(this.bytesOnDisk(k));
                BCHMGlobalLRU.this.counters.bytesInMemory.addAndGet(this.bytesInMemory(v));
            }
            return v;
        }

        private int bytesOnDisk(long addr) {
            if (this.am != null) {
                return this.am.getByteCount(addr);
            }
            return 0;
        }

        private int bytesInMemory(V v) {
            if (v instanceof IDataRecordAccess) {
                return ((IDataRecordAccess)v).data().len();
            }
            return 0;
        }

        @Override
        public int size() {
            return BCHMGlobalLRU.this.map.size();
        }
    }

    private class LRUCounters {
        private final AtomicLong bytesOnDisk = new AtomicLong();
        private final AtomicLong bytesInMemory = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();
        private final AtomicLong evictionByteCount = new AtomicLong();

        private LRUCounters() {
        }

        public void clear() {
            this.bytesOnDisk.set(0L);
            this.bytesInMemory.set(0L);
            this.evictionCount.set(0L);
            this.evictionByteCount.set(0L);
        }

        public CounterSet getCounterSet() {
            CounterSet counters = new CounterSet();
            counters.addCounter("Bytes On Disk", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.bytesOnDisk.get());
                }
            });
            counters.addCounter("Bytes In Memory", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.bytesInMemory.get());
                }
            });
            counters.addCounter("Bytes In Memory Percent Used", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue((double)((int)((double)(10000L * LRUCounters.this.bytesInMemory.get()) / (double)BCHMGlobalLRU.this.maximumBytesInMemory)) / 10000.0);
                }
            });
            counters.addCounter("Bytes In Memory Maximum Allowed", new OneShotInstrument<Long>(BCHMGlobalLRU.this.maximumBytesInMemory));
            counters.addCounter("Buffered Record Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(BCHMGlobalLRU.this.size());
                }
            });
            counters.addCounter("Buffered Record Eviction Count", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.evictionCount.get());
                }
            });
            counters.addCounter("Buffered Record Eviction Byte Count", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.evictionByteCount.get());
                }
            });
            counters.addCounter("Average Record Size In Memory", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = BCHMGlobalLRU.this.size();
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(LRUCounters.this.bytesInMemory.get() / tmp));
                }
            });
            counters.addCounter("Average Record Size On Disk", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = BCHMGlobalLRU.this.size();
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(LRUCounters.this.bytesOnDisk.get() / tmp));
                }
            });
            counters.addCounter("Cache Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(BCHMGlobalLRU.this.cacheSet.size());
                }
            });
            return counters;
        }

        public String toString() {
            return this.getCounterSet().toString();
        }
    }

    private static class K {
        static final int mask1 = 0x10101010;
        static final int mask2 = -269488145;
        final UUID storeUUID;
        final long addr;
        final int hash;
        int bytesInMemory;
        int bytesOnDisk;

        public K(UUID storeUUID, long addr) {
            this.storeUUID = storeUUID;
            this.addr = addr;
            int addrHash = (int)(addr ^ addr >>> 32);
            this.hash = storeUUID.hashCode() & 0x10101010 | addrHash & 0xEFEFEFEF;
        }

        public K(UUID storeUUID, long addr, int bytesOnDisk, int bytesInMemory) {
            this(storeUUID, addr);
            this.bytesOnDisk = bytesOnDisk;
            this.bytesInMemory = bytesInMemory;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof K)) {
                return false;
            }
            K o1 = (K)o;
            return this.addr == o1.addr && this.storeUUID.equals(o1.storeUUID);
        }
    }
}

