/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.cache.HardReferenceQueueEvictionListener;
import com.bigdata.cache.IBatchedUpdateListener;
import com.bigdata.cache.IHardReferenceQueue;
import com.bigdata.cache.RingBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HardReferenceQueueWithBatchingUpdates<T>
implements IHardReferenceQueue<T> {
    private final int concurrencyLevel;
    private final boolean threadLocalBuffers;
    private final Lock[] permits;
    private final BatchQueue<T>[] buffers;
    private final ConcurrentHashMap<Thread, BatchQueue<T>> threadLocalQueues;
    private final int threadLocalQueueNScan;
    private final int threadLocalQueueCapacity;
    private final int threadLocalTryLockSize;
    private final IBatchedUpdateListener<T> batchedUpdatedListener;
    private final ReentrantLock lock = new ReentrantLock(false);
    private final IHardReferenceQueue<T> sharedQueue;
    private final HardReferenceQueueEvictionListener<T> threadLocalQueueEvictionListener;

    public HardReferenceQueueWithBatchingUpdates(IHardReferenceQueue<T> sharedQueue, int threadLocalQueueNScan, int threadLocalQueueCapacity, int threadLocalTryLockSize, IBatchedUpdateListener<T> batchedUpdateListener) {
        this(true, 16, sharedQueue, threadLocalQueueNScan, threadLocalQueueCapacity, threadLocalTryLockSize, batchedUpdateListener);
    }

    public HardReferenceQueueWithBatchingUpdates(boolean threadLocalBuffers, int concurrencyLevel, final IHardReferenceQueue<T> sharedQueue, int threadLocalQueueNScan, int threadLocalQueueCapacity, int threadLocalTryLockSize, IBatchedUpdateListener<T> batchedUpdateListener) {
        if (sharedQueue == null) {
            throw new IllegalArgumentException();
        }
        this.sharedQueue = sharedQueue;
        if (threadLocalQueueCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (threadLocalQueueNScan < 0 || threadLocalQueueNScan > threadLocalQueueCapacity) {
            throw new IllegalArgumentException();
        }
        if (threadLocalTryLockSize < 0 || threadLocalTryLockSize > threadLocalQueueCapacity) {
            throw new IllegalArgumentException();
        }
        this.threadLocalQueueNScan = threadLocalQueueNScan;
        this.threadLocalQueueCapacity = threadLocalQueueCapacity;
        this.threadLocalTryLockSize = threadLocalQueueCapacity;
        this.batchedUpdatedListener = batchedUpdateListener;
        this.threadLocalQueueEvictionListener = new HardReferenceQueueEvictionListener<T>(){

            @Override
            public void evicted(IHardReferenceQueue<T> cache, T ref) {
                sharedQueue.add(ref);
            }
        };
        this.threadLocalBuffers = threadLocalBuffers;
        this.concurrencyLevel = concurrencyLevel;
        if (threadLocalBuffers) {
            this.permits = null;
            this.buffers = null;
            this.threadLocalQueues = new ConcurrentHashMap(16, 0.75f, concurrencyLevel);
        } else {
            this.permits = new Lock[concurrencyLevel];
            this.buffers = new BatchQueue[concurrencyLevel];
            this.threadLocalQueues = null;
            for (int i = 0; i < concurrencyLevel; ++i) {
                this.permits[i] = new ReentrantLock(false);
                this.buffers[i] = new BatchQueue<T>(i, threadLocalQueueNScan, threadLocalQueueCapacity, threadLocalTryLockSize, this.lock, this.threadLocalQueueEvictionListener, this.batchedUpdatedListener);
            }
        }
    }

    private final BatchQueue<T> getThreadLocalQueue() {
        Thread t = Thread.currentThread();
        BatchQueue<T> tmp = this.threadLocalQueues.get(t);
        if (tmp == null && this.threadLocalQueues.put(t, tmp = new BatchQueue<T>(0, this.threadLocalQueueNScan, this.threadLocalQueueCapacity, this.threadLocalTryLockSize, this.lock, this.threadLocalQueueEvictionListener, this.batchedUpdatedListener)) != null) {
            throw new AssertionError();
        }
        return tmp;
    }

    @Override
    public int size() {
        return this.sharedQueue.size();
    }

    @Override
    public int capacity() {
        return this.sharedQueue.capacity();
    }

    @Override
    public int nscan() {
        return this.sharedQueue.nscan();
    }

    @Override
    public boolean evict() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void evictAll(boolean clearRefs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFull() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean add(T ref) {
        if (this.threadLocalBuffers) {
            return this.getThreadLocalQueue().add(ref);
        }
        int i = this.hash(ref);
        BatchQueue<T> t = null;
        try {
            this.permits[i].lockInterruptibly();
            t = this.buffers[i];
            boolean bl = t.add(ref);
            return bl;
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (t != null) {
                this.permits[i].unlock();
            }
        }
    }

    private int hash(T ref) {
        int h = (int)(Thread.currentThread().getId() % (long)this.concurrencyLevel);
        return h;
    }

    public final boolean offer(T ref) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear(boolean clearRefs) {
        this.lock.lock();
        try {
            if (this.threadLocalBuffers) {
                for (BatchQueue<T> q : this.threadLocalQueues.values()) {
                    q.clear(clearRefs);
                }
                this.threadLocalQueues.clear();
            } else {
                for (BatchQueue<T> q : this.buffers) {
                    q.clear(clearRefs);
                }
            }
            this.sharedQueue.clear(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public final boolean contains(Object ref) {
        throw new UnsupportedOperationException();
    }

    private static class BatchQueue<T>
    extends RingBuffer<T>
    implements IHardReferenceQueue<T> {
        private final int id;
        private final int nscan;
        private final int tryLockSize;
        private final Lock lock;
        private final HardReferenceQueueEvictionListener<T> listener;
        private final IBatchedUpdateListener<T> batchedUpdatedListener;

        public BatchQueue(int id, int nscan, int capacity, int tryLockSize, ReentrantLock lock, HardReferenceQueueEvictionListener<T> listener, IBatchedUpdateListener<T> batchedUpdateListener) {
            super(capacity);
            this.id = id;
            this.nscan = nscan;
            this.tryLockSize = tryLockSize;
            this.lock = lock;
            this.listener = listener;
            this.batchedUpdatedListener = batchedUpdateListener;
        }

        @Override
        public int nscan() {
            return this.nscan;
        }

        @Override
        public boolean add(T ref) {
            if (this.nscan > 0 && this.scanHead(this.nscan, ref)) {
                return false;
            }
            return super.add(ref);
        }

        @Override
        public boolean offer(T ref) {
            if (this.nscan > 0 && this.scanHead(this.nscan, ref)) {
                return false;
            }
            return super.offer(ref);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeOffer(T ref) {
            if (this.tryLockSize != 0 && this.size == this.tryLockSize) {
                if (this.lock.tryLock()) {
                    try {
                        this.evictAll(true);
                        if (this.batchedUpdatedListener != null) {
                            this.batchedUpdatedListener.didBatchUpdates();
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                return;
            }
            if (this.size + 1 == this.capacity) {
                this.lock.lock();
                try {
                    this.evictAll(true);
                    if (this.batchedUpdatedListener != null) {
                        this.batchedUpdatedListener.didBatchUpdates();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        @Override
        public boolean evict() {
            Object ref = this.poll();
            if (ref == null) {
                return false;
            }
            if (this.listener != null) {
                this.listener.evicted(this, ref);
            }
            return true;
        }

        @Override
        public final void evictAll(boolean clearRefs) {
            if (clearRefs) {
                while (!this.isEmpty()) {
                    this.evict();
                }
            } else {
                int size = this.size();
                for (int n = 0; n < size; ++n) {
                    Object ref = this.get(n);
                    if (this.listener == null) continue;
                    this.listener.evicted(this, ref);
                }
            }
        }
    }
}

