/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.cache.HardReferenceQueue;
import com.bigdata.cache.HardReferenceQueueEvictionListener;
import com.bigdata.cache.IHardReferenceQueue;

public class SynchronizedHardReferenceQueue<T>
implements IHardReferenceQueue<T> {
    protected final HardReferenceQueue<T> queue;

    public SynchronizedHardReferenceQueue(HardReferenceQueueEvictionListener<T> listener, int capacity) {
        this(listener, capacity, 10);
    }

    public SynchronizedHardReferenceQueue(HardReferenceQueueEvictionListener<T> listener, int capacity, int nscan) {
        this.queue = new InnerHardReferenceQueue(listener, capacity, 10);
    }

    protected void beforeOffer(T t) {
    }

    @Override
    public final int capacity() {
        return this.queue.capacity();
    }

    public HardReferenceQueueEvictionListener<T> getListener() {
        return this.queue.getListener();
    }

    @Override
    public int nscan() {
        return this.queue.nscan();
    }

    @Override
    public synchronized boolean add(T ref) {
        return this.queue.add(ref);
    }

    @Override
    public synchronized void clear(boolean clearRefs) {
        this.queue.clear(clearRefs);
    }

    @Override
    public synchronized boolean evict() {
        return this.queue.evict();
    }

    @Override
    public synchronized void evictAll(boolean clearRefs) {
        this.queue.evictAll(clearRefs);
    }

    @Override
    public synchronized T peek() {
        return this.queue.peek();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public synchronized boolean isFull() {
        return this.queue.isFull();
    }

    public synchronized boolean scanHead(int nscan, T ref) {
        return this.queue.scanHead(nscan, ref);
    }

    public synchronized boolean scanTail(int nscan, T ref) {
        return this.queue.scanTail(nscan, ref);
    }

    @Override
    public synchronized int size() {
        return this.queue.size();
    }

    private final class InnerHardReferenceQueue
    extends HardReferenceQueue<T> {
        public InnerHardReferenceQueue(HardReferenceQueueEvictionListener<T> listener, int capacity, int nscan) {
            super(listener, capacity, nscan);
        }

        @Override
        protected final void beforeOffer(T ref) {
            SynchronizedHardReferenceQueue.this.beforeOffer(ref);
            super.beforeOffer(ref);
        }
    }
}

