/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.BigdataStatics;
import com.bigdata.LRUNexus;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.cache.IGlobalLRU;
import com.bigdata.cache.IHardReferenceQueue;
import com.bigdata.cache.SynchronizedHardReferenceQueue;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.IDataRecordAccess;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IRawStore;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WeakReferenceGlobalLRU
implements IGlobalLRU<Long, Object> {
    private final LRUCounters counters = new LRUCounters();
    private final long maximumBytesInMemory;
    private final int initialCapacity;
    private final float loadFactor;
    private final int concurrencyLevel;
    private final IHardReferenceQueue<Object> globalLRU;
    private final ConcurrentWeakValueCache<UUID, CacheImpl<Object>> cacheSet;

    public WeakReferenceGlobalLRU(LRUNexus.CacheSettings s) {
        this(s.maximumBytesInMemory, s.minCacheSetSize, s.queueCapacity, s.nscan, s.initialCacheCapacity, s.loadFactor, s.concurrencyLevel);
    }

    public WeakReferenceGlobalLRU(long maximumMemoryFootprint, int minimumCacheSetCapacity, int queueCapacity, int nscan, int initialCapacity, float loadFactor, int concurrencyLevel) {
        if (BigdataStatics.debug) {
            System.err.println("maximumMemoryFootprint=" + maximumMemoryFootprint + ", queueCapacity=" + queueCapacity + ", initialCapacity=" + initialCapacity);
        }
        this.maximumBytesInMemory = maximumMemoryFootprint;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.concurrencyLevel = concurrencyLevel;
        this.globalLRU = new LRU<Object>(queueCapacity, nscan);
        this.cacheSet = new ConcurrentWeakValueCache(minimumCacheSetCapacity);
    }

    @Override
    public IGlobalLRU.ILRUCache<Long, Object> getCache(UUID uuid, IAddressManager am) {
        CacheImpl<Object> oldVal;
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        CacheImpl<Object> cache = this.cacheSet.get(uuid);
        if (cache == null && (oldVal = this.cacheSet.putIfAbsent(uuid, cache = new CacheImpl<Object>(uuid, am, this.globalLRU, this.initialCapacity, this.loadFactor, this.concurrencyLevel, true))) != null) {
            cache = oldVal;
        }
        return cache;
    }

    @Override
    public void deleteCache(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        CacheImpl<Object> cache = this.cacheSet.remove(uuid);
        if (cache != null) {
            cache.clear();
        }
    }

    @Override
    public void discardAllCaches() {
        this.globalLRU.clear(true);
    }

    @Override
    public CounterSet getCounterSet() {
        return this.counters.getCounterSet();
    }

    @Override
    public long getBytesInMemory() {
        return this.counters.bytesInMemory.get();
    }

    @Override
    public long getBytesOnDisk() {
        return this.counters.bytesOnDisk.get();
    }

    @Override
    public int getCacheSetSize() {
        return this.cacheSet.size();
    }

    @Override
    public long getEvictionCount() {
        return this.counters.evictionCount.get();
    }

    @Override
    public long getMaximumBytesInMemory() {
        return this.maximumBytesInMemory;
    }

    @Override
    public int getRecordCount() {
        return this.counters.lruDistinctCount.get();
    }

    public String toString() {
        String t = this.getCounterSet().toString();
        if (!BigdataStatics.debug) {
            return t;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t);
        Iterator<WeakReference<CacheImpl<Object>>> itr = this.cacheSet.iterator();
        while (itr.hasNext()) {
            CacheImpl cache = (CacheImpl)itr.next().get();
            if (cache == null) continue;
            sb.append("\ncache: storeClass=" + cache.getStoreUUID() + ", size=" + cache.size());
        }
        return sb.toString();
    }

    private class LRUCounters {
        private final AtomicLong bytesOnDisk = new AtomicLong();
        private final AtomicLong bytesInMemory = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();
        private final AtomicInteger lruDistinctCount = new AtomicInteger();

        private LRUCounters() {
        }

        public CounterSet getCounterSet() {
            CounterSet counters = new CounterSet();
            counters.addCounter("Bytes On Disk", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.bytesOnDisk.get());
                }
            });
            counters.addCounter("Bytes In Memory", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.bytesInMemory.get());
                }
            });
            counters.addCounter("Bytes In Memory Percent Used", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue((double)((int)((double)(10000L * LRUCounters.this.bytesInMemory.get()) / (double)WeakReferenceGlobalLRU.this.maximumBytesInMemory)) / 10000.0);
                }
            });
            counters.addCounter("Bytes In Memory Maximum Allowed", new OneShotInstrument<Long>(WeakReferenceGlobalLRU.this.maximumBytesInMemory));
            counters.addCounter("Buffered Record Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.lruDistinctCount.get());
                }
            });
            counters.addCounter("Buffered Record Eviction Count", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.evictionCount.get());
                }
            });
            counters.addCounter("Average Record Size In Memory", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = LRUCounters.this.lruDistinctCount.get();
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(LRUCounters.this.bytesInMemory.get() / tmp));
                }
            });
            counters.addCounter("Average Record Size On Disk", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = LRUCounters.this.lruDistinctCount.get();
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(LRUCounters.this.bytesOnDisk.get() / tmp));
                }
            });
            counters.addCounter("Cache Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(WeakReferenceGlobalLRU.this.cacheSet.size());
                }
            });
            counters.addCounter("LRU Capacity", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(WeakReferenceGlobalLRU.this.globalLRU.capacity());
                }
            });
            counters.addCounter("LRU Size", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(WeakReferenceGlobalLRU.this.globalLRU.size());
                }
            });
            counters.addCounter("LRU Percent Used", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue((double)((int)((double)(10000L * (long)WeakReferenceGlobalLRU.this.globalLRU.size()) / (double)WeakReferenceGlobalLRU.this.globalLRU.capacity())) / 10000.0);
                }
            });
            counters.addCounter("LRU Percent Distinct", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue((double)((int)((double)(10000 * LRUCounters.this.lruDistinctCount.get()) / (double)WeakReferenceGlobalLRU.this.globalLRU.capacity())) / 10000.0);
                }
            });
            return counters;
        }

        public String toString() {
            return this.getCounterSet().toString();
        }
    }

    private class LRU<V>
    extends SynchronizedHardReferenceQueue<V> {
        public LRU(int capacity, int nscan) {
            super(null, capacity, nscan);
        }

        @Override
        protected void beforeOffer(V v) {
            if (WeakReferenceGlobalLRU.this.counters.bytesInMemory.get() > WeakReferenceGlobalLRU.this.maximumBytesInMemory) {
                for (int i = 0; i < 10 && !this.isEmpty(); ++i) {
                    this.evict();
                }
            }
        }
    }

    private class CacheImpl<V>
    implements IGlobalLRU.ILRUCache<Long, V> {
        private final UUID storeUUID;
        private final IAddressManager am;
        private final ConcurrentWeakValueCache<Long, V> map;

        public CacheImpl(UUID storeUUID, IAddressManager am, IHardReferenceQueue<V> queue, int initialCapacity, float loadFactor, int concurrencyLevel, boolean removeClearedReferences) {
            if (storeUUID == null) {
                throw new IllegalArgumentException();
            }
            this.storeUUID = storeUUID;
            assert (!(am instanceof IRawStore)) : am.getClass().getName() + " implements " + IRawStore.class.getName();
            this.am = am;
            this.map = new InnerCacheImpl(queue, initialCapacity, loadFactor, concurrencyLevel, removeClearedReferences);
        }

        @Override
        public IAddressManager getAddressManager() {
            return this.am;
        }

        @Override
        public UUID getStoreUUID() {
            return this.storeUUID;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public V get(Long k) {
            return this.map.get(k);
        }

        @Override
        public V putIfAbsent(Long k, V v) {
            return this.map.putIfAbsent(k, v);
        }

        @Override
        public V remove(Long k) {
            return this.map.remove(k);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        private class InnerCacheImpl
        extends ConcurrentWeakValueCache<Long, V> {
            public InnerCacheImpl(IHardReferenceQueue<V> queue, int initialCapacity, float loadFactor, int concurrencyLevel, boolean removeClearedReferences) {
                super(queue, initialCapacity, loadFactor, concurrencyLevel, removeClearedReferences);
            }

            @Override
            protected WeakReference<V> removeMapEntry(Long k) {
                WeakRef2 weakRef = (WeakRef2)super.removeMapEntry(k);
                WeakReferenceGlobalLRU.this.counters.bytesInMemory.addAndGet(-weakRef.bytesInMemory);
                WeakReferenceGlobalLRU.this.counters.bytesOnDisk.addAndGet(-weakRef.bytesOnDisk);
                WeakReferenceGlobalLRU.this.counters.evictionCount.decrementAndGet();
                WeakReferenceGlobalLRU.this.counters.lruDistinctCount.decrementAndGet();
                return weakRef;
            }

            @Override
            protected void didUpdate(Long k, WeakReference<V> newRef, WeakReference<V> oldRef) {
                Object newVal = newRef.get();
                if (!(newVal instanceof IDataRecordAccess)) {
                    return;
                }
                long deltaBytesInMemory = ((WeakRef2)newRef).bytesInMemory;
                long deltaBytesOnDisk = ((WeakRef2)newRef).bytesOnDisk;
                if (oldRef != null) {
                    deltaBytesInMemory -= (long)((WeakRef2)oldRef).bytesInMemory;
                    deltaBytesOnDisk -= (long)((WeakRef2)oldRef).bytesOnDisk;
                } else {
                    WeakReferenceGlobalLRU.this.counters.lruDistinctCount.incrementAndGet();
                }
                if (deltaBytesInMemory != 0L) {
                    WeakReferenceGlobalLRU.this.counters.bytesInMemory.addAndGet(deltaBytesInMemory);
                }
                if (deltaBytesOnDisk != 0L) {
                    WeakReferenceGlobalLRU.this.counters.bytesOnDisk.addAndGet(deltaBytesOnDisk);
                }
            }

            @Override
            protected WeakReference<V> newWeakRef(Long k, V v, ReferenceQueue<V> referenceQueue) {
                return new WeakRef2(k, v, referenceQueue);
            }

            private class WeakRef2
            extends ConcurrentWeakValueCache.WeakRef<Long, V> {
                public final int bytesOnDisk;
                public final int bytesInMemory;

                public WeakRef2(Long k, V v, ReferenceQueue<V> queue) {
                    super(k, v, queue);
                    this.bytesInMemory = v instanceof IDataRecordAccess ? ((IDataRecordAccess)v).data().len() : 0;
                    this.bytesOnDisk = CacheImpl.this.am != null ? CacheImpl.this.am.getByteCount(k) : 0;
                }
            }
        }
    }
}

