/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public abstract class ProcessReaderHelper
extends AbstractProcessReader {
    protected LineNumberReader r = null;

    @Override
    public void start(InputStream is) {
        if (this.r != null) {
            throw new IllegalStateException();
        }
        super.start(is);
        this.r = new LineNumberReader(new InputStreamReader(is));
    }

    protected abstract ActiveProcess getActiveProcess();

    public String readLine() throws IOException, InterruptedException {
        while (this.getActiveProcess().isAlive()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (!this.r.ready()) {
                Thread.sleep(100L);
                continue;
            }
            String s = this.r.readLine();
            if (log.isDebugEnabled()) {
                log.debug((Object)s);
            }
            return s;
        }
        throw new IOException("Closed");
    }

    @Override
    public void run() {
        try {
            this.readProcess();
        }
        catch (InterruptedException e) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Interrupted - will halt.");
            }
        }
        catch (Exception e) {
            log.error((Object)("Counter collection halted: " + e.getMessage()), (Throwable)e);
        }
    }

    protected abstract void readProcess() throws Exception;
}

