/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.ganglia;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.ganglia.BigdataMetadataFactory;
import com.bigdata.counters.ganglia.HostMetricsCollector;
import com.bigdata.counters.ganglia.ServiceMetricsCollector;
import com.bigdata.ganglia.DefaultMetadataFactory;
import com.bigdata.ganglia.GangliaMetadataFactory;
import com.bigdata.ganglia.GangliaService;
import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.IGangliaDefaults;
import com.bigdata.ganglia.IGangliaMetadataFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Properties;

public class BigdataGangliaService
extends GangliaService {
    public BigdataGangliaService(String hostName, String serviceName, InetSocketAddress[] metricsServers, InetAddress listenGroup, int listenPort, boolean listen, boolean report, boolean mock, int quietPeriod, int initialDelay, int heartbeatInterval, int monitoringInterval, int globalDMax, IGangliaMetadataFactory metadataFactory) {
        super(hostName, serviceName, metricsServers, listenGroup, listenPort, listen, report, mock, quietPeriod, initialDelay, heartbeatInterval, monitoringInterval, globalDMax, metadataFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String hostName = BigdataGangliaService.getCanonicalHostName();
        String serviceName = GangliaService.class.getSimpleName();
        int quietPeriod = 600;
        int initialDelay = 20;
        boolean heartbeatInterval = false;
        int monitoringInterval = 5;
        InetAddress listenGroup = InetAddress.getByName("239.2.11.71");
        int listenPort = 8649;
        String defaultUnits = "";
        GangliaSlopeEnum defaultSlope = IGangliaDefaults.DEFAULT_SLOPE;
        int defaultTMax = 180;
        int defaultDMax = 3600;
        InetSocketAddress[] metricsServers = new InetSocketAddress[]{new InetSocketAddress("239.2.11.71", 8649)};
        GangliaMetadataFactory metadataFactory = new GangliaMetadataFactory(new DefaultMetadataFactory("", defaultSlope, 180, 3600));
        metadataFactory.add(new BigdataMetadataFactory(hostName, serviceName, defaultSlope, 180, 3600, 0));
        GangliaService service = null;
        AbstractStatisticsCollector statisticsCollector = null;
        try {
            service = new GangliaService(hostName, serviceName, metricsServers, listenGroup, 8649, true, true, false, 600, 20, 0, 5, 3600, metadataFactory);
            Properties properties = new Properties();
            properties.setProperty(AbstractStatisticsCollector.Options.PROCESS_NAME, serviceName);
            properties.setProperty(AbstractStatisticsCollector.Options.PERFORMANCE_COUNTERS_SAMPLE_INTERVAL, "5");
            statisticsCollector = AbstractStatisticsCollector.newInstance(properties);
            statisticsCollector.start();
            service.addMetricCollector(new HostMetricsCollector(statisticsCollector));
            service.addMetricCollector(new ServiceMetricsCollector(statisticsCollector, null));
            service.run();
        }
        finally {
            if (statisticsCollector != null) {
                statisticsCollector.stop();
            }
        }
    }
}

