/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.ganglia;

import com.bigdata.ganglia.GangliaCoreMetricDecls;
import com.bigdata.ganglia.GangliaMessageTypeEnum;
import com.bigdata.ganglia.GangliaMetadataMessage;
import com.bigdata.ganglia.GangliaMunge;
import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.IGangliaMetadataFactory;
import com.bigdata.ganglia.IGangliaMetadataMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BigdataMetadataFactory
extends GangliaCoreMetricDecls
implements IGangliaMetadataFactory {
    protected final String serviceName;
    private final Map<String, IGangliaMetadataMessage> hostDecls;
    private final Map<String, IGangliaMetadataMessage> serviceDecls;
    private final Map<String, IGangliaMetadataMessage> resolveDecls;

    protected void addHostCounter(String metricName, IGangliaMetadataMessage decl) {
        this.addHostCounter(metricName, decl, false);
    }

    protected void addHostCounter(String metricName, IGangliaMetadataMessage decl, boolean prefer) {
        if (prefer) {
            this.resolveDecls.put(decl.getMetricName(), decl);
        }
        this.hostDecls.put(GangliaMunge.munge(metricName.replace('/', '.')), decl);
    }

    protected void addServiceCounter(String metricName, IGangliaMetadataMessage decl) {
        this.addServiceCounter(metricName, decl, false);
    }

    protected void addServiceCounter(String metricName, IGangliaMetadataMessage decl, boolean prefer) {
        if (prefer) {
            this.resolveDecls.put(decl.getMetricName(), decl);
        }
        this.serviceDecls.put(GangliaMunge.munge(metricName.replace('/', '.')), decl);
    }

    @Override
    public IGangliaMetadataMessage newDecl(String hostName, String metricName, Object value) {
        IGangliaMetadataMessage decl = null;
        decl = this.hostDecls.get(metricName);
        if (decl != null) {
            return decl;
        }
        decl = this.serviceDecls.get(metricName);
        if (decl != null) {
            return decl;
        }
        return decl;
    }

    @Override
    public IGangliaMetadataMessage resolve(IGangliaMetadataMessage decl) {
        IGangliaMetadataMessage newDecl = this.resolveDecls.get(decl);
        if (newDecl != null) {
            return newDecl;
        }
        return decl;
    }

    public BigdataMetadataFactory(String hostName, String serviceName, GangliaSlopeEnum slope, int tmax, int dmax, int heartbeatInterval) {
        super(hostName, slope, tmax, dmax, heartbeatInterval);
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        this.serviceName = serviceName;
        this.hostDecls = new ConcurrentHashMap<String, IGangliaMetadataMessage>();
        this.serviceDecls = new ConcurrentHashMap<String, IGangliaMetadataMessage>();
        this.resolveDecls = new ConcurrentHashMap<String, IGangliaMetadataMessage>();
        this.addHostMetrics();
        this.addServiceCPUMetrics();
    }

    protected void addHostMetrics() {
        this.addHostInfoMetrics();
        this.addHostCPUMetrics();
        this.addHostMemoryMetrics();
        this.addHostDiskMetrics();
    }

    protected void addHostInfoMetrics() {
        this.addHostCounter("Info/Number of Processors", this.cpu_num());
        this.addHostCounter("Info/Operating System Name", this.os_name());
        this.addHostCounter("Info/Operating System Version", this.os_release());
    }

    protected void addHostCPUMetrics() {
        this.addHostCounter("CPU/% System Time", this.cpu_system());
        this.addHostCounter("CPU/% User Time", this.cpu_user());
        this.addHostCounter("CPU/% IO Wait", this.cpu_wio());
    }

    protected void addHostMemoryMetrics() {
        this.addHostCounter("Memory/Bytes Free", new GangliaMetadataMessage(this.hostName, "mem_free", false, GangliaMessageTypeEnum.FLOAT, "mem_free", "KB", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("memory", "Free Memory", "Amount of available memory")){

            @Override
            public Object translateValue(Object value) {
                return ((Number)value).doubleValue() / 1024.0;
            }
        });
        this.addHostCounter("Memory/Major Page Faults Per Second", new GangliaMetadataMessage(this.hostName, "mem_faults_major", false, GangliaMessageTypeEnum.DOUBLE, "mem_faults_major", "faults/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("memory", "Major page faults", "Faults which required loading a page from disk.")));
        this.addHostCounter("Memory/Minor Faults per Second", new GangliaMetadataMessage(this.hostName, "mem_faults_minor", false, GangliaMessageTypeEnum.DOUBLE, "mem_faults_minor", "faults/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("memory", "Minor page faults", "Faults that did not require loading a page from disk.")));
        this.addHostCounter("Memory/Swap Bytes Available", this.swap_total());
    }

    protected void addHostDiskMetrics() {
        this.addHostCounter("PhysicalDisk/Reads Per Second", new GangliaMetadataMessage(this.hostName, "disk_reads", false, GangliaMessageTypeEnum.DOUBLE, "disk_reads", "reads/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("disk", "Disk Reads Per Second", "The #of disk read operations per second.")));
        this.addHostCounter("PhysicalDisk/Writes Per Second", new GangliaMetadataMessage(this.hostName, "disk_writes", false, GangliaMessageTypeEnum.DOUBLE, "disk_writes", "writes/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("disk", "Disk Writes Per Second", "The #of disk write operations per second.")));
        this.addHostCounter("PhysicalDisk/Transfers Per Second", new GangliaMetadataMessage(this.hostName, "disk_xfers", false, GangliaMessageTypeEnum.DOUBLE, "disk_xfers", "xfers/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("disk", "Disk Transfers Per Second", "Disk operations per second for the host (total of disk reads per second and disk writes per second)")));
        this.addHostCounter("PhysicalDisk/Bytes Read Per Second", new GangliaMetadataMessage(this.hostName, "disk_bytes_read", false, GangliaMessageTypeEnum.DOUBLE, "disk_bytes_read", "bytes/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("disk", "Disk Bytes Read Per Second", "Disk bytes read per second for the host")));
        this.addHostCounter("PhysicalDisk/Bytes Written Per Second", new GangliaMetadataMessage(this.hostName, "disk_bytes_written", false, GangliaMessageTypeEnum.DOUBLE, "disk_bytes_written", "bytes/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("disk", "Disk Bytes Written Per Second", "Disk bytes written per second for the host")));
        this.addHostCounter("PhysicalDisk/Bytes Per Second", new GangliaMetadataMessage(this.hostName, "disk_bytes", false, GangliaMessageTypeEnum.DOUBLE, "disk_bytes", "bytes/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("disk", "Disk Bytes Per Second", "Disk bytes per second for the host (total of bytes read and bytes written per second)")));
    }

    protected void addServiceMetrics() {
        this.addServiceInfoMetrics();
        this.addServiceCPUMetrics();
        this.addServiceMemoryMetrics();
        this.addServiceDiskMetrics();
    }

    protected String getServiceMetricName(String group, String label) {
        return group + "_" + label;
    }

    protected void addServiceInfoMetrics() {
    }

    protected void addServiceCPUMetrics() {
        this.addServiceCounter("CPU/% Processor Time", new GangliaMetadataMessage(this.hostName, this.getServiceMetricName("cpu", "cpu_total"), false, GangliaMessageTypeEnum.DOUBLE, this.getServiceMetricName("cpu", "cpu_total"), "%", GangliaSlopeEnum.both, 90, this.dmax, BigdataMetadataFactory.getMap("cpu", "CPU Total", "Percentage of the time the processor is not idle")));
        this.addServiceCounter("CPU/% System Time", new GangliaMetadataMessage(this.hostName, this.getServiceMetricName("cpu", "cpu_system"), false, GangliaMessageTypeEnum.DOUBLE, this.getServiceMetricName("cpu", "cpu_system"), "%", GangliaSlopeEnum.both, 90, this.dmax, BigdataMetadataFactory.getMap("cpu", "System Time", "Percentage of the time the processor is not idle that it is executing at the system (aka kernel) level (normalized to 100% in single CPU and SMP environments)")));
        this.addServiceCounter("CPU/% User Time", new GangliaMetadataMessage(this.hostName, this.getServiceMetricName("cpu", "cpu_user"), false, GangliaMessageTypeEnum.DOUBLE, this.getServiceMetricName("cpu", "cpu_user"), "%", GangliaSlopeEnum.both, 90, this.dmax, BigdataMetadataFactory.getMap("cpu", "User Time", "Percentage of the time the processor is not idle that it is executing at the user level (normalized to 100% in single CPU and SMP environments)")));
    }

    protected void addServiceMemoryMetrics() {
        this.addHostCounter("Memory/Major Page Faults Per Second", new GangliaMetadataMessage(this.hostName, this.getServiceMetricName("memory", "mem_faults_major"), false, GangliaMessageTypeEnum.DOUBLE, this.getServiceMetricName("memory", "mem_faults_major"), "faults/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("memory", "Major Page Faults", "Faults which required loading a page from disk")));
        this.addHostCounter("Memory/Minor Faults per Second", new GangliaMetadataMessage(this.hostName, this.getServiceMetricName("memory", "mem_faults_minor"), false, GangliaMessageTypeEnum.DOUBLE, this.getServiceMetricName("memory", "mem_faults_minor"), "faults/sec", this.slope, this.tmax, this.dmax, BigdataMetadataFactory.getMap("memory", "Minor Page Faults", "Faults that did not require loading a page from disk")));
    }

    protected void addServiceDiskMetrics() {
    }
}

