/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.ganglia;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounter;
import com.bigdata.ganglia.GangliaMunge;
import com.bigdata.ganglia.IGangliaMetricsCollector;
import com.bigdata.ganglia.IGangliaMetricsReporter;
import java.util.Iterator;
import java.util.regex.Pattern;

public class HostMetricsCollector
implements IGangliaMetricsCollector {
    static final Pattern filter = Pattern.compile("^(?!.*/service/).*$");
    private final AbstractStatisticsCollector statisticsCollector;

    public HostMetricsCollector(AbstractStatisticsCollector statisticsCollector) {
        if (statisticsCollector == null) {
            throw new IllegalArgumentException();
        }
        this.statisticsCollector = statisticsCollector;
    }

    @Override
    public void collect(IGangliaMetricsReporter reporter) {
        String basePrefix = "/" + AbstractStatisticsCollector.fullyQualifiedHostName + "/";
        CounterSet counters = (CounterSet)this.statisticsCollector.getCounters().getPath(basePrefix);
        Iterator<ICounter> itr = counters.getCounters(filter);
        while (itr.hasNext()) {
            ICounter c = itr.next();
            Object value = c.getInstrument().getValue();
            String path = c.getPath();
            String metricName = GangliaMunge.munge(path.substring(basePrefix.length()).replace('/', '.'));
            reporter.setMetric(metricName, value);
        }
    }
}

