/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.ganglia;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounter;
import com.bigdata.ganglia.GangliaMunge;
import com.bigdata.ganglia.IGangliaMetricsCollector;
import com.bigdata.ganglia.IGangliaMetricsReporter;
import com.bigdata.journal.IIndexManager;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IFederationDelegate;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class QueryEngineMetricsCollector
implements IGangliaMetricsCollector {
    private static Logger log = Logger.getLogger(QueryEngineMetricsCollector.class);
    private final IIndexManager indexManager;
    private final AbstractStatisticsCollector statisticsCollector;

    public QueryEngineMetricsCollector(IIndexManager indexManager, AbstractStatisticsCollector statisticsCollector) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        if (statisticsCollector == null) {
            throw new IllegalArgumentException();
        }
        this.indexManager = indexManager;
        this.statisticsCollector = statisticsCollector;
    }

    @Override
    public void collect(IGangliaMetricsReporter reporter) {
        CounterSet counters;
        String basePrefix = "/" + AbstractStatisticsCollector.fullyQualifiedHostName + "/" + this.statisticsCollector.getProcessName() + "/";
        String pathPrefix = basePrefix + "Query Engine";
        if (this.indexManager instanceof IBigdataFederation) {
            ((IFederationDelegate)((Object)this.indexManager)).reattachDynamicCounters();
        }
        if ((counters = (CounterSet)this.indexManager.getCounters().getPath(pathPrefix)) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Counters not yet available for service.");
            }
            return;
        }
        Iterator<ICounter> itr = counters.getCounters(null);
        while (itr.hasNext()) {
            ICounter c = itr.next();
            Object value = c.getInstrument().getValue();
            String path = c.getPath();
            String s = path.substring(basePrefix.length());
            String metricName = GangliaMunge.munge(s.replace('/', '.'));
            reporter.setMetric(metricName, value);
        }
    }
}

