/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.httpd;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.service.Event;
import com.bigdata.service.EventReceiver;
import com.bigdata.service.IService;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.UUID;

public class DummyEventReportingService
extends EventReceiver
implements IService {
    final UUID serviceUUID = UUID.randomUUID();

    public DummyEventReportingService() {
        super(Long.MAX_VALUE, EventReceiver.EventBTree.createTransient());
    }

    public void readCSV(BufferedReader reader) throws IOException {
        String row;
        String header = reader.readLine();
        if (header == null) {
            return;
        }
        if (!header.startsWith(Event.getHeader())) {
            throw new IOException("Invalid schema");
        }
        LinkedList<Event> events = new LinkedList<Event>();
        int lineno = 0;
        while ((row = reader.readLine()) != null) {
            ++lineno;
            try {
                Event e = Event.fromString(row);
                events.add(e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("skipping bad row: " + row);
                throw new IOException("bad row(" + lineno + ") : " + row);
            }
        }
        Collections.sort(events, new Comparator<Event>(){

            @Override
            public int compare(Event e1, Event e2) {
                if (e1.getStartTime() < e2.getStartTime()) {
                    return -1;
                }
                if (e1.getStartTime() > e2.getStartTime()) {
                    return 1;
                }
                return 0;
            }
        });
        for (Event e : events) {
            this.notifyEvent(e);
        }
    }

    @Override
    public String getHostname() throws IOException {
        return AbstractStatisticsCollector.fullyQualifiedHostName;
    }

    @Override
    public Class getServiceIface() throws IOException {
        return this.getClass();
    }

    @Override
    public String getServiceName() throws IOException {
        return this.getClass().getName() + "#" + this.hashCode();
    }

    @Override
    public UUID getServiceUUID() throws IOException {
        return this.serviceUUID;
    }

    @Override
    public void destroy() {
    }
}

