/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.linux;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterHierarchy;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.IProcessCounters;
import com.bigdata.counters.ProcessReaderHelper;
import com.bigdata.counters.linux.KernelVersion;
import com.bigdata.counters.linux.SysstatUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PIDStatCollector
extends AbstractProcessCollector
implements ICounterHierarchy,
IProcessCounters {
    protected final int pid;
    protected final boolean perProcessIOData;
    private final AtomicLong lastModified = new AtomicLong(System.currentTimeMillis());
    private final Map<String, Object> vals = new ConcurrentHashMap<String, Object>();

    public PIDStatCollector(int pid, int interval, KernelVersion kernelVersion) {
        super(interval);
        if (interval <= 0) {
            throw new IllegalArgumentException();
        }
        if (kernelVersion == null) {
            throw new IllegalArgumentException();
        }
        this.pid = pid;
        this.perProcessIOData = kernelVersion.version >= 2 && kernelVersion.major >= 6 && kernelVersion.minor >= 20;
    }

    @Override
    public List<String> getCommand() {
        LinkedList<String> command = new LinkedList<String>();
        command.add(SysstatUtil.getPath("pidstat").getPath());
        command.add("-p");
        command.add("" + this.pid);
        command.add("-u");
        command.add("-I");
        if (this.perProcessIOData) {
            command.add("-d");
        }
        command.add("-r");
        command.add("" + this.getInterval());
        return command;
    }

    @Override
    public CounterSet getCounters() {
        LinkedList<AbstractInst> inst = new LinkedList<AbstractInst>();
        inst.add(new ID("CPU/% User Time", 0.01));
        inst.add(new ID("CPU/% System Time", 0.01));
        inst.add(new ID("CPU/% Processor Time", 0.01));
        inst.add(new ID("Memory/Minor Faults per Second", 1.0));
        inst.add(new ID("Memory/Major Faults per Second", 1.0));
        inst.add(new IL("Memory/Virtual Size", 1024L));
        inst.add(new IL("Memory/Resident Set Size", 1024L));
        inst.add(new ID("Memory/Percent Memory Size", 0.01));
        inst.add(new ID("PhysicalDisk/Bytes Read per Second", 1024.0));
        inst.add(new ID("PhysicalDisk/Bytes Written per Second", 1024.0));
        CounterSet root = new CounterSet();
        for (AbstractInst i : inst) {
            root.addCounter(i.getPath(), i);
        }
        return root;
    }

    @Override
    protected void setEnvironment(Map<String, String> env) {
        super.setEnvironment(env);
        env.put("S_TIME_FORMAT", "ISO");
    }

    @Override
    public AbstractProcessReader getProcessReader() {
        return new PIDStatReader();
    }

    protected class PIDStatReader
    extends ProcessReaderHelper {
        @Override
        protected ActiveProcess getActiveProcess() {
            if (PIDStatCollector.this.activeProcess == null) {
                throw new IllegalStateException();
            }
            return PIDStatCollector.this.activeProcess;
        }

        @Override
        protected void readProcess() throws IOException, InterruptedException {
            if (log.isInfoEnabled()) {
                log.info((Object)"begin");
            }
            for (int i = 0; i < 10 && !this.getActiveProcess().isAlive(); ++i) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"waiting for the readerFuture to be set.");
                }
                Thread.sleep(100L);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"running");
            }
            String banner = this.readLine();
            if (log.isInfoEnabled()) {
                log.info((Object)("banner: " + banner));
            }
            long n = 0L;
            while (true) {
                block15: {
                    String blank = this.readLine();
                    assert (blank.trim().length() == 0) : "Expecting a blank line";
                    String header = this.readLine();
                    String data = this.readLine();
                    try {
                        String[] fields;
                        PIDStatCollector.this.lastModified.set(System.currentTimeMillis());
                        if (header.contains("%CPU")) {
                            fields = SysstatUtil.splitDataLine(data);
                            String user = fields[2];
                            String system = fields[3];
                            String cpu = fields[4];
                            if (log.isInfoEnabled()) {
                                log.info((Object)("\n%user=" + user + ", %system=" + system + ", %cpu=" + cpu + "\n" + header + "\n" + data));
                            }
                            PIDStatCollector.this.vals.put("CPU/% User Time", Double.parseDouble(user));
                            PIDStatCollector.this.vals.put("CPU/% System Time", Double.parseDouble(system));
                            PIDStatCollector.this.vals.put("CPU/% Processor Time", Double.parseDouble(cpu));
                            break block15;
                        }
                        if (header.contains("RSS")) {
                            fields = SysstatUtil.splitDataLine(data);
                            String minorFaultsPerSec = fields[2];
                            String majorFaultsPerSec = fields[3];
                            String virtualSize = fields[4];
                            String residentSetSize = fields[5];
                            String percentMemory = fields[6];
                            if (log.isInfoEnabled()) {
                                log.info((Object)("\nminorFaultsPerSec=" + minorFaultsPerSec + ", majorFaultsPerSec=" + majorFaultsPerSec + ", virtualSize=" + virtualSize + ", residentSetSize=" + residentSetSize + ", percentMemory=" + percentMemory + "\n" + header + "\n" + data));
                            }
                            PIDStatCollector.this.vals.put("Memory/Minor Faults per Second", Double.parseDouble(minorFaultsPerSec));
                            PIDStatCollector.this.vals.put("Memory/Major Faults per Second", Double.parseDouble(majorFaultsPerSec));
                            PIDStatCollector.this.vals.put("Memory/Virtual Size", Long.parseLong(virtualSize));
                            PIDStatCollector.this.vals.put("Memory/Resident Set Size", Long.parseLong(residentSetSize));
                            PIDStatCollector.this.vals.put("Memory/Percent Memory Size", Double.parseDouble(percentMemory));
                            break block15;
                        }
                        if (PIDStatCollector.this.perProcessIOData && header.contains("kB_rd/s")) {
                            fields = SysstatUtil.splitDataLine(data);
                            String kBrdS = fields[2];
                            String kBwrS = fields[3];
                            if (log.isInfoEnabled()) {
                                log.info((Object)("\nkB_rd/s=" + kBrdS + ", kB_wr/s=" + kBwrS + "\n" + header + "\n" + data));
                            }
                            PIDStatCollector.this.vals.put("PhysicalDisk/Bytes Read per Second", Double.parseDouble(kBrdS));
                            PIDStatCollector.this.vals.put("PhysicalDisk/Bytes Written per Second", Double.parseDouble(kBrdS));
                            break block15;
                        }
                        log.warn((Object)("Could not identify event type from header: [" + header + "]"));
                        continue;
                    }
                    catch (Exception ex) {
                        log.warn((Object)(ex.getMessage() + "\nheader: " + header + "\n  data: " + data));
                    }
                }
                ++n;
            }
        }
    }

    class ID
    extends AbstractInst<Double> {
        protected final double scale;

        public ID(String path, double scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Double getValue() {
            Double value = (Double)PIDStatCollector.this.vals.get(this.path);
            if (value == null) {
                return 0.0;
            }
            double d = value * this.scale;
            return d;
        }
    }

    class IL
    extends AbstractInst<Long> {
        protected final long scale;

        public IL(String path, long scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Long getValue() {
            Long value = (Long)PIDStatCollector.this.vals.get(this.path);
            if (value == null) {
                return 0L;
            }
            long v = value * this.scale;
            return v;
        }
    }

    abstract class AbstractInst<T>
    implements IInstrument<T> {
        protected final String path;

        public final String getPath() {
            return this.path;
        }

        protected AbstractInst(String path) {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            this.path = path;
        }

        @Override
        public final long lastModified() {
            return PIDStatCollector.this.lastModified.get();
        }

        @Override
        public final void setValue(T value, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

