/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.linux;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SysstatUtil {
    private static final Logger log = Logger.getLogger(SysstatUtil.class);

    public static final File getPath(String cmd) {
        File f;
        File path;
        File configuredPath = path = new File(System.getProperty("com.bigdata.counters.linux.sysstat.path", "/usr/bin"));
        if (log.isInfoEnabled()) {
            log.info((Object)("com.bigdata.counters.linux.sysstat.path=" + configuredPath));
        }
        if (!(f = new File(path, cmd)).exists()) {
            log.warn((Object)("Not found: " + f));
            path = new File("/usr/bin");
            f = new File(path, cmd);
            if (!f.exists()) {
                log.warn((Object)("Not found: " + f));
                path = new File("/usr/local/bin");
                f = new File(path, cmd);
                if (!f.exists()) {
                    log.warn((Object)("Not found: " + f));
                    log.error((Object)("Could not locate: '" + cmd + "'. Set '-D" + "com.bigdata.counters.linux.sysstat.path" + "=<dir>'"));
                    path = configuredPath;
                }
            }
        }
        if (configuredPath != path) {
            log.warn((Object)("Using effective path: com.bigdata.counters.linux.sysstat.path=" + path));
        }
        return new File(path, cmd);
    }

    public static String[] splitDataLine(String data) {
        String t = data.substring(11);
        Object[] fields = t.split("\\s+");
        fields[0] = data.substring(0, 11);
        if (log.isDebugEnabled()) {
            log.debug((Object)("fields=" + Arrays.toString(fields)));
        }
        return fields;
    }

    public static DateFormat newDateFormat() {
        return new SimpleDateFormat("hh:mm:ss aa");
    }

    public static interface Options {
        public static final String PATH = "com.bigdata.counters.linux.sysstat.path";
        public static final String DEFAULT_PATH = "/usr/bin";
    }
}

