/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import com.bigdata.counters.PeriodEnum;
import com.bigdata.counters.query.QueryUtil;
import com.bigdata.counters.query.ReportEnum;
import com.bigdata.counters.query.TimestampFormatEnum;
import com.bigdata.counters.query.URLQueryParam;
import com.bigdata.service.Event;
import com.bigdata.service.IEventReportingService;
import com.bigdata.service.IService;
import com.bigdata.util.CaseInsensitiveStringComparator;
import com.bigdata.util.httpd.NanoHTTPD;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class URLQueryModel {
    private static final transient Logger log = Logger.getLogger(URLQueryModel.class);
    public static final String PATH = "path";
    public static final String DEPTH = "depth";
    public static final String REPORT = "report";
    public static final String CATEGORY = "category";
    public static final String CORRELATED = "correlated";
    public static final String FILTER = "filter";
    public static final String REGEX = "regex";
    public static final String TIMESTAMP_FORMAT = "timestampFormat";
    public static final String PERIOD = "period";
    public static final String MIMETYPE = "mimeType";
    public static final String FILE = "file";
    public final HashMap<Field, Pattern> eventFilters = new HashMap();
    static final String EVENT_ORDER_BY = "eventOrderBy";
    public final Field[] eventOrderBy;
    public final String uri;
    public final LinkedHashMap<String, Vector<String>> params;
    private final String requestURL;
    public final String path;
    public final int depth;
    public final ReportEnum reportType;
    public final TimestampFormatEnum timestampFormat;
    public final String[] category;
    public final long fromTime;
    public final long toTime;
    public final PeriodEnum period;
    public final Pattern pattern;
    public final IEventReportingService eventReportingService;
    public final boolean flot;
    public final DecimalFormat decimalFormat;
    public final NumberFormat percentFormat;
    public final NumberFormat integerFormat;
    public final DecimalFormat unitsFormat;
    public final Format dateFormat;
    public final String mimeType;
    public final File file;

    public String toString() {
        boolean first;
        StringBuilder sb = new StringBuilder();
        sb.append(URLQueryModel.class.getName());
        sb.append("{uri=" + this.uri);
        sb.append(",params=" + this.params);
        sb.append(",path=" + this.path);
        sb.append(",depth=" + this.depth);
        sb.append(",reportType=" + (Object)((Object)this.reportType));
        sb.append(",mimeType=" + this.mimeType);
        sb.append(",pattern=" + this.pattern);
        sb.append(",category=" + (this.category == null ? "N/A" : Arrays.toString(this.category)));
        sb.append(",period=" + (Object)((Object)this.period));
        sb.append(",[fromTime=" + this.fromTime);
        sb.append(",toTime=" + this.toTime + "]");
        sb.append(",flot=" + this.flot);
        if (this.eventOrderBy != null) {
            sb.append(",eventOrderBy=[");
            first = true;
            for (Field f : this.eventOrderBy) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(f.getName());
                first = false;
            }
            sb.append("]");
        }
        if (this.eventFilters != null && !this.eventFilters.isEmpty()) {
            sb.append(",eventFilters{");
            first = true;
            for (Map.Entry<Field, Pattern> e : this.eventFilters.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(e.getKey().getName());
                sb.append("=");
                sb.append(e.getValue());
                first = false;
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    public static URLQueryModel getInstance(IService service, String uri, LinkedHashMap<String, Vector<String>> params, Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        sb.append(headers.get("host"));
        sb.append(uri);
        String requestURL = sb.toString();
        return new URLQueryModel(service, uri, params, requestURL);
    }

    public static URLQueryModel getInstance(IService service, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String uri = URLDecoder.decode(req.getRequestURI(), "UTF-8");
        LinkedHashMap<String, Vector<String>> params = new LinkedHashMap<String, Vector<String>>();
        Enumeration enames = req.getParameterNames();
        while (enames.hasMoreElements()) {
            String name = (String)enames.nextElement();
            String[] values = req.getParameterValues(name);
            Vector<String> value = new Vector<String>();
            for (String v : values) {
                value.add(v);
            }
            params.put(name, value);
        }
        String requestURL = req.getRequestURL().toString();
        return new URLQueryModel(service, uri, params, requestURL);
    }

    public static URLQueryModel getInstance(URL url) throws UnsupportedEncodingException {
        LinkedHashMap<String, Vector<String>> params = NanoHTTPD.decodeParams(url.getQuery(), new LinkedHashMap<String, Vector<String>>());
        TreeMap<String, String> headers = new TreeMap<String, String>(new CaseInsensitiveStringComparator());
        headers.put("host", url.getHost() + ":" + url.getPort());
        return URLQueryModel.getInstance(null, url.toString(), params, headers);
    }

    private URLQueryModel(IService service, String uri, LinkedHashMap<String, Vector<String>> params, String requestURL) {
        Vector<String> v;
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (params == null) {
            throw new IllegalArgumentException();
        }
        if (requestURL == null) {
            throw new IllegalArgumentException();
        }
        this.uri = uri;
        this.params = params;
        this.requestURL = requestURL;
        this.path = URLQueryModel.getProperty(params, PATH, "/");
        if (log.isInfoEnabled()) {
            log.info((Object)("path=" + this.path));
        }
        this.depth = Integer.parseInt(URLQueryModel.getProperty(params, DEPTH, "2"));
        if (log.isInfoEnabled()) {
            log.info((Object)("depth=" + this.depth));
        }
        if (this.depth <= 0) {
            throw new IllegalArgumentException("depth must be GT ZERO(0)");
        }
        this.fromTime = 0L;
        this.toTime = Long.MAX_VALUE;
        this.pattern = QueryUtil.getPattern((Collection<String>)params.get(FILTER), (Collection<String>)params.get(REGEX));
        this.eventReportingService = service != null && service instanceof IEventReportingService ? (IEventReportingService)((Object)service) : null;
        if (params.containsKey(REPORT) && params.containsKey(CORRELATED)) {
            throw new IllegalArgumentException("Please use either 'correlated' or 'report'");
        }
        if (params.containsKey(REPORT)) {
            this.reportType = ReportEnum.valueOf(URLQueryModel.getProperty(params, REPORT, ReportEnum.hierarchy.toString()));
            if (log.isInfoEnabled()) {
                log.info((Object)("report=" + (Object)((Object)this.reportType)));
            }
        } else {
            boolean correlated = Boolean.parseBoolean(URLQueryModel.getProperty(params, CORRELATED, "false"));
            if (log.isInfoEnabled()) {
                log.info((Object)("correlated=" + correlated));
            }
            ReportEnum reportEnum = this.reportType = correlated ? ReportEnum.correlated : ReportEnum.hierarchy;
        }
        if (this.eventReportingService != null) {
            for (Map.Entry<String, Vector<String>> entry : params.entrySet()) {
                Field fld;
                String name = entry.getKey();
                if (!name.startsWith("events.")) continue;
                int pos = name.indexOf(46);
                if (pos == -1) {
                    throw new IllegalArgumentException("Missing event column name: " + name);
                }
                String col = name.substring(pos + 1, name.length());
                try {
                    fld = Event.class.getField(col);
                }
                catch (NoSuchFieldException ex) {
                    throw new IllegalArgumentException("Unknown event field: " + col);
                }
                Vector<String> patterns = entry.getValue();
                if (patterns.size() == 0) continue;
                if (patterns.size() > 1) {
                    throw new IllegalArgumentException("Only one pattern per field: " + name);
                }
                Pattern pattern = Pattern.compile(patterns.firstElement());
                this.eventFilters.put(fld, pattern);
            }
            if (log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (Field f : this.eventFilters.keySet()) {
                    sb.append(f.getName() + "=" + this.eventFilters.get(f));
                }
                log.info((Object)("eventFilters={" + sb + "}"));
            }
        }
        if ((v = params.get(EVENT_ORDER_BY)) == null) {
            try {
                this.eventOrderBy = new Field[]{Event.class.getField("hostname")};
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        } else {
            Vector<Field> fields = new Vector<Field>();
            for (String s : v) {
                try {
                    fields.add(Event.class.getField(s));
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            this.eventOrderBy = fields.toArray(new Field[0]);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("eventOrderBy=" + Arrays.toString(this.eventOrderBy)));
        }
        switch (this.reportType) {
            case events: {
                if (this.eventReportingService == null) {
                    throw new IllegalStateException("Events are not available.");
                }
                this.flot = true;
                break;
            }
            default: {
                this.flot = false;
            }
        }
        String[] stringArray = this.category = params.containsKey(CATEGORY) ? params.get(CATEGORY).toArray(new String[0]) : null;
        if (log.isInfoEnabled() && this.category != null) {
            log.info((Object)("category=" + Arrays.toString(this.category)));
        }
        this.timestampFormat = TimestampFormatEnum.valueOf(URLQueryModel.getProperty(params, TIMESTAMP_FORMAT, TimestampFormatEnum.dateTime.toString()));
        if (log.isInfoEnabled()) {
            log.info((Object)("timestampFormat=" + (Object)((Object)this.timestampFormat)));
        }
        this.period = PeriodEnum.valueOf(URLQueryModel.getProperty(params, PERIOD, PeriodEnum.Minutes.toString()));
        if (log.isInfoEnabled()) {
            log.info((Object)("period=" + (Object)((Object)this.period)));
        }
        this.decimalFormat = new DecimalFormat("##0.#####E0");
        this.percentFormat = NumberFormat.getPercentInstance();
        this.integerFormat = NumberFormat.getIntegerInstance();
        this.integerFormat.setGroupingUsed(true);
        this.unitsFormat = new DecimalFormat("0.#");
        switch (this.timestampFormat) {
            case dateTime: {
                this.dateFormat = DateFormat.getDateTimeInstance(2, 2);
                break;
            }
            case epoch: {
                NumberFormat f = NumberFormat.getIntegerInstance();
                f.setGroupingUsed(false);
                f.setMinimumFractionDigits(0);
                this.dateFormat = f;
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.timestampFormat.toString());
            }
        }
        this.mimeType = params.containsKey(MIMETYPE) ? URLQueryModel.getProperty(params, MIMETYPE, null) : null;
        File file = this.file = params.containsKey(FILE) ? new File(URLQueryModel.getProperty(params, FILE, null)) : null;
        if (log.isInfoEnabled()) {
            log.info((Object)("file=" + this.file));
        }
    }

    protected static String getProperty(Map<String, Vector<String>> params, String property, String defaultValue) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Vector<String> vals = params.get(property);
        if (vals == null) {
            return defaultValue;
        }
        return vals.get(0);
    }

    public StringBuilder getRequestURL() {
        return new StringBuilder(this.requestURL);
    }

    public String getRequestURL(URLQueryParam[] override) {
        LinkedHashMap<String, Vector<String>> p;
        if (override == null) {
            p = this.params;
        } else {
            p = new LinkedHashMap<String, Vector<String>>(this.params);
            for (URLQueryParam x : override) {
                p.put(x.name, x.values);
            }
        }
        StringBuilder sb = this.getRequestURL();
        sb.append("?path=" + URLQueryModel.encodeURL(URLQueryModel.getProperty(p, PATH, "/")));
        for (Map.Entry<String, Vector<String>> entry : p.entrySet()) {
            String name = entry.getKey();
            if (name.equals(PATH)) continue;
            Collection vals = entry.getValue();
            for (String s : vals) {
                sb.append("&" + URLQueryModel.encodeURL(name) + "=" + URLQueryModel.encodeURL(s));
            }
        }
        return sb.toString();
    }

    protected static String encodeURL(String url) {
        String charset = "UTF-8";
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Could not encode: charset=UTF-8, url=" + url));
            return url;
        }
    }
}

