/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.disco;

import com.bigdata.util.Util;
import com.sun.jini.config.Config;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.discovery.ConstrainableLookupLocator;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.ServiceItemFilter;

public class DiscoveryTool {
    private static final String COMPONENT_NAME = DiscoveryTool.class.getName();
    private static final String CONFIG_ARG = "config";
    private static final String GROUP_ARG_PREFIX = "group";
    private static final String LOCATOR_ARG_PREFIX = "locator";
    private static final String SERVICE_ARG_PREFIX = "service";
    private static final String ALL_GROUPS_ARG = "allGroups";
    private static final String TIMEOUT_ARG = "timeout";
    private static final String OUTPUT_ARG = "output";
    private static final String VERBOSE_ARG = "verbose";
    private static final Pattern hostPortPattern = Pattern.compile("(.+):(\\d+)");
    private final Map<Class, Collection<Class>> typeCache = Collections.synchronizedMap(new WeakHashMap());
    private final Configuration config;
    private final Collection<String> groups = new ArrayList<String>();
    private final Collection<LookupLocator> locators = new ArrayList<LookupLocator>();
    private final Collection<Pattern> serviceTypePatterns = new ArrayList<Pattern>();
    private final boolean allGroups;
    private final Long timeout;
    private final PrintStream out;
    private final boolean verbose;
    private final DateFormat dateFormat;
    private final Set<String> uninterestingInterfaces;

    public static void main(String[] args) throws Exception {
        new DiscoveryTool(args).run();
    }

    private DiscoveryTool(String[] rawArgs) throws ConfigurationException, IOException {
        String val;
        String argName;
        String argName2;
        Arguments args = new Arguments(rawArgs);
        this.config = ConfigurationProvider.getInstance((String[])new String[]{args.get(CONFIG_ARG)}, (ClassLoader)this.getClass().getClassLoader());
        int i = 0;
        while (args.contains(argName2 = GROUP_ARG_PREFIX + i)) {
            this.groups.add(args.get(argName2));
            ++i;
        }
        MethodConstraints locatorConstraints = (MethodConstraints)this.config.getEntry(COMPONENT_NAME, "lookupLocatorConstraints", MethodConstraints.class, null);
        int i2 = 0;
        while (args.contains(argName = LOCATOR_ARG_PREFIX + i2)) {
            String val2 = args.get(argName);
            Matcher m = hostPortPattern.matcher(val2);
            this.locators.add((LookupLocator)(m.matches() ? new ConstrainableLookupLocator(m.group(1), Integer.parseInt(m.group(2)), locatorConstraints) : new ConstrainableLookupLocator(val2, 4160, locatorConstraints)));
            ++i2;
        }
        i2 = 0;
        while (args.contains(argName = SERVICE_ARG_PREFIX + i2)) {
            this.serviceTypePatterns.add(Pattern.compile(args.get(argName)));
            ++i2;
        }
        Long l = this.timeout = args.contains(TIMEOUT_ARG) ? Long.valueOf(Long.parseLong(args.get(TIMEOUT_ARG))) : null;
        this.out = args.contains(OUTPUT_ARG) ? ((val = args.get(OUTPUT_ARG)).equals("-") ? System.out : new PrintStream(val)) : System.out;
        this.allGroups = Boolean.parseBoolean(args.get(ALL_GROUPS_ARG));
        this.verbose = Boolean.parseBoolean(args.get(VERBOSE_ARG));
        this.dateFormat = (DateFormat)Config.getNonNullEntry((Configuration)this.config, (String)COMPONENT_NAME, (String)"dateFormat", DateFormat.class, (Object)DateFormat.getInstance());
        this.uninterestingInterfaces = new HashSet<String>(Arrays.asList((String[])Config.getNonNullEntry((Configuration)this.config, (String)COMPONENT_NAME, (String)"uninterestingInterfaces", String[].class, (Object)new String[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws ConfigurationException, IOException, InterruptedException {
        DiscoveryManagement discoveryManager = null;
        ServiceDiscoveryManager serviceDiscovery = null;
        try {
            this.println(this.getDateString(), ": starting discovery");
            discoveryManager = Util.getDiscoveryManager(this.config, COMPONENT_NAME);
            this.verbose("created lookup discovery manager: ", discoveryManager);
            this.verbose("groups: ", this.allGroups ? "<all>" : this.groups.toString());
            ((DiscoveryGroupManagement)discoveryManager).setGroups(this.allGroups ? DiscoveryGroupManagement.ALL_GROUPS : this.groups.toArray(new String[this.groups.size()]));
            this.verbose("locators: ", this.locators);
            ((DiscoveryLocatorManagement)discoveryManager).setLocators(this.locators.toArray(new LookupLocator[this.locators.size()]));
            serviceDiscovery = new ServiceDiscoveryManager(discoveryManager, null, this.config);
            this.verbose("created service discovery manager: ", serviceDiscovery);
            this.verbose("service type patterns: ", this.serviceTypePatterns);
            ServiceTypeFilter serviceFilter = this.serviceTypePatterns.isEmpty() ? null : new ServiceTypeFilter(this.serviceTypePatterns);
            LookupCache cache = serviceDiscovery.createLookupCache(null, (ServiceItemFilter)serviceFilter, (ServiceDiscoveryListener)new Listener());
            this.verbose("created lookup cache: ", cache);
            this.verbose("timeout: ", this.timeout != null ? this.timeout + " ms" : "<none>");
            if (this.timeout == null) {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            Thread.sleep(this.timeout);
            this.verbose("shutting down");
        }
        finally {
            if (serviceDiscovery != null) {
                serviceDiscovery.terminate();
            }
            if (discoveryManager != null) {
                discoveryManager.terminate();
            }
        }
    }

    void println(Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(arg);
        }
        this.out.println(sb);
    }

    void verbose(Object ... args) {
        if (this.verbose) {
            this.println(args);
        }
    }

    String getDateString() {
        return this.dateFormat.format(new Date());
    }

    Collection<Class> getTypes(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        Class<?> cl = obj.getClass();
        Collection<Class> types = this.typeCache.get(cl);
        if (types == null) {
            HashSet<Class> s = new HashSet<Class>();
            DiscoveryTool.accumulateTypes(cl, s);
            types = new ArrayList<Class>(s);
            this.typeCache.put(cl, types);
        }
        return types;
    }

    private static void accumulateTypes(Class cl, Set<Class> types) {
        if (cl != null && types.add(cl)) {
            DiscoveryTool.accumulateTypes(cl.getSuperclass(), types);
            for (Class<?> intf : cl.getInterfaces()) {
                DiscoveryTool.accumulateTypes(intf, types);
            }
        }
    }

    private static String join(Iterable<?> i, String delim) {
        Iterator<?> iter = i.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(delim);
            sb.append(iter.next());
        }
        return sb.toString();
    }

    private static class Arguments {
        private static final Pattern pattern = Pattern.compile("(.+)=(.+)");
        private final Map<String, String> map = new HashMap<String, String>();

        Arguments(String[] rawArgs) {
            for (String arg : rawArgs) {
                Matcher m = pattern.matcher(arg);
                if (!m.matches()) {
                    throw new IllegalArgumentException("invalid argument: " + arg);
                }
                this.map.put(m.group(1), m.group(2));
            }
        }

        boolean contains(String name) {
            return this.map.containsKey(name);
        }

        String get(String name) {
            String val = this.map.get(name);
            if (val != null) {
                return val;
            }
            throw new IllegalArgumentException("no value for " + name);
        }
    }

    private class ServiceTypeFilter
    implements ServiceItemFilter {
        private final Collection<Pattern> serviceTypePatterns;

        ServiceTypeFilter(Collection<Pattern> serviceTypePatterns) {
            this.serviceTypePatterns = serviceTypePatterns;
        }

        public boolean check(ServiceItem item) {
            for (Class type : DiscoveryTool.this.getTypes(item.service)) {
                for (Pattern pattern : this.serviceTypePatterns) {
                    if (!pattern.matcher(type.getName()).find()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class Listener
    implements ServiceDiscoveryListener {
        Listener() {
        }

        public synchronized void serviceAdded(ServiceDiscoveryEvent event) {
            DiscoveryTool.this.println(DiscoveryTool.this.getDateString(), ": service added");
            this.printServiceItem(event.getPostEventServiceItem());
        }

        public synchronized void serviceChanged(ServiceDiscoveryEvent event) {
            DiscoveryTool.this.println(DiscoveryTool.this.getDateString(), ": service changed");
            this.printServiceItem(event.getPostEventServiceItem());
        }

        public synchronized void serviceRemoved(ServiceDiscoveryEvent event) {
            DiscoveryTool.this.println(DiscoveryTool.this.getDateString(), ": service removed");
            this.printServiceItem(event.getPreEventServiceItem());
        }

        private void printServiceItem(ServiceItem item) {
            ArrayList<String> typeNames = new ArrayList<String>();
            for (Class type : DiscoveryTool.this.getTypes(item.service)) {
                if (!type.isInterface() || DiscoveryTool.this.uninterestingInterfaces.contains(type.getName())) continue;
                typeNames.add(type.getName());
            }
            DiscoveryTool.this.println("  Service ID: ", item.serviceID);
            DiscoveryTool.this.println("  Types: ", DiscoveryTool.join(typeNames, ", "));
            DiscoveryTool.this.println("  Attributes:");
            for (Entry e : item.attributeSets) {
                DiscoveryTool.this.println("    ", e);
            }
            DiscoveryTool.this.println(new Object[0]);
        }
    }
}

