/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.gpo;

import com.bigdata.gom.gpo.IGPO;
import com.bigdata.gom.gpo.IGenericSkin;
import com.bigdata.gom.gpo.ILinkSet;
import com.bigdata.gom.gpo.LinkSet;
import com.bigdata.gom.om.IObjectManager;
import com.bigdata.gom.om.ObjectMgrModel;
import com.bigdata.gom.skin.GenericSkinRegistry;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.BindingSet;

public class GPO
implements IGPO {
    private static final Logger log = Logger.getLogger(GPO.class);
    private boolean m_removed = false;
    private final ObjectMgrModel m_om;
    private final BigdataResource m_id;
    private final BigdataStatement m_stmt;
    private volatile boolean m_materialized = false;
    private boolean m_clean = true;
    private GPOEntry m_headEntry = null;
    private GPOEntry m_tailEntry = null;
    private GPOEntry m_headLinkEntry = null;
    private GPOEntry m_tailLinkEntry = null;
    private ArrayList<IGenericSkin> m_skins = null;

    GPOEntry establishEntry(URI key) {
        BigdataURI fkey = this.m_om.internKey(key);
        if (this.m_headEntry == null) {
            this.m_headEntry = this.m_tailEntry = new GPOEntry(fkey);
        } else {
            GPOEntry entry = this.m_headEntry;
            while (entry != null) {
                if (entry.m_key == fkey) {
                    return entry;
                }
                entry = entry.m_next;
            }
            this.m_tailEntry = this.m_tailEntry.m_next = new GPOEntry(fkey);
        }
        return this.m_tailEntry;
    }

    GPOEntry establishLinkEntry(URI key) {
        BigdataURI fkey = this.m_om.internKey(key);
        if (this.m_headLinkEntry == null) {
            this.m_headLinkEntry = this.m_tailLinkEntry = new GPOEntry(fkey);
        } else {
            GPOEntry entry = this.m_headLinkEntry;
            while (entry != null) {
                if (entry.m_key == fkey) {
                    return entry;
                }
                entry = entry.m_next;
            }
            this.m_tailLinkEntry = this.m_tailLinkEntry.m_next = new GPOEntry(fkey);
        }
        return this.m_tailLinkEntry;
    }

    GPOEntry getEntry(URI key) {
        this.checkLive();
        BigdataURI fkey = this.m_om.internKey(key);
        GPOEntry entry = this.m_headEntry;
        while (entry != null) {
            if (entry.m_key == fkey) {
                return entry;
            }
            entry = entry.m_next;
        }
        return null;
    }

    GPOEntry getLinkEntry(URI key) {
        this.checkLive();
        BigdataURI fkey = this.m_om.internKey(key);
        GPOEntry entry = this.m_headLinkEntry;
        while (entry != null) {
            if (entry.m_key == fkey) {
                return entry;
            }
            entry = entry.m_next;
        }
        return null;
    }

    public void dematerialize() {
        this.m_materialized = false;
        this.m_clean = true;
        this.m_tailEntry = null;
        this.m_headEntry = null;
    }

    @Override
    public int hashCode() {
        return this.m_id.hashCode();
    }

    public GPO(IObjectManager om, Resource id) {
        if (om == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.m_om = (ObjectMgrModel)om;
        this.m_id = om.getValueFactory().asValue(id);
        this.m_stmt = null;
    }

    public GPO(IObjectManager om, BNode id, Statement stmt) {
        BigdataStatement stmt2;
        if (om == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.m_om = (ObjectMgrModel)om;
        this.m_id = om.getValueFactory().asValue(id);
        this.m_stmt = stmt2 = om.getValueFactory().createStatement(((ObjectMgrModel)om).bestEffortIntern(stmt.getSubject()), ((ObjectMgrModel)om).internKey(stmt.getPredicate()), ((ObjectMgrModel)om).bestEffortIntern(stmt.getObject()));
    }

    private void checkLive() {
        if (this.m_removed) {
            throw new IllegalStateException("This GPO has been removed");
        }
    }

    @Override
    public IGenericSkin asClass(Class theClassOrInterface) {
        return this.getSkin(theClassOrInterface);
    }

    @Override
    public IObjectManager getObjectManager() {
        this.checkLive();
        return this.m_om;
    }

    @Override
    public BigdataResource getId() {
        this.checkLive();
        return this.m_id;
    }

    public BigdataStatement getStatement() {
        return this.m_stmt;
    }

    public String encode(Resource v) {
        this.checkLive();
        return this.m_om.encode(v);
    }

    @Override
    public Set<IGPO> getLinksIn() {
        this.materialize();
        HashSet<IGPO> ret = new HashSet<IGPO>();
        GPOEntry linkEntry = this.m_headLinkEntry;
        while (linkEntry != null) {
            Iterator<Value> inlinks = linkEntry.values();
            while (inlinks.hasNext()) {
                IGPO mem = this.m_om.getGPO((Resource)inlinks.next());
                ret.add(mem);
            }
            linkEntry = linkEntry.m_next;
        }
        return ret;
    }

    @Override
    public ILinkSet getLinksIn(URI property) {
        this.materialize();
        return new LinkSet(this, property, true);
    }

    @Override
    public Set<IGPO> getLinksOut() {
        this.materialize();
        HashSet<IGPO> ret = new HashSet<IGPO>();
        GPOEntry entry = this.m_headEntry;
        while (entry != null) {
            Iterator<Value> values = entry.values();
            while (values.hasNext()) {
                Value value = values.next();
                if (!(value instanceof Resource)) continue;
                ret.add(this.m_om.getGPO((Resource)value));
            }
            entry = entry.m_next;
        }
        return ret;
    }

    @Override
    public ILinkSet getLinksOut(URI property) {
        this.materialize();
        return new LinkSet(this, property, false);
    }

    @Override
    public Map<URI, Long> getReverseLinkProperties() {
        this.materialize();
        HashMap<URI, Long> ret = new HashMap<URI, Long>();
        String query = "SELECT ?p (COUNT(?o) AS ?count)\nWHERE { ?o ?p <" + this.getId().toString() + "> }\n" + "GROUP BY ?p";
        ICloseableIterator<BindingSet> res = this.m_om.evaluate(query);
        while (res.hasNext()) {
            BindingSet bs = (BindingSet)res.next();
            URI pred = (URI)bs.getBinding("p").getValue();
            Long count = ((Literal)bs.getBinding("count").getValue()).longValue();
            ret.put(pred, count);
        }
        return ret;
    }

    @Override
    public Set<Statement> getStatements() {
        this.materialize();
        HashSet<Statement> out = new HashSet<Statement>();
        GPOEntry entry = this.m_headEntry;
        while (entry != null) {
            Iterator<Value> values = entry.values();
            while (values.hasNext()) {
                out.add(this.makeStatement(this.m_id, entry.m_key, values.next()));
            }
            entry = entry.m_next;
        }
        return out;
    }

    private Statement makeStatement(Resource id, URI key, Value value) {
        return this.m_om.getValueFactory().createStatement(id, key, value);
    }

    @Override
    public Value getValue(URI property) {
        this.materialize();
        GPOEntry entry = this.getEntry(property);
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public Set<Value> getValues(URI property) {
        this.materialize();
        HashSet<Value> values = new HashSet<Value>();
        GPOEntry entry = this.getEntry(property);
        if (entry != null) {
            Iterator<Value> vals = entry.values();
            while (vals.hasNext()) {
                values.add(vals.next());
            }
        }
        return values;
    }

    @Override
    public boolean isBound(URI property) {
        this.materialize();
        return this.getValue(property) != null;
    }

    @Override
    public boolean isMemberOf(ILinkSet linkSet) {
        return linkSet.contains(this);
    }

    @Override
    public void remove() {
        this.materialize();
        this.m_removed = true;
        GPOEntry entry = this.m_headEntry;
        while (entry != null) {
            this.clearReverseLinkSetEntries(entry);
            entry.removeAll(this);
            entry = entry.m_next;
        }
        entry = this.m_headLinkEntry;
        while (entry != null) {
            entry.removeAll(this);
            entry = entry.m_next;
        }
        this.dirty();
    }

    public void initValue(URI predicate, Value object) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            throw new IllegalArgumentException();
        }
        assert (!this.m_materialized);
        GPOEntry entry = this.establishEntry(predicate);
        entry.initValue(this, object);
    }

    public void initLinkValue(URI predicate, Resource object) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            throw new IllegalArgumentException();
        }
        assert (!this.m_materialized);
        GPOEntry entry = this.establishLinkEntry(predicate);
        entry.initValue(this, (Value)object);
    }

    @Override
    public void setValue(URI property, Value newValue) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        this.materialize();
        this.removeValues(property);
        GPOEntry entry = this.establishEntry(property);
        entry.set(this, newValue);
        if (newValue instanceof Resource) {
            ((GPO)this.m_om.getGPO((Resource)newValue)).addLinkSetMember(property, this.m_id);
        }
        this.dirty();
    }

    @Override
    public IGPO getLink(URI property, IGPO target) {
        GPOEntry entry = this.getEntry(property);
        if (entry != null && entry.contains(target.getId())) {
            return this.m_om.getGPO((Statement)new StatementImpl((Resource)this.m_id, property, (Value)target.getId()));
        }
        return null;
    }

    @Override
    public void addValue(URI property, Value value) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.materialize();
        GPOEntry entry = this.establishEntry(property);
        if (entry.add(this, value)) {
            this.dirty();
        }
    }

    private void removeLinkSetMember(URI property, Resource resource) {
        this.materialize();
        GPOEntry entry = this.establishLinkEntry(property);
        entry.remove(this, (Value)resource);
    }

    private void addLinkSetMember(URI property, Resource resource) {
        this.materialize();
        GPOEntry entry = this.establishLinkEntry(property);
        entry.add(this, (Value)resource);
    }

    @Override
    public void removeValue(URI property, Value value) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.materialize();
        GPOEntry entry = this.establishEntry(property);
        if (entry.remove(this, value)) {
            if (value instanceof Resource) {
                ((GPO)this.m_om.getGPO((Resource)value)).removeLinkSetMember(property, this.m_id);
            }
            this.dirty();
        }
    }

    @Override
    public void removeValues(URI property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        this.materialize();
        GPOEntry entry = this.establishEntry(property);
        if (entry.m_size != 0) {
            this.clearReverseLinkSetEntries(entry);
            entry.removeAll(this);
            this.dirty();
        }
    }

    private void clearReverseLinkSetEntries(GPOEntry entry) {
        Iterator<Value> values = entry.values();
        while (values.hasNext()) {
            Value value = values.next();
            if (!(value instanceof Resource)) continue;
            ((GPO)this.m_om.getGPO((Resource)value)).removeLinkSetMember(entry.m_key, this.m_id);
        }
    }

    private void dirty() {
        if (this.m_clean) {
            this.m_clean = false;
            this.m_om.addToDirtyList(this);
        }
    }

    public boolean isDirty() {
        return !this.m_clean;
    }

    @Override
    public IGPO asGeneric() {
        return this;
    }

    @Override
    public String pp() {
        StringBuilder out = new StringBuilder("ID: " + this.m_id.stringValue() + "\n");
        GPOEntry entry = this.m_headEntry;
        while (entry != null) {
            Iterator<Value> values = entry.values();
            while (values.hasNext()) {
                out.append(entry.m_key.toString() + ": " + values.next().toString() + "\n");
            }
            entry = entry.m_next;
        }
        return out.toString();
    }

    @Override
    public IGPO getType() {
        this.materialize();
        URI tid = (URI)this.getValue((URI)new URIImpl("attr:/type"));
        if (tid != null) {
            return this.m_om.getGPO((Resource)tid);
        }
        return null;
    }

    public void doCommit() {
        assert (this.m_materialized);
        GPOEntry entry = this.m_headEntry;
        while (entry != null) {
            entry.commit();
            entry = entry.m_next;
        }
        this.m_clean = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGPO materialize() {
        this.checkLive();
        if (!this.m_materialized) {
            GPO gPO = this;
            synchronized (gPO) {
                if (!this.m_materialized && this.m_stmt == null) {
                    this.m_om.materialize(this);
                    this.m_materialized = true;
                }
            }
        }
        return this;
    }

    public void setMaterialized(boolean b) {
        this.m_materialized = true;
    }

    public void prepareBatchUpdate(List<Statement> insertList, List<Statement> removeList) {
        ObjectMgrModel oom = this.m_om;
        BigdataValueFactory f = oom.getValueFactory();
        GPOEntry entry = this.m_headEntry;
        while (entry != null) {
            Iterator<Value> inserts = entry.additions();
            while (inserts.hasNext()) {
                Value v = inserts.next();
                Statement stmt = f.createStatement(this.m_id, entry.m_key, v);
                insertList.add(stmt);
            }
            Iterator<Value> removes = entry.removes();
            while (removes.hasNext()) {
                Value v = removes.next();
                Statement stmt = f.createStatement(this.m_id, entry.m_key, v);
                removeList.add(stmt);
            }
            entry = entry.m_next;
        }
    }

    public IGenericSkin getSkin(Class intf) {
        IGenericSkin ret = null;
        if (this.m_skins != null) {
            for (int i = 0; i < this.m_skins.size(); ++i) {
                if (!intf.isInstance(this.m_skins.get(i))) continue;
                return this.m_skins.get(i);
            }
        } else {
            this.m_skins = new ArrayList(2);
        }
        ret = GenericSkinRegistry.asClass(this, intf);
        this.m_skins.add(ret);
        return ret;
    }

    public Iterator<URI> getPropertyURIs() {
        this.materialize();
        if (this.m_headEntry == null) {
            return new EmptyIterator<URI>();
        }
        ArrayList<URI> properties = new ArrayList<URI>();
        GPOEntry entry = this.m_headEntry;
        while (entry != null) {
            properties.add(entry.m_key);
            entry = entry.m_next;
        }
        return properties.iterator();
    }

    static class GPOEntry {
        private final URI m_key;
        private GPOEntry m_next;
        private LinkValue m_values;
        private LinkValue m_addedValues;
        private LinkValue m_removedValues;
        private int m_size = 0;

        GPOEntry(URI key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.m_key = key;
        }

        public void initValue(GPO owner, Value value) {
            LinkValue newValue = new LinkValue(value);
            newValue.m_next = this.m_values;
            this.m_values = newValue;
            ++this.m_size;
        }

        public void set(GPO owner, Value value) {
            this.m_addedValues = new LinkValue(value);
            LinkValue nxt = this.m_values;
            while (nxt != null) {
                LinkValue rem = nxt;
                nxt = nxt.m_next;
                rem.m_next = this.m_removedValues;
                this.m_removedValues = rem;
            }
            this.m_values = null;
            this.m_size = 1;
        }

        public boolean remove(GPO owner, Value value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            LinkValue test = this.m_values;
            LinkValue prev = null;
            while (test != null) {
                if (value.equals(test.m_value)) {
                    if (prev == null) {
                        this.m_values = test.m_next;
                    } else {
                        prev.m_next = test.m_next;
                    }
                    test.m_next = this.m_removedValues;
                    this.m_removedValues = test;
                    --this.m_size;
                    return true;
                }
                prev = test;
                test = test.m_next;
            }
            test = this.m_addedValues;
            prev = null;
            while (test != null) {
                if (value.equals(test.m_value)) {
                    if (prev == null) {
                        this.m_addedValues = test.m_next;
                    } else {
                        prev.m_next = test.m_next;
                    }
                    --this.m_size;
                    return true;
                }
                prev = test;
                test = test.m_next;
            }
            return false;
        }

        public boolean removeAll(GPO owner) {
            if (this.m_size == 0) {
                return false;
            }
            if (this.m_removedValues == null) {
                this.m_removedValues = this.m_values;
            } else {
                LinkValue tail = this.m_removedValues;
                while (tail.m_next != null) {
                    tail = tail.m_next;
                }
                tail.m_next = this.m_values;
            }
            this.m_values = null;
            this.m_addedValues = null;
            this.m_size = 0;
            return true;
        }

        public Iterator<Value> values() {
            return new Iterator<Value>(){
                LinkValue m_cur;
                LinkValue m_added;
                {
                    this.m_cur = GPOEntry.this.m_values;
                    this.m_added = GPOEntry.this.m_addedValues;
                }

                @Override
                public boolean hasNext() {
                    return this.m_cur != null || this.m_added != null;
                }

                @Override
                public Value next() {
                    LinkValue ret;
                    LinkValue linkValue = ret = this.m_cur != null ? this.m_cur : this.m_added;
                    if (ret == null) {
                        throw new NoSuchElementException();
                    }
                    if (this.m_cur != null) {
                        this.m_cur = this.m_cur.m_next;
                    } else {
                        this.m_added = this.m_added.m_next;
                    }
                    return ret.m_value;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Iterator<Value> removes() {
            ValueIterator ret = new ValueIterator(this.m_removedValues);
            return ret;
        }

        public Iterator<Value> additions() {
            ValueIterator ret = new ValueIterator(this.m_addedValues);
            return ret;
        }

        public Value getValue() {
            if (this.m_values != null) {
                return this.m_values.m_value;
            }
            if (this.m_addedValues != null) {
                return this.m_addedValues.m_value;
            }
            return null;
        }

        public void commit() {
            if (this.m_addedValues != null) {
                if (this.m_values == null) {
                    this.m_values = this.m_addedValues;
                } else {
                    LinkValue tail = this.m_values;
                    while (tail.m_next != null) {
                        tail = tail.m_next;
                    }
                    tail.m_next = this.m_addedValues;
                }
                this.m_addedValues = null;
            }
            this.m_removedValues = null;
        }

        public boolean add(GPO owner, Value value) {
            Iterator<Value> values = this.values();
            while (values.hasNext()) {
                if (!values.next().equals(value)) continue;
                return false;
            }
            LinkValue nv = new LinkValue(value);
            nv.m_next = this.m_addedValues;
            this.m_addedValues = nv;
            ++this.m_size;
            return true;
        }

        public boolean hasValues() {
            return this.m_values != null || this.m_addedValues != null;
        }

        public int size() {
            return this.m_size;
        }

        public boolean contains(BigdataResource id) {
            return this.m_values != null && this.m_values.contains(id) || this.m_addedValues != null && this.m_addedValues.contains(id);
        }

        static class ValueIterator
        implements Iterator<Value> {
            LinkValue m_cur;

            ValueIterator(LinkValue cur) {
                this.m_cur = cur;
            }

            @Override
            public boolean hasNext() {
                return this.m_cur != null;
            }

            @Override
            public Value next() {
                LinkValue ret = this.m_cur;
                this.m_cur = this.m_cur.m_next;
                return ret.m_value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class LinkValue {
        final Value m_value;
        LinkValue m_next;

        LinkValue(Value value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.m_value = value;
        }

        public boolean contains(BigdataResource id) {
            LinkValue tst = this;
            while (tst != null) {
                if (tst.m_value.equals(id)) {
                    return true;
                }
                tst = tst.m_next;
            }
            return false;
        }
    }
}

