/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha;

import com.bigdata.ha.HAGlue;
import com.bigdata.ha.IJoinedAndNonJoinedServices;
import com.bigdata.ha.QuorumService;
import com.bigdata.quorum.Quorum;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;

public class JoinedAndNonJoinedServices
implements Serializable,
IJoinedAndNonJoinedServices {
    private static final long serialVersionUID = 1L;
    private final UUID[] joinedServiceIds;
    private final Set<UUID> nonJoinedPipelineServiceIds;

    public JoinedAndNonJoinedServices(Quorum<HAGlue, QuorumService<HAGlue>> quorum) {
        this.joinedServiceIds = quorum.getJoined();
        UUID serviceId = quorum.getClient().getServiceId();
        if (this.joinedServiceIds.length == 0 || !this.joinedServiceIds[0].equals(serviceId)) {
            throw new RuntimeException("Not leader: serviceId=" + serviceId + ", joinedServiceIds=" + Arrays.toString(this.joinedServiceIds));
        }
        this.nonJoinedPipelineServiceIds = new LinkedHashSet<UUID>(Arrays.asList(quorum.getPipeline()));
        for (UUID joinedServiceId : this.joinedServiceIds) {
            this.nonJoinedPipelineServiceIds.remove(joinedServiceId);
        }
    }

    @Override
    public UUID[] getJoinedServiceIds() {
        return this.joinedServiceIds;
    }

    @Override
    public Set<UUID> getNonJoinedPipelineServiceIds() {
        return this.nonJoinedPipelineServiceIds;
    }

    public String toString() {
        return super.toString() + "{#joined=" + this.joinedServiceIds.length + ", #nonJoined=" + this.nonJoinedPipelineServiceIds.size() + ", joinedServices=" + Arrays.toString(this.joinedServiceIds) + ", nonJoined=" + this.nonJoinedPipelineServiceIds + "}";
    }
}

