/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha;

import com.bigdata.ha.AbstractMessageTask;
import com.bigdata.ha.HAPipelineGlue;
import com.bigdata.ha.HAPipelineResetRequest;
import com.bigdata.ha.HAPipelineResetResponse;
import com.bigdata.ha.IHAPipelineResetRequest;
import com.bigdata.ha.IHAPipelineResetResponse;
import com.bigdata.ha.QuorumPipeline;
import com.bigdata.ha.QuorumServiceBase;
import com.bigdata.ha.msg.HAMessageWrapper;
import com.bigdata.ha.msg.HASendState;
import com.bigdata.ha.msg.IHASendState;
import com.bigdata.ha.msg.IHASyncRequest;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.ha.pipeline.HAReceiveService;
import com.bigdata.ha.pipeline.HASendService;
import com.bigdata.ha.pipeline.ImmediateDownstreamReplicationException;
import com.bigdata.ha.pipeline.NestedPipelineException;
import com.bigdata.ha.pipeline.PipelineImmediateDownstreamReplicationException;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import com.bigdata.quorum.QCE;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumException;
import com.bigdata.quorum.QuorumMember;
import com.bigdata.quorum.QuorumStateChangeEvent;
import com.bigdata.quorum.QuorumStateChangeEventEnum;
import com.bigdata.quorum.QuorumStateChangeListener;
import com.bigdata.quorum.QuorumStateChangeListenerBase;
import com.bigdata.quorum.ServiceLookup;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class QuorumPipelineImpl<S extends HAPipelineGlue>
implements QuorumPipeline<S>,
QuorumStateChangeListener {
    private static final transient Logger log = Logger.getLogger(QuorumPipelineImpl.class);
    private final int RETRY_SLEEP = 30;
    private final QuorumMember<S> member;
    private final UUID serviceId;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition pipelineChanged = this.lock.newCondition();
    private HASendService sendService;
    private HAReceiveService<HAMessageWrapper> receiveService;
    private IBufferAccess receiveBuffer;
    private final AtomicReference<PipelineState<S>> pipelineStateRef = new AtomicReference();
    private final InnerEventHandler innerEventHandler = new InnerEventHandler();
    private final AtomicLong messageId = new AtomicLong(0L);
    private final Semaphore sendLock = new Semaphore(1);

    protected long getRetrySendTimeoutNanos() {
        return TimeUnit.MILLISECONDS.toNanos(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() {
        boolean ok = false;
        this.lock.lock();
        try {
            this.innerEventHandler.dispatchEvents();
            ok = true;
        }
        finally {
            if (!ok) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockInterruptibly() throws InterruptedException {
        boolean ok = false;
        this.lock.lockInterruptibly();
        try {
            this.innerEventHandler.dispatchEvents();
            ok = true;
        }
        finally {
            if (!ok) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        try {
            this.innerEventHandler.dispatchEvents();
        }
        finally {
            this.lock.unlock();
        }
    }

    public QuorumPipelineImpl(QuorumMember<S> member) {
        if (member == null) {
            throw new IllegalArgumentException();
        }
        this.member = member;
        this.serviceId = member.getServiceId();
    }

    protected void finalize() throws Throwable {
        this.innerEventHandler.tearDown();
        super.finalize();
    }

    private static int getIndex(UUID serviceId, UUID[] a) {
        if (serviceId == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < a.length; ++i) {
            if (!serviceId.equals(a[i])) continue;
            return i;
        }
        return -1;
    }

    private ByteBuffer getReceiveBuffer() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.receiveBuffer == null ? null : this.receiveBuffer.buffer();
    }

    private HAReceiveService<HAMessageWrapper> getHAReceiveService() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.receiveService;
    }

    private HASendService getHASendService() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.sendService;
    }

    @Override
    public void pipelineAdd() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.PIPELINE_ADD));
    }

    @Override
    public void pipelineElectedLeader() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.PIPELINE_ELECTED_LEADER));
    }

    @Override
    public void pipelineRemove() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.PIPELINE_REMOVE));
    }

    @Override
    public void pipelineChange(UUID oldDownStreamId, UUID newDownStreamId) {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.PIPELINE_CHANGE, new UUID[]{oldDownStreamId, newDownStreamId}, null, null, null));
    }

    @Override
    public void pipelineUpstreamChange() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.PIPELINE_UPSTREAM_CHANGE));
    }

    @Override
    public void memberAdd() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.MEMBER_ADD));
    }

    @Override
    public void memberRemove() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.MEMBER_REMOVE));
    }

    @Override
    public void consensus(long lastCommitTime) {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.CONSENSUS, null, lastCommitTime, null, null));
    }

    @Override
    public void lostConsensus() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.LOST_CONSENSUS));
    }

    @Override
    public void serviceJoin() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.SERVICE_JOIN));
    }

    @Override
    public void serviceLeave() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.SERVICE_LEAVE));
    }

    @Override
    public void quorumMeet(long token, UUID leaderId) {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.QUORUM_MEET, null, null, token, leaderId));
    }

    @Override
    public void quorumBreak() {
        this.innerEventHandler.queue(new QCE(QuorumStateChangeEventEnum.QUORUM_BREAK));
    }

    private IHASendState newSendState() {
        Quorum<?, ?> quorum = this.member.getQuorum();
        HASendState snd = new HASendState(this.messageId.incrementAndGet(), this.serviceId, this.serviceId, quorum.token(), quorum.replicationFactor());
        return snd;
    }

    @Override
    public Future<IHAPipelineResetResponse> resetPipeline(IHAPipelineResetRequest req) throws IOException {
        FutureTask<IHAPipelineResetResponse> ft = new FutureTask<IHAPipelineResetResponse>(new ResetPipelineTaskImpl(req));
        this.member.getExecutor().submit(ft);
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> replicate(IHASyncRequest req, IHAWriteMessage msg, ByteBuffer b) throws IOException {
        FutureTask<Void> ft;
        this.lock();
        try {
            ft = new FutureTask<Void>(new RobustReplicateTask(req, this.newSendState(), msg, b));
        }
        finally {
            this.unlock();
        }
        this.member.getExecutor().execute(ft);
        return ft;
    }

    private static <S extends HAPipelineGlue> void launderPipelineException(boolean isLeader, long token, QuorumMember<S> member, QuorumPipelineImpl<S> outerClass, Throwable t) {
        UUID[] priorAndNext;
        UUID thisService;
        ImmediateDownstreamReplicationException directCause;
        PipelineImmediateDownstreamReplicationException remoteCause;
        block12: {
            log.warn((Object)("isLeader=" + isLeader + ", t=" + t), t);
            remoteCause = (PipelineImmediateDownstreamReplicationException)InnerCause.getInnerCause(t, PipelineImmediateDownstreamReplicationException.class);
            directCause = remoteCause == null ? (ImmediateDownstreamReplicationException)InnerCause.getInnerCause(t, ImmediateDownstreamReplicationException.class) : null;
            thisService = member.getServiceId();
            priorAndNext = member.getQuorum().getPipelinePriorAndNext(member.getServiceId());
            if (isLeader) {
                UUID problemServiceId;
                block11: {
                    problemServiceId = null;
                    try {
                        if (directCause != null) {
                            problemServiceId = priorAndNext[1];
                        } else if (remoteCause != null) {
                            problemServiceId = remoteCause.getProblemServiceId();
                        }
                        if (problemServiceId != null) {
                            member.getActor().forceRemoveService(problemServiceId);
                        }
                    }
                    catch (Throwable e) {
                        log.error((Object)("Problem on force remove: problemServiceId=" + problemServiceId), e);
                        if (!InnerCause.isInnerCause(e, InterruptedException.class)) break block11;
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    super.resetPipeline(token, problemServiceId);
                }
                catch (Throwable e) {
                    log.warn((Object)("Problem(s) on reset pipeline: " + e));
                    if (!InnerCause.isInnerCause(e, InterruptedException.class)) break block12;
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (directCause != null) {
            throw new PipelineImmediateDownstreamReplicationException(thisService, priorAndNext, t);
        }
        if (remoteCause != null) {
            throw new NestedPipelineException(t);
        }
        throw new RuntimeException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPipeline(long token, UUID problemServiceId) {
        log.error((Object)("Leader will reset pipeline: token=" + token + ", problemServiceId=" + problemServiceId));
        UUID[] pipelineIds = this.member.getQuorum().getPipeline();
        this.member.assertLeader(token);
        HAPipelineResetRequest msg = new HAPipelineResetRequest(token, problemServiceId, TimeUnit.MILLISECONDS.toNanos(5000L));
        LinkedList<Future<IHAPipelineResetResponse>> localFutures = new LinkedList<Future<IHAPipelineResetResponse>>();
        try {
            for (int i = 1; i < pipelineIds.length; ++i) {
                UUID serviceId = pipelineIds[i];
                Future<IHAPipelineResetResponse> future = this.member.getExecutor().submit(new PipelineResetMessageTask<S>(this.member, serviceId, msg));
                localFutures.add(future);
            }
            this.member.assertLeader(token);
            FutureTask<IHAPipelineResetResponse> ft = new FutureTask<IHAPipelineResetResponse>(new ResetPipelineTaskImpl(msg));
            localFutures.add(ft);
            ft.run();
            LinkedList<Exception> causes = new LinkedList<Exception>();
            for (Future future : localFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException ex) {
                    log.error((Object)ex, (Throwable)ex);
                    causes.add(ex);
                }
                catch (ExecutionException ex) {
                    log.error((Object)ex, (Throwable)ex);
                    causes.add(ex);
                }
                catch (RuntimeException ex) {
                    log.error((Object)ex, (Throwable)ex);
                    causes.add(ex);
                }
                finally {
                    future.cancel(true);
                }
            }
            if (!causes.isEmpty()) {
                if (causes.size() == 1) {
                    throw new RuntimeException((Throwable)causes.get(0));
                }
                throw new RuntimeException("remote errors: nfailures=" + causes.size(), new ExecutionExceptions(causes));
            }
        }
        finally {
            QuorumServiceBase.cancelFutures(localFutures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> receiveAndReplicate(IHASyncRequest req, IHASendState snd, IHAWriteMessage msg) throws IOException {
        FutureTask<Void> ft;
        long token = req == null ? msg.getQuorumToken() : this.member.getQuorum().token();
        this.lock();
        try {
            this.member.getQuorum().assertQuorum(token);
            if (this.receiveBuffer == null) {
                throw new QuorumException();
            }
            PipelineState<S> downstream = this.pipelineStateRef.get();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Will receive " + (downstream != null ? " and replicate" : "") + ": msg=" + msg));
            }
            ByteBuffer b = this.getReceiveBuffer();
            HAReceiveService<HAMessageWrapper> receiveService = this.getHAReceiveService();
            ft = downstream == null ? new FutureTask<Void>(new ReceiveTask<S>(this.member, token, req, snd, msg, b, receiveService)) : new FutureTask<Void>(new ReceiveAndReplicateTask<S>(this.member, token, req, snd, msg, b, downstream, receiveService, this));
        }
        finally {
            this.unlock();
        }
        this.member.getExecutor().execute(ft);
        return ft;
    }

    protected abstract void handleReplicatedWrite(IHASyncRequest var1, IHAWriteMessage var2, ByteBuffer var3) throws Exception;

    protected abstract void incReceive(IHASyncRequest var1, IHAWriteMessage var2, int var3, int var4, int var5) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvents() {
        this.lock.lock();
        try {
            this.innerEventHandler.dispatchEvents();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class PipelineState<S extends HAPipelineGlue>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        public InetSocketAddress addr;
        public S service;

        public PipelineState() {
        }

        public PipelineState(S service, InetSocketAddress addr) {
            this.service = service;
            this.addr = addr;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.addr = (InetSocketAddress)in.readObject();
            this.service = (HAPipelineGlue)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.addr);
            out.writeObject(this.service);
        }
    }

    private static class ReceiveAndReplicateTask<S extends HAPipelineGlue>
    implements Callable<Void> {
        private final QuorumMember<S> member;
        private final long token;
        private final IHASyncRequest req;
        private final IHASendState snd;
        private final IHAWriteMessage msg;
        private final ByteBuffer b;
        private final PipelineState<S> downstream;
        private final HAReceiveService<HAMessageWrapper> receiveService;
        private final QuorumPipelineImpl<S> outerClass;

        public ReceiveAndReplicateTask(QuorumMember<S> member, long token, IHASyncRequest req, IHASendState snd, IHAWriteMessage msg, ByteBuffer b, PipelineState<S> downstream, HAReceiveService<HAMessageWrapper> receiveService, QuorumPipelineImpl<S> outerClass) {
            this.member = member;
            this.token = token;
            this.req = req;
            this.snd = snd;
            this.msg = msg;
            this.b = b;
            this.downstream = downstream;
            this.receiveService = receiveService;
            this.outerClass = outerClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() throws Exception {
            HAMessageWrapper wrappedMsg = new HAMessageWrapper(this.req, this.snd, this.msg);
            Future<Void> futLoc = this.receiveService.receiveData(wrappedMsg, this.b);
            try {
                try {
                    Future<Void> futRmt;
                    try {
                        futRmt = this.downstream.service.receiveAndReplicate(this.req, this.snd, this.msg);
                    }
                    catch (IOException ex) {
                        throw new ImmediateDownstreamReplicationException(ex);
                    }
                    try {
                        while (!futLoc.isDone() || !futRmt.isDone()) {
                            this.member.getQuorum().assertQuorum(this.token);
                            try {
                                futLoc.get(500L, TimeUnit.MILLISECONDS);
                            }
                            catch (TimeoutException ignore) {
                            }
                            catch (ExecutionException ignore) {
                                try {
                                    futRmt.get(500L, TimeUnit.MILLISECONDS);
                                }
                                catch (TimeoutException ex) {
                                }
                                catch (ExecutionException ex) {
                                }
                                finally {
                                    futRmt.cancel(true);
                                }
                            }
                            try {
                                futRmt.get(500L, TimeUnit.MILLISECONDS);
                            }
                            catch (TimeoutException ignore) {
                            }
                            catch (ExecutionException ignore) {
                                try {
                                    futLoc.get(500L, TimeUnit.MILLISECONDS);
                                }
                                catch (TimeoutException ex) {
                                }
                                catch (ExecutionException ex) {
                                }
                                finally {
                                    futLoc.cancel(true);
                                }
                            }
                        }
                        futLoc.get();
                        futRmt.get();
                        return null;
                    }
                    finally {
                        if (!futRmt.isDone()) {
                            futRmt.cancel(true);
                        }
                    }
                }
                finally {
                    futLoc.cancel(true);
                }
            }
            catch (Throwable t) {
                QuorumPipelineImpl.launderPipelineException(false, this.token, this.member, (QuorumPipelineImpl)this.outerClass, t);
            }
            return null;
        }
    }

    private static class ReceiveTask<S extends HAPipelineGlue>
    implements Callable<Void> {
        private final QuorumMember<S> member;
        private final long token;
        private final IHASyncRequest req;
        private final IHASendState snd;
        private final IHAWriteMessage msg;
        private final ByteBuffer b;
        private final HAReceiveService<HAMessageWrapper> receiveService;

        public ReceiveTask(QuorumMember<S> member, long token, IHASyncRequest req, IHASendState snd, IHAWriteMessage msg, ByteBuffer b, HAReceiveService<HAMessageWrapper> receiveService) {
            this.member = member;
            this.token = token;
            this.req = req;
            this.snd = snd;
            this.msg = msg;
            this.b = b;
            this.receiveService = receiveService;
        }

        @Override
        public Void call() throws Exception {
            HAMessageWrapper wrappedMsg = new HAMessageWrapper(this.req, this.snd, this.msg);
            Future<Void> futRec = this.receiveService.receiveData(wrappedMsg, this.b);
            while (true) {
                try {
                    this.member.getQuorum().assertQuorum(this.token);
                    Void void_ = futRec.get(1000L, TimeUnit.MILLISECONDS);
                    return void_;
                }
                catch (TimeoutException ex) {
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
            finally {
                futRec.cancel(true);
            }
        }
    }

    private static class PipelineResetMessageTask<S extends HAPipelineGlue>
    extends AbstractMessageTask<S, IHAPipelineResetResponse, IHAPipelineResetRequest> {
        public PipelineResetMessageTask(ServiceLookup<S> serviceLookup, UUID serviceId, IHAPipelineResetRequest msg) {
            super(serviceLookup, serviceId, msg);
        }

        @Override
        protected Future<IHAPipelineResetResponse> doRMI(S service) throws IOException {
            return service.resetPipeline((IHAPipelineResetRequest)this.msg);
        }
    }

    private static class SendBufferTask<S extends HAPipelineGlue>
    implements Callable<Void> {
        private final QuorumMember<S> member;
        private final long token;
        private final IHASyncRequest req;
        private final IHASendState snd;
        private final IHAWriteMessage msg;
        private final ByteBuffer b;
        private final PipelineState<S> downstream;
        private final HASendService sendService;
        private final QuorumPipelineImpl<S> outerClass;
        private final Semaphore sendLock;

        public SendBufferTask(QuorumMember<S> member, long token, IHASyncRequest req, IHASendState snd, IHAWriteMessage msg, ByteBuffer b, PipelineState<S> downstream, HASendService sendService, QuorumPipelineImpl<S> outerClass, Semaphore sendLock) {
            this.member = member;
            this.token = token;
            this.req = req;
            this.snd = snd;
            this.msg = msg;
            this.b = b;
            this.downstream = downstream;
            this.sendService = sendService;
            this.outerClass = outerClass;
            this.sendLock = sendLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            this.sendLock.acquire();
            try {
                this.doRunWithLock();
                Void void_ = null;
                return void_;
            }
            finally {
                this.sendLock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void doRunWithLock() throws InterruptedException, ExecutionException, IOException {
            Future<Void> futLoc = this.sendService.send(this.b, this.snd.getMarker());
            try {
                try {
                    Future<Void> futRmt;
                    try {
                        futRmt = this.downstream.service.receiveAndReplicate(this.req, this.snd, this.msg);
                    }
                    catch (IOException ex) {
                        throw new ImmediateDownstreamReplicationException(ex);
                    }
                    try {
                        while (!futLoc.isDone() || !futRmt.isDone()) {
                            this.member.assertLeader(this.token);
                            try {
                                futLoc.get(500L, TimeUnit.MILLISECONDS);
                            }
                            catch (TimeoutException ignore) {
                            }
                            catch (ExecutionException ignore) {
                                try {
                                    futRmt.get(500L, TimeUnit.MILLISECONDS);
                                }
                                catch (TimeoutException ex) {
                                }
                                catch (ExecutionException ex) {
                                }
                                finally {
                                    futRmt.cancel(true);
                                }
                            }
                            try {
                                futRmt.get(500L, TimeUnit.MILLISECONDS);
                            }
                            catch (TimeoutException ignore) {
                            }
                            catch (ExecutionException ignore) {
                                try {
                                    futLoc.get(500L, TimeUnit.MILLISECONDS);
                                }
                                catch (TimeoutException ex) {
                                }
                                catch (ExecutionException ex) {
                                }
                                finally {
                                    futLoc.cancel(true);
                                }
                            }
                        }
                        futRmt.get();
                        futLoc.get();
                        return;
                    }
                    finally {
                        if (!futRmt.isDone()) {
                            futRmt.cancel(true);
                        }
                    }
                }
                finally {
                    futLoc.cancel(true);
                }
            }
            catch (Throwable t) {
                QuorumPipelineImpl.launderPipelineException(true, this.token, this.member, (QuorumPipelineImpl)this.outerClass, t);
            }
        }
    }

    private class RobustReplicateTask
    implements Callable<Void> {
        private final IHASyncRequest req;
        private final IHASendState snd;
        private final IHAWriteMessage msg;
        private final ByteBuffer b;
        private final long quorumToken;

        public RobustReplicateTask(IHASyncRequest req, IHASendState snd, IHAWriteMessage msg, ByteBuffer b) {
            if (snd == null) {
                throw new IllegalArgumentException();
            }
            if (msg == null) {
                throw new IllegalArgumentException();
            }
            if (b == null) {
                throw new IllegalArgumentException();
            }
            this.req = req;
            this.snd = snd;
            this.msg = msg;
            this.b = b;
            if (b.remaining() == 0) {
                throw new IllegalStateException("Empty buffer: req=" + req + ", msg=" + msg + ", buffer=" + b);
            }
            if (req == null) {
                this.quorumToken = msg.getQuorumToken();
                QuorumPipelineImpl.this.member.assertLeader(this.quorumToken);
            } else {
                this.quorumToken = QuorumPipelineImpl.this.member.getQuorum().token();
                QuorumPipelineImpl.this.member.assertLeader(this.quorumToken);
            }
        }

        private void assertQuorumState() throws QuorumException {
            QuorumPipelineImpl.this.member.assertLeader(this.quorumToken);
        }

        @Override
        public Void call() throws Exception {
            block3: {
                long beginNanos = System.nanoTime();
                this.assertQuorumState();
                try {
                    this.innerReplicate(0);
                }
                catch (Throwable t) {
                    if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                        throw new RuntimeException(t);
                    }
                    log.error((Object)t, t);
                    if (this.retrySend()) break block3;
                    long elapsedNanos = System.nanoTime() - beginNanos;
                    throw new RuntimeException("Giving up. Could not send after " + TimeUnit.NANOSECONDS.toMillis(elapsedNanos) + "ms : " + t, t);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void innerReplicate(int retryCount) throws Exception {
            QuorumPipelineImpl.this.lockInterruptibly();
            try {
                if (log.isInfoEnabled() || retryCount > 0) {
                    String msg2 = "Leader will send: " + this.b.remaining() + " bytes, retryCount=" + retryCount + ", req=" + this.req + ", msg=" + this.msg;
                    if (retryCount > 0) {
                        log.warn((Object)msg2);
                    } else {
                        log.info((Object)msg2);
                    }
                }
                this.assertQuorumState();
                PipelineState downstream = (PipelineState)QuorumPipelineImpl.this.pipelineStateRef.get();
                HASendService sendService = QuorumPipelineImpl.this.getHASendService();
                ByteBuffer b = this.b.duplicate();
                new SendBufferTask(QuorumPipelineImpl.this.member, this.quorumToken, this.req, this.snd, this.msg, b, downstream, sendService, QuorumPipelineImpl.this, QuorumPipelineImpl.this.sendLock).call();
                return;
            }
            finally {
                QuorumPipelineImpl.this.unlock();
            }
        }

        private boolean retrySend() throws InterruptedException {
            long remaining;
            long beginNanos = System.nanoTime();
            long nanos = QuorumPipelineImpl.this.getRetrySendTimeoutNanos();
            long retrySleepNanos = TimeUnit.MILLISECONDS.toNanos(30L);
            int tryCount = 1;
            while ((remaining = nanos - (System.nanoTime() - beginNanos)) > retrySleepNanos) {
                Thread.sleep(30L);
                remaining = nanos - (System.nanoTime() - beginNanos);
                this.assertQuorumState();
                try {
                    this.innerReplicate(tryCount++);
                    return true;
                }
                catch (Throwable t) {
                    if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                        throw new RuntimeException(t);
                    }
                    log.error((Object)("retry=" + tryCount + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginNanos) + "ms : " + t), t);
                }
            }
            return false;
        }
    }

    private class ResetPipelineTaskImpl
    implements Callable<IHAPipelineResetResponse> {
        private final IHAPipelineResetRequest req;

        public ResetPipelineTaskImpl(IHAPipelineResetRequest req) {
            this.req = req;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IHAPipelineResetResponse call() throws Exception {
            QuorumPipelineImpl.this.lock.lock();
            try {
                IHAPipelineResetResponse iHAPipelineResetResponse = this.doRunWithLock();
                return iHAPipelineResetResponse;
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }

        private boolean isProblemServiceOurNeighbor() {
            UUID psid = this.req.getProblemServiceId();
            if (psid == null) {
                return false;
            }
            UUID[] priorAndNext = QuorumPipelineImpl.this.member.getQuorum().getPipelinePriorAndNext(QuorumPipelineImpl.this.member.getServiceId());
            if (psid.equals(priorAndNext[0])) {
                return true;
            }
            return psid.equals(priorAndNext[1]);
        }

        private IHAPipelineResetResponse doRunWithLock() throws Exception {
            long timeout;
            log.warn((Object)("Will reset pipeline: req=" + this.req));
            long begin = System.nanoTime();
            long remaining = timeout = this.req.getTimeoutNanos();
            if (this.isProblemServiceOurNeighbor()) {
                log.warn((Object)"Problem service is our neighbor.");
                do {
                    QuorumPipelineImpl.this.pipelineChanged.await(remaining, TimeUnit.NANOSECONDS);
                    remaining = timeout - (begin - System.nanoTime());
                } while (this.isProblemServiceOurNeighbor() && remaining > 0L);
                if (this.isProblemServiceOurNeighbor()) {
                    throw new TimeoutException();
                }
            } else {
                log.warn((Object)"Problem service is not our neighbor.");
                QuorumPipelineImpl.this.innerEventHandler.tearDown();
                UUID[] pipelineOrder = QuorumPipelineImpl.this.member.getQuorum().getPipeline();
                int index = QuorumPipelineImpl.getIndex(QuorumPipelineImpl.this.serviceId, pipelineOrder);
                if (index == 0) {
                    QuorumPipelineImpl.this.innerEventHandler.setUpSendService();
                } else if (index > 0) {
                    QuorumPipelineImpl.this.innerEventHandler.setUpReceiveService();
                }
            }
            return new HAPipelineResetResponse();
        }
    }

    private final class InnerEventHandler
    extends QuorumStateChangeListenerBase {
        private final BlockingQueue<QuorumStateChangeEvent> queue = new LinkedBlockingQueue<QuorumStateChangeEvent>();
        private static final boolean s_eventElission = true;

        protected InnerEventHandler() {
        }

        private void queue(QuorumStateChangeEvent e) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Adding StateChange: " + e));
            }
            this.queue.add(e);
        }

        private void elideEvents() {
            Iterator events = this.queue.iterator();
            QuorumStateChangeEvent uce = null;
            QuorumStateChangeEvent dce = null;
            QuorumStateChangeEvent add = null;
            while (events.hasNext()) {
                QuorumStateChangeEvent tst = (QuorumStateChangeEvent)events.next();
                if (tst.getEventType() == QuorumStateChangeEventEnum.PIPELINE_UPSTREAM_CHANGE) {
                    if (uce != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Elission removal of: " + uce));
                        }
                        this.queue.remove(uce);
                    }
                    uce = tst;
                    continue;
                }
                if (tst.getEventType() == QuorumStateChangeEventEnum.PIPELINE_CHANGE) {
                    if (dce != null) {
                        tst.getDownstreamOldAndNew()[0] = dce.getDownstreamOldAndNew()[0];
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Elission removal of: " + dce));
                        }
                        this.queue.remove(dce);
                    }
                    dce = tst;
                    continue;
                }
                if (tst.getEventType() == QuorumStateChangeEventEnum.PIPELINE_ADD) {
                    add = tst;
                    continue;
                }
                if (tst.getEventType() != QuorumStateChangeEventEnum.PIPELINE_REMOVE) continue;
                if (add != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Elission removal of: " + add));
                        log.debug((Object)("Elission removal of: " + tst));
                    }
                    this.queue.remove(add);
                    this.queue.remove(tst);
                    add = null;
                }
                if (dce != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Elission removal of: " + dce));
                    }
                    this.queue.remove(dce);
                    dce = null;
                }
                if (uce == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Elission removal of: " + uce));
                }
                this.queue.remove(uce);
                uce = null;
            }
        }

        private void dispatchEvents() {
            QuorumStateChangeEvent e;
            this.elideEvents();
            while ((e = (QuorumStateChangeEvent)this.queue.poll()) != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Dispatching: " + e));
                }
                QuorumPipelineImpl.this.innerEventHandler.dispatchEvent(e);
            }
        }

        private void dispatchEvent(QuorumStateChangeEvent e) throws IllegalMonitorStateException {
            if (!QuorumPipelineImpl.this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)e.toString());
            }
            switch (e.getEventType()) {
                case CONSENSUS: {
                    this.consensus(e.getLastCommitTimeConsensus());
                    break;
                }
                case LOST_CONSENSUS: {
                    this.lostConsensus();
                    break;
                }
                case MEMBER_ADD: {
                    this.memberAdd();
                    break;
                }
                case MEMBER_REMOVE: {
                    this.memberRemove();
                    break;
                }
                case PIPELINE_ADD: {
                    this.pipelineAdd();
                    break;
                }
                case PIPELINE_CHANGE: {
                    UUID[] a = e.getDownstreamOldAndNew();
                    this.pipelineChange(a[0], a[1]);
                    break;
                }
                case PIPELINE_ELECTED_LEADER: {
                    this.pipelineElectedLeader();
                    break;
                }
                case PIPELINE_REMOVE: {
                    this.pipelineRemove();
                    break;
                }
                case PIPELINE_UPSTREAM_CHANGE: {
                    this.pipelineUpstreamChange();
                    break;
                }
                case QUORUM_BREAK: {
                    this.quorumBreak();
                    break;
                }
                case QUORUM_MEET: {
                    this.quorumMeet(e.getToken(), e.getLeaderId());
                    break;
                }
                case SERVICE_JOIN: {
                    this.serviceJoin();
                    break;
                }
                case SERVICE_LEAVE: {
                    this.serviceLeave();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(e.getEventType().toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pipelineAdd() {
            if (log.isInfoEnabled()) {
                log.info((Object)"");
            }
            super.pipelineAdd();
            QuorumPipelineImpl.this.lock.lock();
            try {
                UUID[] pipelineOrder = QuorumPipelineImpl.this.member.getQuorum().getPipeline();
                int index = QuorumPipelineImpl.getIndex(QuorumPipelineImpl.this.serviceId, pipelineOrder);
                if (index == 0) {
                    this.setUpSendService();
                } else if (index > 0) {
                    this.setUpReceiveService();
                }
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pipelineElectedLeader() {
            if (log.isInfoEnabled()) {
                log.info((Object)"");
            }
            super.pipelineElectedLeader();
            QuorumPipelineImpl.this.lock.lock();
            try {
                this.tearDown();
                this.setUpSendService();
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pipelineRemove() {
            if (log.isInfoEnabled()) {
                log.info((Object)"");
            }
            super.pipelineRemove();
            QuorumPipelineImpl.this.lock.lock();
            try {
                this.tearDown();
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pipelineChange(UUID oldDownStreamId, UUID newDownStreamId) {
            super.pipelineChange(oldDownStreamId, newDownStreamId);
            QuorumPipelineImpl.this.lock.lock();
            try {
                InetSocketAddress addrNext;
                if (oldDownStreamId == newDownStreamId) {
                    return;
                }
                if (oldDownStreamId != null && newDownStreamId != null && oldDownStreamId.equals(newDownStreamId)) {
                    return;
                }
                PipelineState nextState = this.getAddrNext(newDownStreamId);
                InetSocketAddress inetSocketAddress = addrNext = nextState == null ? null : nextState.addr;
                if (log.isInfoEnabled()) {
                    log.info((Object)("oldDownStreamId=" + oldDownStreamId + ",newDownStreamId=" + newDownStreamId + ", addrNext=" + addrNext + ", sendService=" + QuorumPipelineImpl.this.sendService + ", receiveService=" + QuorumPipelineImpl.this.receiveService));
                }
                if (QuorumPipelineImpl.this.sendService != null) {
                    QuorumPipelineImpl.this.sendService.terminate();
                    if (addrNext != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("sendService.start(): addrNext=" + addrNext));
                        }
                        QuorumPipelineImpl.this.sendService.start(addrNext);
                    }
                } else if (QuorumPipelineImpl.this.receiveService != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("receiveService.changeDownStream(): addrNext=" + addrNext));
                    }
                    QuorumPipelineImpl.this.receiveService.changeDownStream(addrNext);
                }
                QuorumPipelineImpl.this.pipelineStateRef.set(nextState);
                QuorumPipelineImpl.this.pipelineChanged.signalAll();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"pipelineChange - done.");
                }
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pipelineUpstreamChange() {
            super.pipelineUpstreamChange();
            QuorumPipelineImpl.this.lock.lock();
            try {
                if (QuorumPipelineImpl.this.receiveService != null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("receiveService=" + QuorumPipelineImpl.this.receiveService));
                    }
                    QuorumPipelineImpl.this.receiveService.changeUpStream();
                    QuorumPipelineImpl.this.pipelineChanged.signalAll();
                }
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }

        private PipelineState<S> getAddrNext(UUID downStreamId) {
            if (downStreamId == null) {
                return null;
            }
            HAPipelineGlue service = (HAPipelineGlue)QuorumPipelineImpl.this.member.getService(downStreamId);
            try {
                InetSocketAddress addrNext = service.getWritePipelineAddr();
                return new PipelineState<HAPipelineGlue>(service, addrNext);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tearDown() {
            if (log.isInfoEnabled()) {
                log.info((Object)"");
            }
            QuorumPipelineImpl.this.lock.lock();
            try {
                if (QuorumPipelineImpl.this.sendService != null) {
                    QuorumPipelineImpl.this.sendService.terminate();
                    QuorumPipelineImpl.this.sendService = null;
                }
                if (QuorumPipelineImpl.this.receiveService != null) {
                    QuorumPipelineImpl.this.receiveService.terminate();
                    try {
                        QuorumPipelineImpl.this.receiveService.awaitShutdown();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        QuorumPipelineImpl.this.receiveService = null;
                    }
                }
                if (QuorumPipelineImpl.this.receiveBuffer != null) {
                    try {
                        QuorumPipelineImpl.this.receiveBuffer.release();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        QuorumPipelineImpl.this.receiveBuffer = null;
                    }
                }
                QuorumPipelineImpl.this.pipelineStateRef.set(null);
                QuorumPipelineImpl.this.pipelineChanged.signalAll();
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }

        private void setUpSendService() {
            if (log.isInfoEnabled()) {
                log.info((Object)"");
            }
            QuorumPipelineImpl.this.lock.lock();
            try {
                QuorumPipelineImpl.this.sendService = new HASendService();
                UUID downstreamId = QuorumPipelineImpl.this.member.getDownstreamServiceId();
                PipelineState nextState = this.getAddrNext(downstreamId);
                if (nextState != null) {
                    QuorumPipelineImpl.this.sendService.start(nextState.addr);
                }
                QuorumPipelineImpl.this.pipelineStateRef.set(nextState);
                QuorumPipelineImpl.this.pipelineChanged.signalAll();
            }
            catch (Throwable t) {
                try {
                    this.tearDown();
                }
                catch (Throwable t2) {
                    log.error((Object)t2, t2);
                }
                throw new RuntimeException(t);
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setUpReceiveService() {
            QuorumPipelineImpl.this.lock.lock();
            try {
                UUID downstreamId = QuorumPipelineImpl.this.member.getDownstreamServiceId();
                try {
                    QuorumPipelineImpl.this.receiveBuffer = DirectBufferPool.INSTANCE.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                InetSocketAddress addrSelf = ((HAPipelineGlue)QuorumPipelineImpl.this.member.getService()).getWritePipelineAddr();
                PipelineState nextServiceState = this.getAddrNext(downstreamId);
                InetSocketAddress addrNext = nextServiceState == null ? null : nextServiceState.addr;
                QuorumPipelineImpl.this.receiveService = new HAReceiveService<HAMessageWrapper>(addrSelf, addrNext, new HAReceiveService.IHAReceiveCallback<HAMessageWrapper>(){

                    @Override
                    public void callback(HAMessageWrapper msg, ByteBuffer data) throws Exception {
                        QuorumPipelineImpl.this.handleReplicatedWrite(msg.getHASyncRequest(), (IHAWriteMessage)msg.getHAWriteMessage(), data);
                    }

                    @Override
                    public void incReceive(HAMessageWrapper msg, int nreads, int rdlen, int rem) throws Exception {
                        QuorumPipelineImpl.this.incReceive(msg.getHASyncRequest(), (IHAWriteMessage)msg.getHAWriteMessage(), nreads, rdlen, rem);
                    }
                });
                QuorumPipelineImpl.this.receiveService.start();
                QuorumPipelineImpl.this.pipelineChanged.signalAll();
            }
            catch (Throwable t) {
                try {
                    this.tearDown();
                }
                catch (Throwable t2) {
                    log.error((Object)t2, t2);
                }
                finally {
                    log.error((Object)t, t);
                }
                throw new RuntimeException(t);
            }
            finally {
                QuorumPipelineImpl.this.lock.unlock();
            }
        }
    }
}

