/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.msg;

import com.bigdata.btree.BytesUtil;
import com.bigdata.ha.msg.IHALogRootBlocksResponse;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockView;
import com.bigdata.util.ChecksumUtility;
import java.nio.ByteBuffer;

public class HALogRootBlocksResponse
implements IHALogRootBlocksResponse {
    private static final long serialVersionUID = 1L;
    private final boolean openIsRootBlock0;
    private final boolean closeIsRootBlock0;
    private final byte[] openData;
    private final byte[] closeData;

    public HALogRootBlocksResponse(IRootBlockView openRootBlock, IRootBlockView closeRootBlock) {
        if (openRootBlock == null) {
            throw new IllegalArgumentException();
        }
        if (closeRootBlock == null) {
            throw new IllegalArgumentException();
        }
        this.openIsRootBlock0 = openRootBlock.isRootBlock0();
        this.closeIsRootBlock0 = closeRootBlock.isRootBlock0();
        this.openData = BytesUtil.toArray(openRootBlock.asReadOnlyBuffer());
        this.closeData = BytesUtil.toArray(closeRootBlock.asReadOnlyBuffer());
    }

    @Override
    public IRootBlockView getOpenRootBlock() {
        return new RootBlockView(this.openIsRootBlock0, ByteBuffer.wrap(this.openData), new ChecksumUtility());
    }

    @Override
    public IRootBlockView getCloseRootBlock() {
        return new RootBlockView(this.closeIsRootBlock0, ByteBuffer.wrap(this.closeData), new ChecksumUtility());
    }

    public String toString() {
        return this.getClass() + "{openRootBlock=" + this.getOpenRootBlock() + ", closeRootBlock=" + this.getCloseRootBlock() + "}";
    }
}

