/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.EvictionError;
import com.bigdata.btree.IEvictionListener;
import com.bigdata.btree.PO;
import com.bigdata.cache.IHardReferenceQueue;
import com.bigdata.htree.AbstractHTree;
import com.bigdata.htree.AbstractPage;
import org.apache.log4j.Logger;

public class DefaultEvictionListener
implements IEvictionListener {
    private static final Logger log = Logger.getLogger(DefaultEvictionListener.class);

    @Override
    public void evicted(IHardReferenceQueue<PO> cache, PO ref) {
        AbstractPage node = (AbstractPage)ref;
        if (--node.referenceCount > 0) {
            return;
        }
        AbstractHTree htree = node.htree;
        if (htree.error != null) {
            throw new IllegalStateException("Index is in error state", htree.error);
        }
        try {
            assert (htree.isReadOnly() || htree.ndistinctOnWriteRetentionQueue > 0);
            --htree.ndistinctOnWriteRetentionQueue;
            if (node.isDeleted()) {
                return;
            }
            if (node.isDirty() && htree.store != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Evicting: " + (node.isLeaf() ? "leaf" : "node") + " : " + node.toShortString()));
                }
                if (node.isLeaf()) {
                    htree.writeNodeOrLeaf(node);
                } else {
                    htree.writeNodeRecursive(node);
                }
                assert (node.isCoded());
                assert (!node.isDirty());
                if (htree.store != null) assert (ref.getIdentity() != 0L);
            }
        }
        catch (Throwable e) {
            if (!htree.readOnly) {
                htree.error = e;
                throw new EvictionError(e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

