/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.htree.AbstractHTree;
import com.bigdata.htree.AbstractPage;
import com.bigdata.htree.BucketPage;
import com.bigdata.htree.DirtyChildIterator;
import com.bigdata.htree.HTree;
import com.bigdata.htree.HTreePageStats;
import com.bigdata.htree.HTreeUtil;
import com.bigdata.htree.MutableDirectoryPageData;
import com.bigdata.htree.data.IDirectoryData;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.SingleValueIterator;
import cutthecrap.utils.striterators.Striterator;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

class DirectoryPage
extends AbstractPage
implements IDirectoryData {
    private static final Logger log = Logger.getLogger(DirectoryPage.class);
    static int createdPages = 0;
    Reference<AbstractPage>[] childRefs;
    IDirectoryData data;

    final int getOverflowPageDepth() {
        return this.htree.addressBits;
    }

    protected AbstractPage getChild(int hashBits, int buddyOffset) {
        int tableWidth = 1 << this.globalDepth;
        int tableOffset = tableWidth * buddyOffset;
        int index = tableOffset + hashBits;
        return this.getChild(index);
    }

    void _splitBucketPage(BucketPage bucketPage) {
        boolean fillLowerSlots;
        byte[] tstkey = bucketPage.getFirstKey();
        int bucketSlot = this.getLocalHashCode(tstkey, this.getPrefixLength());
        int slotsOnPage = 1 << this.htree.addressBits;
        int start = 0;
        for (int s = 0; s < slotsOnPage; ++s) {
            if (bucketPage.self != this.childRefs[s]) continue;
            start = s;
            break;
        }
        int last = start;
        for (int s = start + 1; s < slotsOnPage && bucketPage.self == this.childRefs[s]; ++s) {
            ++last;
        }
        int npointers = last - start + 1;
        assert (npointers > 1);
        assert (npointers % 2 == 0);
        assert (npointers == 1 << this.htree.addressBits - bucketPage.globalDepth);
        int crefs = npointers >> 1;
        int newDepth = bucketPage.globalDepth + 1;
        boolean bl = fillLowerSlots = bucketSlot < start + crefs;
        assert (bucketSlot >= start && bucketSlot <= last);
        BucketPage newPage = this.createPage(newDepth);
        Reference a = fillLowerSlots ? newPage.self : null;
        for (int s = start; s < start + crefs; ++s) {
            this.childRefs[s] = a;
        }
        Reference b = !fillLowerSlots ? newPage.self : null;
        for (int s = start + crefs; s <= last; ++s) {
            this.childRefs[s] = b;
        }
        assert (!newPage.isPersistent());
        ++((HTree)this.htree).nleaves;
        bucketPage.delete();
        --((HTree)this.htree).nleaves;
        int bucketSlotsPerPage = bucketPage.slotsOnPage();
        for (int i = 0; i < bucketSlotsPerPage; ++i) {
            ((HTree)this.htree).insertRawTuple(bucketPage, i);
        }
        assert (((BucketPage)this.childRefs[bucketSlot].get()).data.getKeyCount() > 0);
        if (bucketPage.isPersistent()) {
            this.htree.deleteNodeOrLeaf(bucketPage.getIdentity());
        }
    }

    private BucketPage createPage(int depth) {
        BucketPage ret = new BucketPage((HTree)this.htree, depth);
        ret.parent = this.self;
        return ret;
    }

    private void fillEmptySlots(int slot, BucketPage bucketPage) {
        int slots = this.fillEmptySlots(slot, bucketPage, 0, 1 << this.htree.addressBits);
        assert (bucketPage.globalDepth == this.htree.addressBits);
        bucketPage.globalDepth = this.htree.addressBits;
        while (slots > 1) {
            slots >>= 1;
            --bucketPage.globalDepth;
        }
    }

    int countChildRefs(AbstractPage pge) {
        int count = 0;
        for (int i = 0; i < this.childRefs.length; ++i) {
            if (this.childRefs[i] != pge.self) continue;
            ++count;
        }
        return count;
    }

    private int fillEmptySlots(int slot, BucketPage bucketPage, int from, int to) {
        int i;
        if (from > slot | to < slot) {
            throw new IllegalArgumentException();
        }
        assert (!bucketPage.isPersistent());
        if (from == slot && to == slot + 1) {
            this.childRefs[slot] = bucketPage.self;
            return 1;
        }
        for (i = from; i < to; ++i) {
            if (this.childRefs[i] == null && this.getChildAddr(i) == 0L) continue;
            int childlen = to - from >> 1;
            if (slot < from + childlen) {
                return this.fillEmptySlots(slot, bucketPage, from, from + childlen);
            }
            return this.fillEmptySlots(slot, bucketPage, to - childlen, to);
        }
        for (i = from; i < to; ++i) {
            assert (this.childRefs[i] == null);
            this.childRefs[i] = bucketPage.self;
        }
        return to - from;
    }

    Reference<AbstractPage> getChildRef(int index) {
        return this.childRefs[index];
    }

    void setChildAddr(AbstractPage child) {
        assert (!this.isReadOnly());
        if (!child.isPersistent()) {
            throw new IllegalStateException();
        }
        int slotsPerPage = 1 << this.htree.addressBits;
        if (this.childRefs == null) {
            throw new IllegalStateException("childRefs must not be NULL");
        }
        boolean found = false;
        for (int i = 0; i < slotsPerPage; ++i) {
            if (this.childRefs[i] == child.self) {
                ((MutableDirectoryPageData)this.data).childAddr[i] = child.getIdentity();
                found = true;
                continue;
            }
            if (found) break;
        }
    }

    AbstractPage getChild(int index) {
        AbstractPage child;
        AbstractPage ret = this.checkLazyChild(index);
        if (ret != null) {
            return ret;
        }
        if (this.htree.memo == null) {
            return this._getChild(index, null);
        }
        Reference<AbstractPage> childRef = this.childRefs[index];
        AbstractPage abstractPage = child = childRef == null ? null : childRef.get();
        if (child != null) {
            this.htree.touch(child);
            return child;
        }
        return this.htree.loadChild(this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractPage checkLazyChild(int index) {
        Reference<AbstractPage>[] referenceArray = this.childRefs;
        synchronized (this.childRefs) {
            AbstractPage child;
            Reference<AbstractPage> childRef = this.childRefs[index];
            AbstractPage abstractPage = child = childRef == null ? null : childRef.get();
            if (child != null) {
                this.htree.touch(child);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return child;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (this.getChildAddr(index) == 0L) {
                DirectoryPage copy = (DirectoryPage)this.copyOnWrite(0L);
                return copy.setLazyChild(index);
            }
            return null;
        }
    }

    private BucketPage setLazyChild(int index) {
        DirectoryPage copy = (DirectoryPage)this.copyOnWrite(0L);
        assert (copy == this);
        assert (this.childRefs[index] == null);
        BucketPage lazyChild = new BucketPage((HTree)this.htree, this.htree.addressBits);
        lazyChild.parent = this.self;
        ++((HTree)this.htree).nleaves;
        this.fillEmptySlots(index, lazyChild);
        this.htree.touch(lazyChild);
        return lazyChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractPage _getChild(int index, AbstractHTree.LoadChildRequest req) {
        Reference<AbstractPage>[] referenceArray = this.childRefs;
        synchronized (this.childRefs) {
            AbstractPage child;
            Reference<AbstractPage> childRef = this.childRefs[index];
            AbstractPage abstractPage = child = childRef == null ? null : childRef.get();
            if (child != null) {
                this.htree.touch(child);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return child;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            int tableWidth = 1 << this.globalDepth;
            int tableOffset = index / tableWidth;
            long addr = this.data.getChildAddr(index);
            if (addr == 0L) {
                throw new AssertionError((Object)("Child does not have persistent identity: this=" + this + ", index=" + index));
            }
            int n = 0;
            int lastIndex = tableOffset + tableWidth;
            for (int i = tableOffset; i < lastIndex; ++i) {
                if (this.data.getChildAddr(i) != addr) continue;
                ++n;
            }
            assert (n > 0);
            int npointers = n;
            int localDepth = HTreeUtil.getLocalDepth(this.htree.addressBits, this.globalDepth, npointers);
            assert (npointers == 1 << this.htree.addressBits - localDepth);
            child = this.htree.readNodeOrLeaf(addr);
            child.globalDepth = !child.isLeaf() && ((DirectoryPage)child).isOverflowDirectory() ? this.getOverflowPageDepth() : localDepth;
            Reference<AbstractPage>[] referenceArray2 = this.childRefs;
            synchronized (this.childRefs) {
                int n2 = 0;
                int lastIndex2 = tableOffset + tableWidth;
                for (int i = tableOffset; i < lastIndex2; ++i) {
                    if (this.data.getChildAddr(i) != addr) continue;
                    assert (this.childRefs[i] == null || this.childRefs[i].get() == null) : "Child is already set: this=" + this + ", index=" + i;
                    this.childRefs[i] = child.self;
                    ++n2;
                }
                child.parent = this.self;
                assert (n2 == npointers);
                // ** MonitorExit[var10_12] (shouldn't be in output)
                if (req != null) {
                    this.htree.memo.removeFromCache(req);
                }
                this.htree.touch(child);
                return child;
            }
        }
    }

    @Override
    public AbstractFixedByteArrayBuffer data() {
        return this.data.data();
    }

    @Override
    public long getChildAddr(int index) {
        return this.data.getChildAddr(index);
    }

    @Override
    public int getChildCount() {
        return this.data.getChildCount();
    }

    @Override
    public long getMaximumVersionTimestamp() {
        return this.data.getMaximumVersionTimestamp();
    }

    @Override
    public long getMinimumVersionTimestamp() {
        return this.data.getMinimumVersionTimestamp();
    }

    @Override
    public boolean hasVersionTimestamps() {
        return this.data.hasVersionTimestamps();
    }

    @Override
    public boolean isCoded() {
        return this.data.isCoded();
    }

    @Override
    public boolean isLeaf() {
        return this.data.isLeaf();
    }

    @Override
    public boolean isReadOnly() {
        return this.data.isReadOnly();
    }

    public DirectoryPage(HTree htree, byte[] overflowKey, int globalDepth) {
        super(htree, true, globalDepth);
        this.childRefs = new Reference[1 << htree.addressBits];
        int n = htree.addressBits;
        htree.getClass();
        this.data = new MutableDirectoryPageData(overflowKey, n, false);
        ++createdPages;
    }

    DirectoryPage(HTree htree, long addr, IDirectoryData data) {
        super(htree, false, 0);
        this.setIdentity(addr);
        this.data = data;
        this.childRefs = new Reference[1 << htree.addressBits];
        ++createdPages;
    }

    protected DirectoryPage(DirectoryPage src, long triggeredByChildId) {
        super(src);
        ++createdPages;
        assert (!src.isDirty());
        assert (src.isReadOnly());
        int slotsOnPage = 1 << this.htree.addressBits;
        assert (src.data != null);
        IDirectoryData iDirectoryData = this.data = src.isReadOnly() ? new MutableDirectoryPageData(this.htree.addressBits, src.data) : src.data;
        assert (this.data != null);
        src.data = null;
        this.childRefs = src.childRefs;
        src.childRefs = null;
        for (int i = 0; i < slotsOnPage; ++i) {
            AbstractPage child = this.deref(i);
            if (child == null || this.htree.store != null && child.getIdentity() == triggeredByChildId) continue;
            assert (!child.isDirty());
            child.parent = this.self;
        }
    }

    @Override
    public Iterator<AbstractPage> postOrderNodeIterator(boolean dirtyNodesOnly, boolean nodesOnly) {
        if (dirtyNodesOnly && !this.dirty) {
            return EmptyIterator.DEFAULT;
        }
        return new Striterator(this.postOrderIterator1(dirtyNodesOnly, nodesOnly)).append(new SingleValueIterator<DirectoryPage>(this));
    }

    public Iterator<AbstractPage> postOrderIterator() {
        return new Striterator(this.postOrderIterator2()).append(new SingleValueIterator<DirectoryPage>(this));
    }

    private Iterator<AbstractPage> postOrderIterator2() {
        return new Striterator(this.childIterator()).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object childObj) {
                AbstractPage child = (AbstractPage)childObj;
                if (!child.isLeaf()) {
                    Striterator itr = new Striterator(((DirectoryPage)child).postOrderIterator2());
                    itr.append(new SingleValueIterator<AbstractPage>(child));
                    return itr;
                }
                return new SingleValueIterator<AbstractPage>(child);
            }
        });
    }

    private Iterator<AbstractPage> childIterator() {
        return new ChildIterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{ isDirty=" + this.isDirty());
        sb.append(", isDeleted=" + this.isDeleted());
        sb.append(", addr=" + this.identity);
        DirectoryPage p = this.parent == null ? null : (DirectoryPage)this.parent.get();
        sb.append(", parent=" + (p == null ? "N/A" : p.toShortString()));
        sb.append(", isRoot=" + (this.htree.root == this));
        if (this.data == null) {
            sb.append(", data=NA}");
            return sb.toString();
        }
        sb.append(", globalDepth=" + this.getGlobalDepth());
        sb.append(", nbuddies=" + (1 << this.htree.addressBits) / (1 << this.globalDepth));
        sb.append(", slotsPerBuddy=" + (1 << this.globalDepth));
        DirectoryPage.toString(this, sb);
        int nchildren = this.getChildCount();
        sb.append(", children=[");
        for (int i = 0; i < nchildren; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            AbstractPage child = this.childRefs[i] == null ? null : this.childRefs[i].get();
            sb.append(child == null ? "U" : "L");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    private Iterator<AbstractPage> postOrderIterator1(final boolean dirtyNodesOnly, final boolean nodesOnly) {
        return new Striterator(this.childIterator(dirtyNodesOnly)).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object childObj) {
                AbstractPage child = (AbstractPage)childObj;
                if (dirtyNodesOnly && !child.isDirty()) {
                    return EmptyIterator.DEFAULT;
                }
                if (child instanceof DirectoryPage) {
                    Striterator itr = new Striterator(((DirectoryPage)child).postOrderIterator1(dirtyNodesOnly, nodesOnly));
                    itr.append(new SingleValueIterator<AbstractPage>(child));
                    return itr;
                }
                if (nodesOnly) {
                    return EmptyIterator.DEFAULT;
                }
                return new SingleValueIterator<AbstractPage>(child);
            }
        });
    }

    public Iterator<AbstractPage> childIterator(boolean dirtyNodesOnly) {
        if (dirtyNodesOnly) {
            return new DirtyChildIterator(this);
        }
        return new ChildIterator();
    }

    @Override
    protected boolean dump(Level level, PrintStream out, int height, boolean recursive, boolean materialize) {
        boolean debug = level.toInt() <= Level.DEBUG.toInt();
        boolean ok = true;
        if (this == this.htree.root) {
            if (this.parent != null) {
                out.println(DirectoryPage.indent(height) + "ERROR: this is the root, but the parent is not null.");
                ok = false;
            }
        } else if (this.parent == null) {
            out.println(DirectoryPage.indent(height) + "ERROR: the parent reference MUST be defined for a non-root node.");
            ok = false;
        } else if (this.parent.get() == null) {
            out.println(DirectoryPage.indent(height) + "ERROR: the parent is not strongly reachable.");
            ok = false;
        }
        if (debug) {
            out.println(DirectoryPage.indent(height) + this.toString());
        }
        for (int i = 0; i < 1 << this.htree.addressBits; ++i) {
            AbstractPage child;
            AbstractPage abstractPage = child = this.childRefs[i] == null ? null : this.childRefs[i].get();
            if (child == null) continue;
            if (child.parent == null || child.parent.get() == null) {
                out.println(DirectoryPage.indent(height) + "  ERROR child[" + i + "] does not have parent reference.");
                ok = false;
            }
            if (child.parent.get() != this) {
                out.println(DirectoryPage.indent(height) + "  ERROR child[" + i + "] has wrong parent.");
                ok = false;
            }
            if (child.isDirty()) {
                if (!this.isDirty()) {
                    out.println(DirectoryPage.indent(height) + "  ERROR child[" + i + "] is dirty, but its parent is clean");
                    ok = false;
                }
                if (this.childRefs[i] == null) {
                    out.println(DirectoryPage.indent(height) + "  ERROR childRefs[" + i + "] is null, but the child is dirty");
                    ok = false;
                }
                if (this.getChildAddr(i) == 0L) continue;
                out.println(DirectoryPage.indent(height) + "  ERROR childAddr[" + i + "]=" + this.getChildAddr(i) + ", but MUST be " + 0L + " since the child is dirty");
                ok = false;
                continue;
            }
            if (this.getChildAddr(i) != 0L) continue;
            out.println(DirectoryPage.indent(height) + "  ERROR childKey[" + i + "] is " + 0L + ", but child is not dirty");
            ok = false;
        }
        if (ok || !debug) {
            // empty if block
        }
        if (recursive) {
            HashSet<AbstractPage> dirty = new HashSet<AbstractPage>();
            for (int i = 0; i < 1 << this.htree.addressBits; ++i) {
                AbstractPage child;
                if (this.childRefs[i] == null && !this.isReadOnly() && ((MutableDirectoryPageData)this.data).childAddr[i] == 0L) {
                    out.println(DirectoryPage.indent(height + 1) + "ERROR can not find child at index=" + i + ", skipping this index.");
                    ok = false;
                    continue;
                }
                AbstractPage abstractPage = child = this.childRefs[i] == null ? null : this.childRefs[i].get();
                if (child == null) continue;
                if (child.parent == null) {
                    out.println(DirectoryPage.indent(height + 1) + "ERROR child does not have parent reference at index=" + i);
                    ok = false;
                }
                if (child.parent.get() != this) {
                    out.println(DirectoryPage.indent(height + 1) + "ERROR child has incorrect parent reference at index=" + i);
                    ok = false;
                }
                if (child.isDirty()) {
                    dirty.add(child);
                }
                if (child.dump(level, out, height + 1, true, materialize)) continue;
                ok = false;
            }
        }
        return ok;
    }

    @Override
    public void dumpPages(HTreePageStats stats) {
        stats.visit(this.htree, this);
        Iterator<AbstractPage> itr = this.childIterator();
        while (itr.hasNext()) {
            AbstractPage child = itr.next();
            child.dumpPages(stats);
        }
    }

    public static StringBuilder toString(IDirectoryData data, StringBuilder sb) {
        int nchildren = data.getChildCount();
        sb.append(", nchildren=" + nchildren);
        sb.append(",\nchildAddr=[");
        for (int i = 0; i < nchildren; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(data.getChildAddr(i));
        }
        sb.append("]");
        if (data.hasVersionTimestamps()) {
            sb.append(",\nversionTimestamps={min=" + data.getMinimumVersionTimestamp() + ",max=" + data.getMaximumVersionTimestamp() + "}");
        }
        return sb;
    }

    @Override
    public void PP(StringBuilder sb, boolean showBinary) {
        sb.append(this.PPID() + " [" + this.globalDepth + "] " + DirectoryPage.indent(this.getLevel()));
        sb.append("(");
        int nbuddies = (1 << this.htree.addressBits) / (1 << this.globalDepth);
        int slotsPerBuddy = 1 << this.globalDepth;
        for (int i = 0; i < nbuddies; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            for (int j = 0; j < slotsPerBuddy; ++j) {
                AbstractPage child;
                int slot = i * slotsPerBuddy + j;
                if (j > 0) {
                    sb.append(",");
                }
                sb.append((child = this.getChildIfPresent(slot)) == null ? "-" : child.PPID());
            }
        }
        sb.append(")");
        sb.append("\n");
        Iterator<AbstractPage> itr = this.childIterator();
        while (itr.hasNext()) {
            AbstractPage child = itr.next();
            child.PP(sb, showBinary);
        }
    }

    AbstractPage getChildIfPresent(int slot) {
        if (this.childRefs[slot] == null && this.data.getChildAddr(slot) == 0L) {
            return null;
        }
        return this.getChild(slot);
    }

    void replaceChildRef(long oldChildAddr, AbstractPage newChild) {
        assert (oldChildAddr != 0L || this.htree.store == null);
        assert (newChild != null);
        assert (!this.isPersistent());
        assert (!this.isReadOnly());
        assert (!newChild.isPersistent());
        assert (!this.isReadOnly());
        MutableDirectoryPageData data = (MutableDirectoryPageData)this.data;
        int slotsOnPage = 1 << this.htree.addressBits;
        int npointers = 0;
        boolean found = false;
        for (int i = 0; i < slotsOnPage; ++i) {
            if (data.childAddr[i] == oldChildAddr) {
                found = true;
                if (npointers == 0) {
                    this.htree.deleteNodeOrLeaf(oldChildAddr);
                }
                data.childAddr[i] = 0L;
                this.childRefs[i] = newChild.self;
                if (newChild.isPersistent()) {
                    data.childAddr[i] = newChild.getIdentity();
                }
                newChild.parent = this.self;
                ++npointers;
                continue;
            }
            if (found) break;
        }
        if (npointers == 0) {
            throw new IllegalArgumentException("Not our child : oldChildAddr=" + oldChildAddr);
        }
    }

    int replaceChildRef(Reference<?> oldRef, AbstractPage newChild) {
        int slotsOnPage = 1 << this.htree.addressBits;
        MutableDirectoryPageData data = (MutableDirectoryPageData)this.data;
        int firstSlot = -1;
        int npointers = 0;
        for (int i = 0; i < slotsOnPage; ++i) {
            if (this.childRefs[i] != oldRef) continue;
            if (firstSlot == -1) {
                firstSlot = i;
            }
            data.childAddr[i] = 0L;
            if (newChild != null) {
                this.childRefs[i] = newChild.self;
                if (newChild.isPersistent()) {
                    data.childAddr[i] = newChild.getIdentity();
                }
                newChild.parent = this.self;
            } else {
                this.childRefs[i] = null;
            }
            ++npointers;
        }
        assert (npointers > 0);
        return firstSlot;
    }

    @Override
    @Deprecated
    int activeBucketPages() {
        int ret = 0;
        Iterator<AbstractPage> children = this.childIterator();
        while (children.hasNext()) {
            ret += children.next().activeBucketPages();
        }
        return ret;
    }

    @Override
    @Deprecated
    int activeDirectoryPages() {
        int ret = 1;
        Iterator<AbstractPage> children = this.childIterator();
        while (children.hasNext()) {
            ret += children.next().activeDirectoryPages();
        }
        return ret;
    }

    void _addLevel(BucketPage bucketPage) {
        int bucketRefs;
        assert (!this.isReadOnly());
        assert (!this.isOverflowDirectory());
        DirectoryPage ndir = new DirectoryPage((HTree)this.htree, null, this.htree.addressBits);
        ++((HTree)this.htree).nnodes;
        BucketPage newPage = this.createPage(1);
        newPage.parent = ndir.self;
        byte[] tstkey = bucketPage.getFirstKey();
        int bucketSlot = this.getLocalHashCode(tstkey, this.getPrefixLength() + this.globalDepth);
        boolean fillLowerSlots = bucketSlot < (bucketRefs = 1 << this.htree.addressBits >> 1);
        Reference a = fillLowerSlots ? newPage.self : null;
        Reference b = fillLowerSlots ? null : newPage.self;
        for (int i = 0; i < bucketRefs; ++i) {
            ndir.childRefs[i] = a;
            ndir.childRefs[i + bucketRefs] = b;
        }
        this.replaceChildRef(bucketPage.self, (AbstractPage)ndir);
        bucketPage.delete();
        int bucketSlotsPerPage = bucketPage.slotsOnPage();
        for (int i = 0; i < bucketSlotsPerPage; ++i) {
            ((HTree)this.htree).insertRawTuple(bucketPage, i);
        }
        if (bucketPage.isPersistent()) {
            this.htree.deleteNodeOrLeaf(bucketPage.getIdentity());
        }
    }

    void _addChild(AbstractPage child) {
        assert (this.isOverflowDirectory());
        assert (!this.isReadOnly());
        MutableDirectoryPageData pdata = (MutableDirectoryPageData)this.data;
        for (int i = 0; i < pdata.childAddr.length; ++i) {
            AbstractPage aChild;
            AbstractPage abstractPage = aChild = this.childRefs[i] == null ? null : this.childRefs[i].get();
            if (aChild != null || pdata.childAddr[i] != 0L) continue;
            this.childRefs[i] = child.self;
            assert (!child.isPersistent());
            child.parent = this.self;
            return;
        }
        DirectoryPage pd = this.getParentDirectory();
        if (pd.isOverflowDirectory()) {
            assert (false);
        } else {
            DirectoryPage blob = new DirectoryPage((HTree)this.htree, this.getOverflowKey(), this.getOverflowPageDepth());
            blob._addChild(this);
            blob._addChild(child);
            pd.replaceChildRef(this.self, (AbstractPage)blob);
            if (log.isInfoEnabled()) {
                log.info((Object)("New Overflow Level: " + this.getLevel()));
            }
        }
    }

    BucketPage lastChild() {
        assert (this.isOverflowDirectory());
        for (int i = this.data.getChildCount() - 1; i >= 0; --i) {
            BucketPage aChild = (BucketPage)this.deref(i);
            if (aChild != null) {
                return aChild;
            }
            if (this.data.getChildAddr(i) == 0L) continue;
            return (BucketPage)this.getChild(i);
        }
        throw new AssertionError();
    }

    protected AbstractPage deref(int index) {
        return this.childRefs[index] == null ? null : this.childRefs[index].get();
    }

    @Override
    public boolean isOverflowDirectory() {
        return this.data.isOverflowDirectory();
    }

    @Override
    public int getLocalHashCode(byte[] key, int prefixLength) {
        if (this.isOverflowDirectory()) {
            return 0;
        }
        return super.getLocalHashCode(key, prefixLength);
    }

    public void split(int buddyOffset, DirectoryPage oldChild) {
        throw new UnsupportedOperationException();
    }

    private void updatePointers(int buddyOffset, int oldDepth, AbstractPage oldChild, AbstractPage newChild) {
        int i;
        int slotsPerBuddy = 1 << this.globalDepth;
        int npointers = 1 << this.globalDepth - oldDepth;
        if (slotsPerBuddy <= 1) {
            throw new AssertionError((Object)("slotsPerBuddy=" + slotsPerBuddy));
        }
        assert (npointers > 1) : "npointers=" + npointers;
        int firstSlot = buddyOffset;
        int lastSlot = buddyOffset + slotsPerBuddy;
        int firstPointer = -1;
        int nfound = 0;
        boolean discontiguous = false;
        for (i = firstSlot; i < lastSlot; ++i) {
            if (this.childRefs[i] == oldChild.self) {
                if (firstPointer == -1) {
                    firstPointer = i;
                }
                ++nfound;
                if (((MutableDirectoryPageData)this.data).childAddr[i] == 0L) continue;
                throw new RuntimeException("Child address should be NULL since child is dirty");
            }
            if (firstPointer == -1 || nfound == npointers) continue;
            discontiguous = true;
        }
        if (firstPointer == -1) {
            throw new RuntimeException("No pointers to child");
        }
        if (nfound != npointers) {
            throw new RuntimeException("Expected " + npointers + " pointers to child, but found=" + nfound);
        }
        if (discontiguous) {
            throw new RuntimeException("Pointers to child are discontiguous in parent's buddy hash table.");
        }
        for (i = firstPointer + (npointers >> 1); i < npointers; ++i) {
            if (this.childRefs[i] != oldChild.self) {
                throw new RuntimeException("Does not point to old child.");
            }
            this.childRefs[i] = newChild.self;
            assert (!newChild.isPersistent());
        }
    }

    private void redistributeBuddyTables(int oldDepth, int newDepth, DirectoryPage oldDir, DirectoryPage newDir) {
        int i;
        int dstSlot;
        int srcSlot;
        int lastSrcSlot;
        int firstSrcSlot;
        assert (oldDepth + 1 == newDepth);
        int slotsOnPage = 1 << this.htree.addressBits;
        int slotsPerOldBuddy = 1 << oldDepth;
        int slotsPerNewBuddy = 1 << newDepth;
        int oldBuddyCount = slotsOnPage / slotsPerOldBuddy;
        int newBuddyCount = slotsOnPage / slotsPerNewBuddy;
        DirectoryPage srcPage = oldDir;
        long[] srcAddrs = ((MutableDirectoryPageData)oldDir.data).childAddr;
        Reference<AbstractPage>[] srcRefs = oldDir.childRefs;
        DirectoryPage dstPage = newDir;
        long[] dstAddrs = ((MutableDirectoryPageData)dstPage.data).childAddr;
        Reference<AbstractPage>[] dstRefs = dstPage.childRefs;
        int firstSrcBuddyIndex = oldBuddyCount >> 1;
        int lastSrcBuddyIndex = oldBuddyCount;
        int lastDstBuddyIndex = newBuddyCount;
        int srcBuddyIndex = lastSrcBuddyIndex - 1;
        int dstBuddyIndex = lastDstBuddyIndex - 1;
        while (srcBuddyIndex >= firstSrcBuddyIndex) {
            firstSrcSlot = srcBuddyIndex * slotsPerOldBuddy;
            lastSrcSlot = (srcBuddyIndex + 1) * slotsPerOldBuddy;
            int firstDstSlot = dstBuddyIndex * slotsPerNewBuddy;
            srcSlot = firstSrcSlot;
            dstSlot = firstDstSlot;
            while (srcSlot < lastSrcSlot) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("moving: page(" + srcPage.toShortString() + "=>" + dstPage.toShortString() + ")" + ", buddyIndex(" + srcBuddyIndex + "=>" + dstBuddyIndex + ")" + ", slot(" + srcSlot + "=>" + dstSlot + ")"));
                }
                for (i = 0; i < 2; ++i) {
                    dstAddrs[dstSlot + i] = srcAddrs[srcSlot];
                    dstRefs[dstSlot + i] = srcRefs[srcSlot];
                }
                ++srcSlot;
                dstSlot += 2;
            }
            --srcBuddyIndex;
            --dstBuddyIndex;
        }
        dstPage = oldDir;
        dstAddrs = ((MutableDirectoryPageData)dstPage.data).childAddr;
        dstRefs = dstPage.childRefs;
        firstSrcBuddyIndex = 0;
        lastSrcBuddyIndex = oldBuddyCount >> 1;
        lastDstBuddyIndex = newBuddyCount;
        srcBuddyIndex = lastSrcBuddyIndex - 1;
        dstBuddyIndex = lastDstBuddyIndex - 1;
        while (srcBuddyIndex >= 0) {
            firstSrcSlot = srcBuddyIndex * slotsPerOldBuddy;
            lastSrcSlot = (srcBuddyIndex + 1) * slotsPerOldBuddy;
            int lastDstSlot = (dstBuddyIndex + 1) * slotsPerNewBuddy;
            srcSlot = lastSrcSlot - 1;
            dstSlot = lastDstSlot - 1;
            while (srcSlot >= firstSrcSlot) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("moving: page(" + srcPage.toShortString() + "=>" + dstPage.toShortString() + ")" + ", buddyIndex(" + srcBuddyIndex + "=>" + dstBuddyIndex + ")" + ", slot(" + srcSlot + "=>" + dstSlot + ")"));
                }
                for (i = 0; i < 2; ++i) {
                    dstAddrs[dstSlot - i] = srcAddrs[srcSlot];
                    dstRefs[dstSlot - i] = srcRefs[srcSlot];
                }
                --srcSlot;
                dstSlot -= 2;
            }
            --srcBuddyIndex;
            --dstBuddyIndex;
        }
    }

    public ITupleIterator getTuples() {
        final Striterator tups = new Striterator(this.childIterator());
        tups.addFilter(new Expander(){

            @Override
            protected Iterator expand(Object obj) {
                if (obj instanceof BucketPage) {
                    return ((BucketPage)obj).tuples();
                }
                return ((DirectoryPage)obj).getTuples();
            }
        });
        return new ITupleIterator(){

            @Override
            public ITuple next() {
                return (ITuple)tups.next();
            }

            @Override
            public boolean hasNext() {
                return tups.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    boolean isClean() {
        for (int i = 0; i < this.childRefs.length; ++i) {
            AbstractPage node = this.deref(i);
            if (node == null || node.isClean()) continue;
            return false;
        }
        return !this.isDirty();
    }

    @Override
    public byte[] getOverflowKey() {
        return this.data.getOverflowKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryPage _addLevelForOverflow(DirectoryPage current) {
        if (this.isReadOnly()) {
            DirectoryPage copy = (DirectoryPage)this.copyOnWrite(current.getIdentity());
            return copy._addLevelForOverflow(current);
        }
        DirectoryPage newdir = new DirectoryPage((HTree)this.htree, null, this.htree.addressBits);
        if (this.isReadOnly()) assert (!this.isReadOnly());
        this.replaceChildRef(current.self, (AbstractPage)newdir);
        byte[] overflowKey = current.getOverflowKey();
        int slot = newdir.getLocalHashCode(overflowKey, newdir._getPrefixLength());
        newdir.childRefs[slot] = current.self;
        ((MutableDirectoryPageData)newdir.data).childAddr[slot] = current.identity;
        current.parent = newdir.self;
        try {
            current._protectFromEviction();
            newdir._fillChildSlots(slot, 0, this.childRefs.length, 0);
        }
        finally {
            current._releaseProtection();
        }
        return newdir;
    }

    private void _touchHierarchy() {
        for (DirectoryPage dp = this; dp != null; dp = dp.getParentDirectory()) {
            this.htree.touch(dp);
        }
    }

    private void _releaseProtection() {
        for (DirectoryPage dp = this; dp != null; dp = dp.getParentDirectory()) {
            if (--dp.referenceCount != 0) continue;
            this.htree.writeNodeRecursive(dp);
        }
    }

    private void _protectFromEviction() {
        for (DirectoryPage dp = this; dp != null; dp = dp.getParentDirectory()) {
            ++dp.referenceCount;
        }
    }

    private void _fillChildSlots(int slot, int offset, int length, int depth) {
        assert (!this.isReadOnly());
        if (slot == offset && length == 1) {
            assert (this.childRefs[offset] != null);
            return;
        }
        if (slot >= offset && slot < offset + length) {
            int delta = length / 2;
            this._fillChildSlots(slot, offset, delta, depth + 1);
            this._fillChildSlots(slot, offset + delta, delta, depth + 1);
        } else {
            BucketPage bp = new BucketPage((HTree)this.htree, depth);
            bp.parent = this.self;
            ++((HTree)this.htree).nleaves;
            for (int s = 0; s < length; ++s) {
                if (this.isReadOnly()) assert (!this.isReadOnly());
                assert (this.childRefs[offset + s] == null);
                this.childRefs[offset + s] = bp.self;
            }
        }
    }

    int _getPrefixLength() {
        int prefixLength = 0;
        for (DirectoryPage p = this.getParentDirectory(); p != null; p = p.getParentDirectory()) {
            prefixLength += p.globalDepth;
        }
        return prefixLength;
    }

    void _ensureUniqueBucketPage(byte[] key, Reference<? extends AbstractPage> bp) {
        int prefixLength = this._getPrefixLength();
        int hashBits = this.getLocalHashCode(key, prefixLength);
        assert (this.childRefs[hashBits] == bp);
        int start = -1;
        int refs = 0;
        for (int i = 0; i < this.childRefs.length; ++i) {
            if (this.childRefs[i] != bp) continue;
            start = start == -1 ? i : start;
            ++refs;
            if (i == hashBits) continue;
            this.childRefs[i] = null;
            ((MutableDirectoryPageData)this.data).childAddr[i] = 0L;
        }
        assert (Integer.bitCount(refs) == 1);
    }

    @Override
    public final int removeAll(byte[] key) {
        int i;
        if (!this.isOverflowDirectory()) {
            throw new UnsupportedOperationException("Only valid if page is an overflow directory");
        }
        if (this.isReadOnly()) {
            DirectoryPage copy = (DirectoryPage)this.copyOnWrite(this.getIdentity());
            return copy.removeAll(key);
        }
        int ret = 0;
        for (i = 0; i < this.childRefs.length; ++i) {
            AbstractPage tmp = this.deref(i);
            if (tmp == null && this.data.getChildAddr(i) != 0L) {
                tmp = this.getChild(i);
            }
            if (tmp == null) break;
            ret += tmp.removeAll(key);
        }
        for (i = 0; i < this.childRefs.length; ++i) {
            long addr = this.data.getChildAddr(i);
            if (addr == 0L) continue;
            this.htree.deleteNodeOrLeaf(addr);
        }
        return ret;
    }

    @Override
    public final byte[] removeFirst(byte[] key) {
        if (!this.isOverflowDirectory()) {
            throw new UnsupportedOperationException("Only valid if page is an overflow directory");
        }
        if (BytesUtil.compareBytes(key, this.getOverflowKey()) == 0) {
            BucketPage last = this.lastChild();
            if (last.isLeaf()) {
                BucketPage lastbp = (BucketPage)last.copyOnWrite();
                byte[] ret = lastbp.removeFirst(key);
                if (lastbp.getValues().isEmpty()) {
                    AbstractPage odc;
                    DirectoryPage dp = lastbp.getParentDirectory();
                    int slot = dp.replaceChildRef(lastbp.self, null);
                    lastbp.delete();
                    if (slot == 1 && !(odc = dp.getChild(0)).isLeaf()) {
                        DirectoryPage od = (DirectoryPage)odc;
                        assert (od.isOverflowDirectory());
                        DirectoryPage gdp = dp.getParentDirectory();
                        assert (gdp != null);
                        gdp.replaceChildRef(dp.self, (AbstractPage)od);
                        dp.delete();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Promoted child overflowDirectory after remove from last BucketPage");
                        }
                    }
                }
                return ret;
            }
            return ((AbstractPage)last).removeFirst(key);
        }
        return null;
    }

    public void removeAll() {
        Iterator<AbstractPage> chs = this.childIterator(false);
        while (chs.hasNext()) {
            AbstractPage ch = chs.next();
            if (ch instanceof BucketPage) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing bucket page: " + ch.PPID()));
                }
                if (!ch.isPersistent()) continue;
                this.htree.store.delete(ch.getIdentity());
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing child directory page: " + ch.PPID()));
            }
            ((DirectoryPage)ch).removeAll();
        }
        if (this.identity != 0L) {
            this.htree.store.delete(this.identity);
        }
    }

    private class ChildIterator
    implements Iterator<AbstractPage> {
        private final int slotsPerPage;
        private int slot;
        private AbstractPage child;

        private ChildIterator() {
            this.slotsPerPage = 1 << DirectoryPage.this.htree.addressBits;
            this.slot = 0;
            this.child = null;
            this.nextChild();
        }

        private boolean nextChild() {
            while (this.slot < this.slotsPerPage) {
                AbstractPage tmp = DirectoryPage.this.deref(this.slot);
                if (tmp != null || DirectoryPage.this.data.getChildAddr(this.slot) != 0L) {
                    AbstractPage abstractPage = tmp = tmp == null ? DirectoryPage.this.getChild(this.slot) : tmp;
                    if (tmp != this.child) {
                        this.child = tmp;
                        return true;
                    }
                }
                ++this.slot;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.slot < this.slotsPerPage;
        }

        @Override
        public AbstractPage next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AbstractPage tmp = this.child;
            this.nextChild();
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

