/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.io.IByteArraySlice;
import com.bigdata.io.compression.IRecordCompressor;
import com.bigdata.util.ChecksumUtility;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;

public class AllocationData {
    IByteArraySlice slice;
    boolean compressed;
    boolean checksummed;
    int chk;

    public AllocationData(IByteArraySlice slice) {
        this.slice = slice;
    }

    public AllocationData compress(IRecordCompressor compressor) {
        if (this.compressed) {
            return this;
        }
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        compressor.compress(this.slice.array(), (OutputStream)outstr);
        return new AllocationData(new SimpleSlice(outstr.toByteArray()));
    }

    public AllocationData decompress(IRecordCompressor compressor) {
        if (!this.compressed) {
            return new AllocationData(new SimpleSlice(compressor.decompress(this.slice.array())));
        }
        return null;
    }

    public int checksum() {
        if (!this.checksummed) {
            this.chk = ChecksumUtility.getCHK().checksum(this.slice);
        }
        return this.chk;
    }

    public void write(Channel channel) {
    }

    public static AllocationData read(Channel channel) {
        return null;
    }

    private static class SimpleSlice
    implements IByteArraySlice {
        private final byte[] buf;

        SimpleSlice(ByteBuffer bb) {
            this.buf = bb.array();
        }

        SimpleSlice(byte[] bb) {
            this.buf = bb;
        }

        @Override
        public byte[] array() {
            return this.buf;
        }

        @Override
        public int len() {
            return this.buf.length;
        }

        @Override
        public int off() {
            return 0;
        }

        @Override
        public byte[] toByteArray() {
            return (byte[])this.buf.clone();
        }
    }
}

