/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.btree.BytesUtil;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.IByteArrayBuffer;
import com.bigdata.io.LongPacker;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class ByteArrayBuffer
extends OutputStream
implements IByteArrayBuffer,
RepositionableStream,
LongPacker.IByteBuffer {
    private static final transient Logger log = Logger.getLogger(ByteArrayBuffer.class);
    public static final int DEFAULT_INITIAL_CAPACITY = 128;
    byte[] buf;
    int pos = 0;
    int limit;
    private int mark = 0;
    private final byte[] pbuf = new byte[8];

    @Override
    public final byte[] array() {
        return this.buf;
    }

    @Override
    public final int off() {
        return 0;
    }

    @Override
    public final int len() {
        return this.buf.length;
    }

    protected static int assertNonNegative(String msg, int v) {
        if (v < 0) {
            throw new IllegalArgumentException(msg);
        }
        return v;
    }

    public ByteArrayBuffer() {
        this(128);
    }

    public ByteArrayBuffer(int initialCapacity) {
        this(0, 0, new byte[ByteArrayBuffer.assertNonNegative("initialCapacity", initialCapacity)]);
    }

    public final void ensureFree(int pos, int len) {
        this.ensureCapacity(pos + len);
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (this.buf == null) {
            this.buf = new byte[capacity];
            return;
        }
        int overflow = capacity - this.buf.length;
        if (overflow > 0) {
            byte[] tmp = new byte[this.extend(capacity)];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
        }
    }

    @Override
    public final int capacity() {
        return this.buf == null ? 0 : this.buf.length;
    }

    protected int extend(int required) {
        int capacity = Math.max(required, this.capacity() * 2);
        if (log.isInfoEnabled()) {
            log.info((Object)("Extending buffer to capacity=" + capacity + " bytes."));
        }
        return capacity;
    }

    public final byte[] trim() {
        byte[] tmp = this.buf;
        assert (this.limit == this.pos);
        byte[] a = new byte[this.limit];
        assert (this.off() == 0);
        System.arraycopy(tmp, this.off(), a, 0, a.length);
        this.buf = a;
        return tmp;
    }

    public final void clear() {
        this.buf = null;
    }

    @Override
    public final void put(int pos, byte[] b) {
        this.put(pos, b, 0, b.length);
    }

    @Override
    public final void put(int pos, byte[] b, int off, int len) {
        this.ensureCapacity(pos + len);
        System.arraycopy(b, off, this.buf, pos, len);
    }

    @Override
    public final void get(int srcoff, byte[] dst) {
        this.get(srcoff, dst, 0, dst.length);
    }

    @Override
    public final void get(int srcoff, byte[] dst, int dstoff, int dstlen) {
        System.arraycopy(this.buf, srcoff, dst, dstoff, dstlen);
    }

    @Override
    public final void putByte(int pos, byte v) {
        if (pos + 1 > this.buf.length) {
            this.ensureCapacity(pos + 1);
        }
        this.buf[pos] = v;
    }

    @Override
    public final byte getByte(int pos) {
        return this.buf[pos];
    }

    @Override
    public final void putShort(int pos, short v) {
        if (pos + 2 > this.buf.length) {
            this.ensureCapacity(pos + 2);
        }
        this.buf[pos++] = (byte)(v >>> 8);
        this.buf[pos] = (byte)(v >>> 0);
    }

    @Override
    public final short getShort(int pos) {
        short v = 0;
        v = (short)(v + ((0xFF & this.buf[pos++]) << 8));
        v = (short)(v + ((0xFF & this.buf[pos]) << 0));
        return v;
    }

    @Override
    public final void putInt(int pos, int v) {
        if (pos + 4 > this.buf.length) {
            this.ensureCapacity(pos + 4);
        }
        this.buf[pos++] = (byte)(v >>> 24);
        this.buf[pos++] = (byte)(v >>> 16);
        this.buf[pos++] = (byte)(v >>> 8);
        this.buf[pos] = (byte)(v >>> 0);
    }

    @Override
    public final int getInt(int pos) {
        int v = 0;
        v += (0xFF & this.buf[pos++]) << 24;
        v += (0xFF & this.buf[pos++]) << 16;
        v += (0xFF & this.buf[pos++]) << 8;
        return v += (0xFF & this.buf[pos]) << 0;
    }

    @Override
    public final void putFloat(int pos, float f) {
        this.putInt(pos, Float.floatToIntBits(f));
    }

    @Override
    public final float getFloat(int pos) {
        return Float.intBitsToFloat(this.getInt(pos));
    }

    @Override
    public final void putLong(int pos, long v) {
        if (pos + 8 > this.buf.length) {
            this.ensureCapacity(pos + 8);
        }
        this.buf[pos++] = (byte)(v >>> 56);
        this.buf[pos++] = (byte)(v >>> 48);
        this.buf[pos++] = (byte)(v >>> 40);
        this.buf[pos++] = (byte)(v >>> 32);
        this.buf[pos++] = (byte)(v >>> 24);
        this.buf[pos++] = (byte)(v >>> 16);
        this.buf[pos++] = (byte)(v >>> 8);
        this.buf[pos] = (byte)(v >>> 0);
    }

    @Override
    public final void putDouble(int pos, double d) {
        this.putLong(pos, Double.doubleToLongBits(d));
    }

    @Override
    public final long getLong(int pos) {
        long v = 0L;
        v += (0xFFL & (long)this.buf[pos++]) << 56;
        v += (0xFFL & (long)this.buf[pos++]) << 48;
        v += (0xFFL & (long)this.buf[pos++]) << 40;
        v += (0xFFL & (long)this.buf[pos++]) << 32;
        v += (0xFFL & (long)this.buf[pos++]) << 24;
        v += (0xFFL & (long)this.buf[pos++]) << 16;
        v += (0xFFL & (long)this.buf[pos++]) << 8;
        return v += (0xFFL & (long)this.buf[pos]) << 0;
    }

    @Override
    public final double getDouble(int pos) {
        return Double.longBitsToDouble(this.getLong(pos));
    }

    @Override
    public final byte[] toByteArray() {
        byte[] tmp = new byte[this.pos];
        System.arraycopy(this.buf, 0, tmp, 0, this.pos);
        return tmp;
    }

    public ByteArrayBuffer(int pos, int limit, byte[] buf) {
        if (pos < 0) {
            throw new IllegalArgumentException("pos<0");
        }
        if (pos > limit) {
            throw new IllegalArgumentException("pos>limit");
        }
        if (buf == null) {
            throw new IllegalArgumentException("buf");
        }
        if (limit > buf.length) {
            throw new IllegalArgumentException("limit>buf.length");
        }
        this.buf = buf;
        this.pos = pos;
        this.limit = limit;
    }

    @Override
    public final int remaining() {
        return this.limit - this.pos;
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    public final int pos(int pos) {
        if (pos < 0 || pos >= this.buf.length) {
            throw new IllegalArgumentException("pos=" + pos + ", capacity=" + this.buf.length);
        }
        int v = this.pos;
        this.pos = pos;
        return v;
    }

    @Override
    public final int limit() {
        return this.limit;
    }

    public final void flip() {
        assert (this.limit == this.pos) : "pos=" + this.pos + ", limit=" + this.limit;
        this.pos = 0;
    }

    @Override
    public ByteArrayBuffer reset() {
        this.limit = 0;
        this.pos = 0;
        return this;
    }

    @Override
    public final void ensureFree(int len) {
        this.ensureCapacity(this.pos + len);
    }

    public final int mark() {
        int tmp = this.mark;
        this.mark = this.pos;
        return tmp;
    }

    public final int rewind() {
        this.pos = this.mark;
        return this.pos;
    }

    public final int copy(ByteBuffer src) {
        int n = src.remaining();
        if (n > 0) {
            this.ensureFree(n);
            src.get(this.buf, this.pos, n);
            this.pos += n;
            this.limit = this.pos;
        }
        return n;
    }

    public final int copyRest(ByteArrayBuffer src) {
        int n = src.remaining();
        if (n > 0) {
            this.put(src.buf, src.pos, n);
        }
        return n;
    }

    public final int copyAll(ByteArrayBuffer src) {
        int n = src.limit;
        if (n > 0) {
            this.put(src.buf, 0, n);
        }
        return n;
    }

    @Override
    public final ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.buf, this.pos, this.limit);
    }

    public final void advancePosAndLimit(int len) {
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        this.ensureCapacity(this.pos + len);
        this.pos += len;
        this.limit = this.pos;
    }

    public final void put(byte[] b) {
        this.put(this.pos, b, 0, b.length);
        this.pos += b.length;
        this.limit = this.pos;
    }

    @Override
    public final void put(byte[] b, int off, int len) {
        this.put(this.pos, b, off, len);
        this.pos += len;
        this.limit = this.pos;
    }

    public final void putByte(byte v) {
        this.putByte(this.pos, v);
        this.limit = ++this.pos;
    }

    public final byte getByte() {
        if (this.pos >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        byte v = this.getByte(this.pos);
        ++this.pos;
        return v;
    }

    public final void putShort(short v) {
        this.putShort(this.pos, v);
        this.pos += 2;
        this.limit = this.pos;
    }

    public final short getShort() {
        if (this.pos + 2 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        short v = this.getShort(this.pos);
        this.pos += 2;
        return v;
    }

    public final void putInt(int v) {
        this.putInt(this.pos, v);
        this.pos += 4;
        this.limit = this.pos;
    }

    public final int getInt() {
        if (this.pos + 4 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        int v = this.getInt(this.pos);
        this.pos += 4;
        return v;
    }

    public final void putFloat(float v) {
        this.putFloat(this.pos, v);
        this.pos += 4;
        this.limit = this.pos;
    }

    public final float getFloat() {
        if (this.pos + 4 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        float v = this.getFloat(this.pos);
        this.pos += 4;
        return v;
    }

    public final void putLong(long v) {
        this.putLong(this.pos, v);
        this.pos += 8;
        this.limit = this.pos;
    }

    public final long getLong() {
        if (this.pos + 8 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        long v = this.getLong(this.pos);
        this.pos += 8;
        return v;
    }

    public final void putDouble(double v) {
        this.putDouble(this.pos, v);
        this.pos += 8;
        this.limit = this.pos;
    }

    public final double getDouble() {
        if (this.pos + 8 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        double v = this.getDouble(this.pos);
        this.pos += 8;
        return v;
    }

    public final int packLong(long v) {
        return LongPacker.packLong(v, this.pbuf, this);
    }

    public final int packShort(short v) {
        if (v < 0) {
            throw new IllegalArgumentException("negative value: v=" + v);
        }
        if (v > 127) {
            if (this.pos + 2 > this.buf.length) {
                this.ensureCapacity(this.pos + 2);
            }
            this.buf[this.pos++] = (byte)(0xFF & v >> 8 | 0x80);
            this.buf[this.pos++] = (byte)(0xFF & v);
            this.limit = this.pos;
            return 2;
        }
        if (this.pos + 1 > this.buf.length) {
            this.ensureCapacity(this.pos + 1);
        }
        this.buf[this.pos++] = (byte)(0xFF & v);
        this.limit = this.pos;
        return 1;
    }

    @Override
    public final void write(int b) {
        if (this.pos + 1 > this.buf.length) {
            this.ensureCapacity(this.pos + 1);
        }
        this.buf[this.pos++] = (byte)(b & 0xFF);
        this.limit = this.pos;
    }

    @Override
    public final void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public ByteArrayBuffer append(byte b) {
        if (this.pos + 1 > this.buf.length) {
            this.ensureCapacity(this.pos + 1);
        }
        this.buf[this.pos++] = b;
        this.limit = this.pos;
        return this;
    }

    @Override
    public ByteArrayBuffer append(byte[] b) {
        return this.append(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureFree(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
        this.limit = this.pos;
    }

    @Override
    public ByteArrayBuffer append(byte[] b, int off, int len) {
        this.write(b, off, len);
        return this;
    }

    public long position() throws IOException {
        return this.pos;
    }

    public void position(long v) throws IOException {
        if (v < 0L || v > (long)this.buf.length) {
            throw new IOException();
        }
        this.pos = (int)v;
    }

    @Override
    public final boolean getBit(long bitIndex) {
        int byteIndexForBit = BytesUtil.byteIndexForBit(bitIndex);
        if (byteIndexForBit > this.buf.length) {
            this.ensureCapacity(byteIndexForBit);
        }
        return BytesUtil.getBit(this.buf, bitIndex);
    }

    @Override
    public final boolean setBit(long bitIndex, boolean value) {
        int byteIndexForBit = BytesUtil.byteIndexForBit(bitIndex);
        if (byteIndexForBit > this.buf.length) {
            this.ensureCapacity(byteIndexForBit);
        }
        return BytesUtil.setBit(this.buf, bitIndex, value);
    }

    public int skip(int nbytes) {
        if (this.pos + nbytes < 0) {
            throw new IllegalArgumentException();
        }
        if (this.pos + nbytes > this.capacity()) {
            this.ensureCapacity(this.pos + nbytes);
        }
        this.pos += nbytes;
        return this.pos;
    }

    @Override
    public AbstractFixedByteArrayBuffer slice(int off, int len) {
        return new SliceImpl(off, len);
    }

    public OutputBitStream getOutputBitStream() {
        return new OutputBitStream((OutputStream)this, 0, false);
    }

    private class SliceImpl
    extends AbstractFixedByteArrayBuffer {
        protected SliceImpl(int off, int len) {
            super(off, len);
        }

        public String toString() {
            return super.toString() + "{off=" + this.off() + ",len=" + this.len() + "}";
        }

        @Override
        public byte[] array() {
            return ByteArrayBuffer.this.array();
        }
    }
}

