/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    protected final ByteBuffer buf;

    public final ByteBuffer getByteBuffer() {
        return this.buf;
    }

    public ByteBufferOutputStream(ByteBuffer buf) {
        assert (buf != null);
        this.buf = buf;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buf.remaining() == 0) {
            throw new EOFException();
        }
        this.buf.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buf.remaining() < len) {
            throw new EOFException();
        }
        this.buf.put(b, off, len);
    }
}

