/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.io.ByteBufferInputStream;
import com.bigdata.io.IRecordSerializer;
import com.bigdata.io.IStreamSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;

public class SerializerUtil {
    public static final IStreamSerializer STREAMS = new IStreamSerializer(){
        private static final long serialVersionUID = -2625456835905636703L;

        public Object deserialize(ObjectInput in) {
            try {
                return in.readObject();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public void serialize(ObjectOutput out, Object obj) {
            try {
                out.writeObject(obj);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return STREAMS;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        }
    };
    public static final IRecordSerializer RECORDS = new IRecordSerializer(){
        private static final long serialVersionUID = -2625456835905636703L;

        public Object deserialize(byte[] data) {
            return SerializerUtil.deserialize(data);
        }

        public byte[] serialize(Object obj) {
            return SerializerUtil.serialize(obj);
        }

        private Object readResolve() throws ObjectStreamException {
            return RECORDS;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        }
    };

    public static final byte[] serialize(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            oos.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return baos.toByteArray();
    }

    public static final Object deserialize(byte[] b) {
        if (b == null) {
            return null;
        }
        return SerializerUtil.deserialize(b, 0, b.length);
    }

    public static final Object deserialize(byte[] b, int off, int len) {
        ByteArrayInputStream bais = new ByteArrayInputStream(b, off, len);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception ex) {
            throw new RuntimeException("off=" + off + ", len=" + len, ex);
        }
    }

    public static final Object deserialize(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            return ois.readObject();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final Object deserialize(ByteBuffer buf) {
        if (buf.hasArray()) {
            int off = buf.arrayOffset() + buf.position();
            int len = buf.remaining();
            Object ret = SerializerUtil.deserialize(buf.array(), off, len);
            buf.position(buf.limit());
            return ret;
        }
        ByteBufferInputStream bais = new ByteBufferInputStream(buf);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

