/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.IServicesManagerService;
import com.bigdata.jini.start.MonitorConfigZNodeTask;
import com.bigdata.jini.start.MonitorCreatePhysicalServiceLocksTask;
import com.bigdata.jini.start.ServicesManagerStartupTask;
import com.bigdata.jini.start.config.ServicesManagerConfiguration;
import com.bigdata.jini.start.process.JiniCoreServicesProcessHelper;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.jini.start.process.ZookeeperProcessHelper;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.AbstractService;
import com.bigdata.service.IServiceShutdown;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.jini.config.Configuration;
import org.apache.log4j.Logger;

public abstract class AbstractServicesManagerService
extends AbstractService
implements IServicesManagerService,
IServiceListener,
IServiceShutdown {
    private static final Logger log = Logger.getLogger(AbstractServicesManagerService.class);
    private final Properties properties;
    private final ConcurrentLinkedQueue<ProcessHelper> runningProcesses = new ConcurrentLinkedQueue();
    private volatile boolean open = true;
    private volatile boolean childStartsAllowed = true;
    protected volatile boolean startupRunning = false;
    protected MonitorCreatePhysicalServiceLocksTask monitorCreatePhysicalServiceLocksTask;

    public Properties getProperties() {
        return new Properties(this.properties);
    }

    @Override
    public void add(ProcessHelper service) {
        this.runningProcesses.add(service);
        if (!this.open || !this.childStartsAllowed) {
            log.warn((Object)("New processes may not start: " + service));
            try {
                log.warn((Object)("Killing: " + service));
                service.kill(true);
            }
            catch (InterruptedException e) {
                log.warn((Object)e);
            }
        }
    }

    @Override
    public void remove(ProcessHelper service) {
        this.runningProcesses.remove(service);
    }

    protected AbstractServicesManagerService(Properties properties) {
        this.properties = (Properties)properties.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AbstractServicesManagerService abstractServicesManagerService = this;
        synchronized (abstractServicesManagerService) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.childStartsAllowed = false;
        }
        ((JiniFederation)this.getFederation()).cancelMonitoredTasks(true);
        this.killChildProcesses(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow() {
        AbstractServicesManagerService abstractServicesManagerService = this;
        synchronized (abstractServicesManagerService) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.childStartsAllowed = false;
        }
        ((JiniFederation)this.getFederation()).cancelMonitoredTasks(true);
        this.killChildProcesses(true);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    protected void killChildProcesses(boolean immediateShutdown) {
        this.childStartsAllowed = false;
        for (ProcessHelper helper : this.runningProcesses) {
            if (helper instanceof JiniCoreServicesProcessHelper || helper instanceof ZookeeperProcessHelper) continue;
            try {
                helper.kill(immediateShutdown);
            }
            catch (Throwable t) {
                log.error((Object)("Process kill (ignored): " + helper));
                this.runningProcesses.remove(helper);
            }
        }
        for (ProcessHelper helper : this.runningProcesses) {
            try {
                helper.kill(immediateShutdown);
            }
            catch (Throwable t) {
                log.warn((Object)("Could not kill process: " + helper));
            }
        }
    }

    @Override
    public Class getServiceIface() {
        return IServicesManagerService.class;
    }

    @Override
    public abstract JiniFederation<?> getFederation();

    @Override
    public AbstractServicesManagerService start() {
        try {
            this.setup();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    protected void setup() throws Exception {
        AbstractFederation fed = this.getFederation();
        Configuration config = ((JiniClient)((JiniFederation)fed).getClient()).getConfiguration();
        ServicesManagerConfiguration selfConfig = new ServicesManagerConfiguration(config);
        if (!selfConfig.canStartService((JiniFederation)fed)) {
            throw new RuntimeException("Constraints do not permit start: " + selfConfig);
        }
        ((JiniFederation)fed).submitMonitoredTask(new MonitorConfigZNodeTask((JiniFederation)fed, this));
        this.monitorCreatePhysicalServiceLocksTask = new MonitorCreatePhysicalServiceLocksTask((JiniFederation)fed, this);
        ((JiniFederation)fed).submitMonitoredTask(this.monitorCreatePhysicalServiceLocksTask);
        new ServicesManagerStartupTask((JiniFederation)fed, config, true, true, this).call();
    }
}

