/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.lookup.entry.Hostname;
import com.bigdata.jini.lookup.entry.ServiceUUID;
import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.AbstractHostConstraint;
import com.bigdata.jini.start.config.IServiceConstraint;
import com.bigdata.jini.start.config.ManagedServiceConfiguration;
import com.bigdata.jini.util.JiniUtil;
import com.bigdata.service.IService;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.InnerCause;
import com.bigdata.zookeeper.UnknownChildrenWatcher;
import com.bigdata.zookeeper.ZLockImpl;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class MonitorCreatePhysicalServiceLocksTask
implements Callable<Void> {
    protected static final Logger log = Logger.getLogger(MonitorCreatePhysicalServiceLocksTask.class);
    private final JiniFederation fed;
    private final IServiceListener listener;
    protected final ReentrantLock lock = new ReentrantLock();

    public MonitorCreatePhysicalServiceLocksTask(JiniFederation fed, IServiceListener listener) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.listener = listener;
    }

    @Override
    public Void call() throws Exception {
        String locksZPath = this.fed.getZooConfig().zroot + "/" + "locks/createPhysicalService";
        while (true) {
            try {
                while (true) {
                    this.acquireWatcherAndRun(locksZPath);
                }
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Interrupted");
                    }
                    throw new RuntimeException(t);
                }
                log.error((Object)this, t);
                Thread.sleep(2000L);
                continue;
            }
            break;
        }
    }

    protected void acquireWatcherAndRun(String locksZPath) throws KeeperException, InterruptedException {
        ZooKeeper zookeeper = this.fed.getZookeeper();
        UnknownChildrenWatcher watcher = new UnknownChildrenWatcher(zookeeper, locksZPath);
        try {
            while (true) {
                try {
                    while (true) {
                        String znode;
                        if ((znode = watcher.queue.take()).endsWith("_INVALID")) {
                            continue;
                        }
                        String lockNodeZPath = locksZPath + "/" + znode;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("new lock: zpath=" + lockNodeZPath));
                        }
                        this.fed.submitMonitoredTask(new CreatePhysicalServiceTask(lockNodeZPath));
                    }
                }
                catch (InterruptedException ex) {
                    log.warn((Object)"Interrupted.");
                    throw ex;
                }
                catch (Throwable t) {
                    log.error((Object)this, t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            watcher.cancel();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean restartIfNotRunning(ManagedServiceConfiguration serviceConfig, String logicalServiceZPath, String physicalServiceZPath, Entry[] attributes) throws InterruptedException {
        block18: {
            LinkedList<IServiceConstraint> violatedConstraints;
            try {
                if (!this.isLocalService(attributes)) {
                    return false;
                }
            }
            catch (IOException ex) {
                log.warn((Object)("className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath), (Throwable)ex);
                return false;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Service is local: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
            }
            this.lock.lockInterruptibly();
            try {
                ZooKeeper zookeeper = this.fed.getZookeeper();
                if (!this.shouldRestartPhysicalService(zookeeper, serviceConfig, physicalServiceZPath, attributes)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Will not restart: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
                    }
                    boolean bl = false;
                    return bl;
                }
                violatedConstraints = new LinkedList<IServiceConstraint>();
                if (serviceConfig.canStartService(this.fed, violatedConstraints)) break block18;
            }
            catch (RemoteException ex) {
                log.error((Object)("RMI problem: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath), (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            catch (KeeperException ex) {
                log.error((Object)("Zookeeper problem: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath), (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            log.warn((Object)("Restart prevented by constraints: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath + ", violatedConstraints=" + violatedConstraints));
            return false;
        }
        log.warn((Object)("Will restart: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
        return this.restartPhysicalService(serviceConfig, logicalServiceZPath, physicalServiceZPath, attributes);
        finally {
            this.lock.unlock();
        }
    }

    private boolean shouldRestartPhysicalService(ZooKeeper zookeeper, ManagedServiceConfiguration serviceConfig, String physicalServiceZPath, Entry[] attributes) throws RemoteException, KeeperException, InterruptedException {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Considering: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
        }
        if (!this.isPersistentService(zookeeper, serviceConfig, physicalServiceZPath)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Service not persistent: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
            }
            return false;
        }
        if (this.isServiceRunning(serviceConfig, physicalServiceZPath, attributes)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Service running: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
            }
            return false;
        }
        log.warn((Object)("Service not discoverable and/or not running: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
        return true;
    }

    private boolean isServiceRunning(ManagedServiceConfiguration serviceConfig, String physicalServiceZPath, Entry[] attributes) throws RemoteException, InterruptedException {
        ServiceItem serviceItem;
        long timeout = 2000L;
        ServiceID serviceID = MonitorCreatePhysicalServiceLocksTask.getServiceID(attributes);
        if (serviceID == null) {
            throw new RuntimeException("No ServiceUUID? className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath + ", attributes=" + Arrays.toString(attributes));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Attempting service discovery: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath + ", ServiceID=" + serviceID));
        }
        if ((serviceItem = this.fed.getServiceDiscoveryManager().lookup(new ServiceTemplate(serviceID, null, null), null, 2000L)) == null) {
            log.warn((Object)("Service not discoverable, assumed not running: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath + ", ServiceID=" + serviceID));
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Service discovered: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath + ", ServiceItem=" + serviceItem));
        }
        if (serviceItem.service instanceof IService) {
            try {
                ((IService)serviceItem.service).getServiceIface();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Service responding: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath + ", ServiceItem=" + serviceItem));
                }
                return true;
            }
            catch (IOException ex) {
                log.warn((Object)("Service not responding: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath + ", serviceItem=" + serviceItem));
                return false;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Assuming service is alive: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath + ", ServiceItem=" + serviceItem));
        }
        return true;
    }

    protected static ServiceID getServiceID(Entry[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException();
        }
        UUID serviceUUID = null;
        for (Entry e : attributes) {
            if (!(e instanceof ServiceUUID) || serviceUUID != null) continue;
            serviceUUID = ((ServiceUUID)e).serviceUUID;
        }
        if (serviceUUID == null) {
            return null;
        }
        return JiniUtil.uuid2ServiceID(serviceUUID);
    }

    private boolean isPersistentService(ZooKeeper zookeeper, ManagedServiceConfiguration serviceConfig, String physicalServiceZPath) throws KeeperException, InterruptedException {
        Stat stat = zookeeper.exists(physicalServiceZPath, false);
        if (stat == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("znode gone: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
            }
            return false;
        }
        if (stat.getEphemeralOwner() != 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("znode ephemeral: className=" + serviceConfig.className + ", physicalServiceZPath=" + physicalServiceZPath));
            }
            return false;
        }
        return true;
    }

    protected boolean restartPhysicalService(ManagedServiceConfiguration serviceConfig, String logicalServiceZPath, String physicalServiceZPath, Entry[] attributes) throws InterruptedException, ExecutionException, TimeoutException, Exception {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("config=" + serviceConfig + ", zpath=" + logicalServiceZPath));
        }
        ManagedServiceConfiguration.ManagedServiceStarter task = serviceConfig.newServiceStarter(this.fed, this.listener, logicalServiceZPath, attributes);
        this.fed.getExecutorService().submit(task).get(serviceConfig.timeout, TimeUnit.MILLISECONDS);
        return true;
    }

    protected boolean isLocalService(Entry[] attributes) throws SocketException, UnknownHostException {
        boolean isLocalHost = false;
        for (Entry e : attributes) {
            String hostname;
            if (!(e instanceof Hostname) || !AbstractHostConstraint.isLocalHost(hostname = ((Hostname)e).hostname)) continue;
            isLocalHost = true;
        }
        return isLocalHost;
    }

    public class CreatePhysicalServiceTask
    implements Callable<Boolean> {
        protected final String lockNodeZPath;

        public CreatePhysicalServiceTask(String lockNodeZPath) {
            if (lockNodeZPath == null) {
                throw new IllegalArgumentException();
            }
            this.lockNodeZPath = lockNodeZPath;
        }

        @Override
        public Boolean call() throws Exception {
            while (true) {
                try {
                    if (this.runOnce()) {
                        return true;
                    }
                }
                catch (InterruptedException ex) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Interrupted - will not start service.");
                    }
                    return false;
                }
                catch (Throwable t) {
                    log.warn((Object)("lockNode=" + this.lockNodeZPath), t);
                }
                int sleep = (int)Math.rint(Math.random() * 5000.0);
                Thread.sleep(sleep);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Retrying: delay=" + sleep + "ms : " + this.lockNodeZPath));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean runOnce() throws Exception {
            ZooKeeper zookeeper = MonitorCreatePhysicalServiceLocksTask.this.fed.getZookeeper();
            if (zookeeper.exists(this.lockNodeZPath, false) == null) {
                throw new InterruptedException("lock node is gone: zpath=" + this.lockNodeZPath);
            }
            ZLockImpl zlock = ZLockImpl.getLock(zookeeper, this.lockNodeZPath, ((MonitorCreatePhysicalServiceLocksTask)MonitorCreatePhysicalServiceLocksTask.this).fed.getZooConfig().acl);
            zlock.lock();
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("have lock: zpath=" + this.lockNodeZPath));
                }
                if (this.runWithZLock(zookeeper)) {
                    zlock.destroyLock();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                zlock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean runWithZLock(ZooKeeper zookeeper) throws Exception {
            if (MonitorCreatePhysicalServiceLocksTask.this.lock.tryLock() || MonitorCreatePhysicalServiceLocksTask.this.lock.tryLock(2000L, TimeUnit.MILLISECONDS)) {
                try {
                    boolean bl = this.runWithLocalLock(zookeeper);
                    return bl;
                }
                finally {
                    MonitorCreatePhysicalServiceLocksTask.this.lock.unlock();
                }
            }
            return false;
        }

        private boolean runWithLocalLock(ZooKeeper zookeeper) throws Exception {
            return this.checkConstraintsAndStartService(zookeeper);
        }

        private boolean checkConstraintsAndStartService(ZooKeeper zookeeper) throws Exception {
            int ninstances;
            String logicalServiceZPath = (String)SerializerUtil.deserialize(zookeeper.getData(this.lockNodeZPath, false, new Stat()));
            String serviceConfigZPath = logicalServiceZPath.substring(0, logicalServiceZPath.lastIndexOf(47));
            if (log.isInfoEnabled()) {
                log.info((Object)("logicalServiceZPath=" + logicalServiceZPath));
            }
            ManagedServiceConfiguration config = (ManagedServiceConfiguration)SerializerUtil.deserialize(zookeeper.getData(serviceConfigZPath, false, new Stat()));
            if (log.isInfoEnabled()) {
                log.info((Object)("Considering: " + config));
            }
            if (!config.canStartService(MonitorCreatePhysicalServiceLocksTask.this.fed)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Constraint(s) do not allow service start: " + config));
                }
                return false;
            }
            List children = zookeeper.getChildren(logicalServiceZPath + "/" + "physicalServices", false);
            if (log.isInfoEnabled()) {
                log.info((Object)("serviceConfigZPath=" + serviceConfigZPath + ", logicalServiceZPath=" + logicalServiceZPath + ", targetReplicationCount=" + config.replicationCount + ", #children=" + children.size() + ", children=" + children));
            }
            if ((ninstances = children.size()) >= config.replicationCount) {
                throw new InterruptedException("No new instances required.");
            }
            this.startService(config, logicalServiceZPath);
            return true;
        }

        protected void startService(ManagedServiceConfiguration config, String logicalServiceZPath) throws Exception {
            if (log.isInfoEnabled()) {
                log.info((Object)("config=" + config + ", zpath=" + logicalServiceZPath));
            }
            ManagedServiceConfiguration.ManagedServiceStarter task = config.newServiceStarter(MonitorCreatePhysicalServiceLocksTask.this.fed, MonitorCreatePhysicalServiceLocksTask.this.listener, logicalServiceZPath, null);
            MonitorCreatePhysicalServiceLocksTask.this.fed.getExecutorService().submit(task).get(config.timeout, TimeUnit.MILLISECONDS);
        }
    }
}

