/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.start.MonitorCreatePhysicalServiceLocksTask;
import com.bigdata.jini.start.config.ManagedServiceConfiguration;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.InnerCause;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.jini.core.entry.Entry;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class RestartPersistentServices
implements Callable<Boolean> {
    protected static final Logger log = Logger.getLogger(RestartPersistentServices.class);
    static final transient String ERR_WILL_NOT_RESTART_SERVICES = "Will not restart services";
    protected final JiniFederation fed;
    final MonitorCreatePhysicalServiceLocksTask monitorCreatePhysicalServiceLocksTask;

    public RestartPersistentServices(JiniFederation fed, MonitorCreatePhysicalServiceLocksTask monitorCreatePhysicalServiceLocksTask) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (monitorCreatePhysicalServiceLocksTask == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.monitorCreatePhysicalServiceLocksTask = monitorCreatePhysicalServiceLocksTask;
    }

    @Override
    public Boolean call() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"Running.");
        }
        while (true) {
            try {
                return this.runOnce();
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Interrupted");
                    }
                    throw new RuntimeException(t);
                }
                log.error((Object)this, t);
                Thread.sleep(2000L);
                continue;
            }
            break;
        }
    }

    private boolean runOnce() throws KeeperException, InterruptedException {
        List serviceConfigZNodes;
        ZooKeeper zookeeper = this.fed.getZookeeper();
        if (!this.fed.awaitJiniRegistrars(Long.MAX_VALUE, TimeUnit.SECONDS)) {
            log.error((Object)"Will not restart services : not joined with any service registrars.");
            return false;
        }
        String zroot = this.fed.getZooConfig().zroot;
        String zconfig = zroot + "/" + "config";
        try {
            serviceConfigZNodes = zookeeper.getChildren(zconfig, false);
        }
        catch (KeeperException.NoNodeException ex) {
            log.error((Object)("Will not restart services : configuration znode not found: " + zconfig));
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Considering " + serviceConfigZNodes.size() + " service configurations"));
        }
        for (String serviceConfigZNode : serviceConfigZNodes) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Considering service configuration: " + serviceConfigZNode));
            }
            ManagedServiceConfiguration serviceConfig = (ManagedServiceConfiguration)SerializerUtil.deserialize(zookeeper.getData(zconfig + "/" + serviceConfigZNode, false, new Stat()));
            String serviceConfigZPath = zconfig + "/" + serviceConfigZNode;
            List logicalServiceZNodes = zookeeper.getChildren(serviceConfigZPath, false);
            if (log.isInfoEnabled()) {
                log.info((Object)("Considering " + logicalServiceZNodes.size() + " logical services configurations for " + serviceConfigZNode));
            }
            for (String logicalServiceZNode : logicalServiceZNodes) {
                String logicalServiceZPath = serviceConfigZPath + "/" + logicalServiceZNode;
                String physicalServicesContainerZPath = logicalServiceZPath + "/" + "physicalServices";
                List physicalServiceZNodes = zookeeper.getChildren(physicalServicesContainerZPath, false);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Considering " + physicalServiceZNodes.size() + " physical services configurations for " + logicalServiceZNode + " of " + serviceConfigZNode));
                }
                for (String physicalServiceZNode : physicalServiceZNodes) {
                    String physicalServiceZPath = physicalServicesContainerZPath + "/" + physicalServiceZNode;
                    Entry[] attributes = (Entry[])SerializerUtil.deserialize(zookeeper.getData(physicalServiceZPath, false, new Stat()));
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Considering: " + physicalServicesContainerZPath));
                    }
                    this.monitorCreatePhysicalServiceLocksTask.restartIfNotRunning(serviceConfig, logicalServiceZPath, physicalServiceZPath, attributes);
                }
            }
        }
        return true;
    }
}

