/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.ServiceConfigurationZNodeEnum;
import com.bigdata.jini.start.config.ManagedServiceConfiguration;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.InnerCause;
import com.bigdata.zookeeper.HierarchicalZNodeWatcher;
import com.bigdata.zookeeper.ZLock;
import com.bigdata.zookeeper.ZLockImpl;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ServiceConfigurationZNodeMonitorTask
implements Callable<Void> {
    private static final Logger log = Logger.getLogger(ServiceConfigurationZNodeMonitorTask.class);
    protected final JiniFederation<?> fed;
    protected final IServiceListener listener;
    protected final String className;
    final String zroot;
    final String lockZPath;
    final String serviceConfigZPath;

    public ServiceConfigurationZNodeMonitorTask(JiniFederation<?> fed, IServiceListener listener, String className) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (className == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.listener = listener;
        this.className = className;
        this.zroot = fed.getZooConfig().zroot;
        this.lockZPath = this.zroot + "/" + "locks/serviceConfigMonitor" + "/" + className;
        this.serviceConfigZPath = this.zroot + "/" + "config" + "/" + className;
    }

    @Override
    public Void call() throws Exception {
        while (true) {
            try {
                while (true) {
                    this.acquireLockAndRun();
                }
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Interrupted");
                    }
                    throw new RuntimeException(t);
                }
                log.error((Object)this, t);
                Thread.sleep(2000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireLockAndRun() throws Exception {
        ZooKeeper zookeeper = this.fed.getZookeeper();
        ZLockImpl zlock = ZLockImpl.getLock(zookeeper, this.lockZPath, this.fed.getZooConfig().acl);
        zlock.lock();
        try {
            this.runWithLock(zookeeper, zlock);
        }
        finally {
            zlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWithLock(ZooKeeper zookeeper, ZLock zlock) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting watcher: zlock=" + zlock + ", serviceConfigZPath=" + this.serviceConfigZPath));
        }
        ServiceConfigurationHierarchyWatcher watcher = new ServiceConfigurationHierarchyWatcher(zookeeper, this.serviceConfigZPath);
        String[] watchedSet = watcher.getWatchedNodes();
        ManagedServiceConfiguration config = (ManagedServiceConfiguration)SerializerUtil.deserialize(zookeeper.getData(this.serviceConfigZPath, false, new Stat()));
        this.balanceAll(zookeeper, config, watchedSet);
        try {
            while (true) {
                WatchedEvent e = (WatchedEvent)watcher.queue.take();
                if (!zlock.isLockHeld()) {
                    break;
                }
                this.handleEvent(zookeeper, watcher, e);
            }
        }
        finally {
            watcher.cancel();
        }
    }

    protected void balanceAll(ZooKeeper zookeeper, ManagedServiceConfiguration config, String[] watchedSet) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceConfigZPath=" + this.serviceConfigZPath + ", watchedSet=" + Arrays.toString(watchedSet)));
        }
        this.balanceLogicalServices(zookeeper, config);
        this.balancePhysicalServices(zookeeper, config, watchedSet);
    }

    protected void balanceLogicalServices(ZooKeeper zookeeper, ManagedServiceConfiguration config) throws Exception {
        List children = zookeeper.getChildren(this.serviceConfigZPath, false);
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceConfigZPath=" + this.serviceConfigZPath + ", targetServiceCount=" + config.serviceCount + ", #children=" + children.size() + ", children=" + children));
        }
        if (config.serviceCount != children.size()) {
            config.newLogicalServiceTask(this.fed, this.listener, this.serviceConfigZPath, children).call();
        }
    }

    protected void balancePhysicalServices(ZooKeeper zookeeper, ManagedServiceConfiguration config, String[] watchedSet) throws KeeperException, InterruptedException {
        block5: for (String s : watchedSet) {
            switch (ServiceConfigurationZNodeEnum.getType(this.serviceConfigZPath, s)) {
                case PhysicalServicesContainer: {
                    String logicalServiceZPath = s.substring(0, s.lastIndexOf(47));
                    String logicalServiceZNode = logicalServiceZPath.substring(logicalServiceZPath.lastIndexOf(47) + 1);
                    List children = zookeeper.getChildren(logicalServiceZPath + "/" + "physicalServices", false);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("serviceConfigZPath=" + this.serviceConfigZPath + ", logicalServiceZPath=" + logicalServiceZPath + ", targetReplicationCount=" + config.replicationCount + ", #children=" + children.size() + ", children=" + children));
                    }
                    if (config.replicationCount <= children.size()) continue block5;
                    try {
                        String lockNodeZPath = this.zroot + "/" + "locks/createPhysicalService" + "/" + config.className + "_" + logicalServiceZNode;
                        zookeeper.create(lockNodeZPath, SerializerUtil.serialize(logicalServiceZPath), this.fed.getZooConfig().acl, CreateMode.PERSISTENT);
                        if (!log.isInfoEnabled()) continue block5;
                        log.info((Object)("Created lock node: " + lockNodeZPath));
                        continue block5;
                    }
                    catch (KeeperException.NodeExistsException ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void handleEvent(ZooKeeper zookeeper, ServiceConfigurationHierarchyWatcher watcher, WatchedEvent e) throws Exception {
        switch (e.getState()) {
            case Disconnected: {
                return;
            }
        }
        String zpath = e.getPath();
        if (zpath == null) {
            throw new AssertionError((Object)("No zpath: event=" + e));
        }
        String[] watchedSet = watcher.getWatchedNodes();
        switch (ServiceConfigurationZNodeEnum.getType(this.serviceConfigZPath, zpath)) {
            case ServiceConfiguration: {
                ManagedServiceConfiguration config = (ManagedServiceConfiguration)SerializerUtil.deserialize(zookeeper.getData(this.serviceConfigZPath, false, new Stat()));
                this.balanceAll(zookeeper, config, watchedSet);
                break;
            }
            case LogicalService: {
                ManagedServiceConfiguration config = (ManagedServiceConfiguration)SerializerUtil.deserialize(zookeeper.getData(this.serviceConfigZPath, false, new Stat()));
                this.balanceLogicalServices(zookeeper, config);
                break;
            }
            case PhysicalServicesContainer: {
                ManagedServiceConfiguration config = (ManagedServiceConfiguration)SerializerUtil.deserialize(zookeeper.getData(this.serviceConfigZPath, false, new Stat()));
                this.balancePhysicalServices(zookeeper, config, watchedSet);
                break;
            }
        }
    }

    private class ServiceConfigurationHierarchyWatcher
    extends HierarchicalZNodeWatcher {
        public ServiceConfigurationHierarchyWatcher(ZooKeeper zookeeper, String zroot) throws InterruptedException, KeeperException {
            super(zookeeper, zroot, 7);
        }

        @Override
        protected int watch(String parent, String child) {
            String zpath = parent + "/" + child;
            switch (ServiceConfigurationZNodeEnum.getType(ServiceConfigurationZNodeMonitorTask.this.serviceConfigZPath, zpath)) {
                case ServiceConfiguration: {
                    return 7;
                }
                case LogicalService: {
                    return 5;
                }
                case PhysicalServicesContainer: {
                    return 5;
                }
                case PhysicalService: {
                    return 1;
                }
                case MasterElection: 
                case MasterElectionLock: {
                    return 0;
                }
                case Quorum: {
                    return 0;
                }
            }
            throw new AssertionError((Object)zpath);
        }
    }
}

