/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.Banner;
import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.JavaServiceConfiguration;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.jini.util.ConfigMath;
import java.util.LinkedList;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;

public class ServiceStarter {
    public static void main(String[] args) throws Exception {
        int i;
        boolean noExecute = false;
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-n".equals(arg)) {
                noExecute = true;
                continue;
            }
            if (arg.startsWith("-")) {
                System.err.println("Unknown option: " + arg);
                continue;
            }
            --i;
            break;
        }
        if (args.length - i < 2) {
            ServiceStarter.usage();
            System.exit(1);
        }
        String className = args[i++];
        LinkedList<String> passedOn = new LinkedList<String>();
        while (i < args.length) {
            passedOn.add(args[i]);
            ++i;
        }
        String[] args2 = passedOn.toArray(new String[0]);
        Configuration config = ConfigurationProvider.getInstance((String[])args2);
        JavaServiceConfiguration serviceConfig = new JavaServiceConfiguration(className, config);
        serviceConfig.options = ConfigMath.concat(serviceConfig.options, args2);
        JavaServiceConfiguration.JavaServiceStarter serviceStarter = serviceConfig.newServiceStarter(new ServiceListener());
        System.out.println(ProcessHelper.getCommandString(serviceStarter.newProcessBuilder()));
        if (!noExecute) {
            Banner.banner();
            serviceStarter.call();
        }
        System.exit(0);
    }

    protected static void usage() {
        System.err.println("usage: [-n] class configuration [override]*");
    }

    private static class ServiceListener
    implements IServiceListener {
        private ServiceListener() {
        }

        @Override
        public void add(ProcessHelper service) {
        }

        @Override
        public void remove(ProcessHelper service) {
        }
    }
}

