/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.start.AbstractServicesManagerService;
import com.bigdata.jini.start.MonitorCreatePhysicalServiceLocksTask;
import com.bigdata.jini.start.RestartPersistentServices;
import com.bigdata.jini.start.config.JiniCoreServicesConfiguration;
import com.bigdata.jini.start.config.ManagedServiceConfiguration;
import com.bigdata.jini.start.config.ServiceConfiguration;
import com.bigdata.jini.start.config.ServicesManagerConfiguration;
import com.bigdata.jini.start.config.ZookeeperServerConfiguration;
import com.bigdata.jini.start.process.JiniCoreServicesProcessHelper;
import com.bigdata.jini.start.process.ZookeeperProcessHelper;
import com.bigdata.service.jini.JiniFederation;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

public class ServicesManagerStartupTask
implements Callable<Void> {
    private static final Logger log = Logger.getLogger(ServicesManagerStartupTask.class);
    protected final JiniFederation fed;
    protected final Configuration config;
    protected final AbstractServicesManagerService service;
    protected final MonitorCreatePhysicalServiceLocksTask monitorCreatePhysicalServiceLocksTask;

    public ServicesManagerStartupTask(JiniFederation fed, Configuration config, boolean pushConfig, boolean restartServices, AbstractServicesManagerService service) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (config == null) {
            throw new IllegalArgumentException();
        }
        if (service == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.config = config;
        this.service = service;
        this.monitorCreatePhysicalServiceLocksTask = service.monitorCreatePhysicalServiceLocksTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            AbstractServicesManagerService abstractServicesManagerService = this.service;
            synchronized (abstractServicesManagerService) {
                block17: {
                    if (!this.service.startupRunning) break block17;
                    log.warn((Object)"Startup already running.");
                    Void void_ = null;
                    return void_;
                }
                this.service.startupRunning = true;
            }
            this.doStartup();
            abstractServicesManagerService = null;
            return abstractServicesManagerService;
        }
        finally {
            AbstractServicesManagerService abstractServicesManagerService = this.service;
            synchronized (abstractServicesManagerService) {
                this.service.startupRunning = false;
            }
        }
    }

    protected void doStartup() throws Exception {
        long nanos;
        ServiceConfiguration[] serviceConfigurations;
        if (log.isInfoEnabled()) {
            log.info((Object)"Running.");
        }
        ServicesManagerConfiguration selfConfig = new ServicesManagerConfiguration(this.config);
        for (ServiceConfiguration serviceConfig : serviceConfigurations = selfConfig.getServiceConfigurations(this.config)) {
            if (!(serviceConfig instanceof ZookeeperServerConfiguration)) continue;
            this.startZookeeperService(this.config);
        }
        for (ServiceConfiguration serviceConfig : serviceConfigurations) {
            if (!(serviceConfig instanceof JiniCoreServicesConfiguration)) continue;
            this.startJiniCoreServices(this.config);
        }
        long begin = System.nanoTime();
        long remaining = nanos = selfConfig.zookeeperDiscoveryTimeoutNanos;
        if (!this.fed.getZookeeperAccessor().awaitZookeeperConnected(remaining, TimeUnit.NANOSECONDS)) {
            throw new Exception("Zookeeper not connected: startup sequence aborted.");
        }
        remaining = nanos - (System.nanoTime() - begin);
        if (!this.fed.awaitJiniRegistrars(remaining, TimeUnit.NANOSECONDS)) {
            throw new Exception("No jini registrars: startup sequence aborted.");
        }
        this.pushConfiguration(serviceConfigurations);
        this.fed.submitMonitoredTask(new RestartPersistentServices(this.fed, this.monitorCreatePhysicalServiceLocksTask));
    }

    protected boolean startZookeeperService(Configuration config) throws ConfigurationException, IOException {
        try {
            return ZookeeperProcessHelper.startZookeeper(config, this.service) > 0;
        }
        catch (Throwable t) {
            log.error((Object)("Could not start zookeeper service: " + t), t);
            return false;
        }
    }

    protected boolean startJiniCoreServices(Configuration config) {
        try {
            return JiniCoreServicesProcessHelper.startCoreServices(config, this.service);
        }
        catch (Throwable t) {
            log.error((Object)("Could not start jini services: " + t), t);
            return false;
        }
    }

    protected boolean pushConfiguration(ServiceConfiguration[] serviceConfigurations) throws KeeperException, InterruptedException, ConfigurationException {
        ZooKeeper zookeeper;
        if (log.isInfoEnabled()) {
            log.info((Object)"Preparing zookeeper for configuration push.");
        }
        if ((zookeeper = this.fed.getZookeeper()) == null) {
            return false;
        }
        ZooKeeper.States state = zookeeper.getState();
        switch (state) {
            default: {
                log.error((Object)("Zookeeper: " + state + " : Will not push configuration."));
                return false;
            }
            case CONNECTED: 
        }
        String zroot = this.fed.getZooConfig().zroot;
        String zconfig = zroot + "/" + "config";
        this.fed.createKeyZNodes(zookeeper);
        this.pushConfiguration(zookeeper, zconfig, this.fed.getZooConfig().acl, serviceConfigurations);
        return true;
    }

    public void pushConfiguration(ZooKeeper zookeeper, String zconfig, List<ACL> acl, ServiceConfiguration[] serviceConfigurations) throws KeeperException, InterruptedException, ConfigurationException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Pushing configuration.");
        }
        for (ServiceConfiguration x : serviceConfigurations) {
            if (!(x instanceof ManagedServiceConfiguration)) continue;
            String zpath = zconfig + "/" + x.className;
            byte[] data = SerializerUtil.serialize(x);
            try {
                zookeeper.create(zpath, data, acl, CreateMode.PERSISTENT);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created: " + zpath + " : " + x));
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Created: " + zpath));
            }
            catch (KeeperException.NodeExistsException ex) {
                try {
                    zookeeper.setData(zpath, data, -1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Updated: " + zpath + " : " + x));
                        continue;
                    }
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Updated: " + zpath));
                }
                catch (KeeperException ex2) {
                    log.error((Object)("Could not update: zpath=" + zpath));
                }
            }
        }
    }
}

