/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.start.config.IServiceConstraint;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.config.NicUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public abstract class AbstractHostConstraint
implements IServiceConstraint {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(AbstractHostConstraint.class);
    protected final String[] hosts;

    public String toString() {
        return this.getClass() + "{hosts=" + Arrays.toString(this.hosts) + "}";
    }

    public AbstractHostConstraint(String host) {
        this(new String[]{host});
    }

    public AbstractHostConstraint(String[] hosts) {
        if (hosts == null) {
            throw new IllegalArgumentException();
        }
        if (hosts.length == 0) {
            throw new IllegalArgumentException();
        }
        for (String host : hosts) {
            if (host != null) continue;
            throw new IllegalArgumentException();
        }
        this.hosts = hosts;
    }

    protected boolean allow(boolean accept) {
        for (String hostname : this.hosts) {
            try {
                if (!AbstractHostConstraint.isLocalHost(hostname)) continue;
                return accept;
            }
            catch (IOException ex) {
                log.warn((Object)("hostname: " + hostname), (Throwable)ex);
            }
        }
        return !accept;
    }

    public static final boolean isLocalHost(String hostname) throws SocketException, UnknownHostException {
        Object[] localAddrs = NicUtil.getInetAddressMap().keySet().toArray(new InetAddress[1]);
        Object[] hostAddrs = InetAddress.getAllByName(hostname);
        if (log.isInfoEnabled()) {
            log.info((Object)("Considering: " + hostname + " : localAddrs=" + Arrays.toString(localAddrs) + ", hostAddrs=" + Arrays.toString(localAddrs) + ", hostAddrs=" + Arrays.toString(hostAddrs)));
        }
        for (InetAddress inetAddress : hostAddrs) {
            if (inetAddress.isLoopbackAddress()) {
                return true;
            }
            for (Object localAddr : localAddrs) {
                if (!inetAddress.equals(localAddr)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract boolean allow();

    @Override
    public boolean allow(JiniFederation ignored) {
        return this.allow();
    }
}

