/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.ServiceConfiguration;
import com.bigdata.jini.start.process.ProcessHelper;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public class JavaServiceConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 3688535928764283524L;
    public final File javaHome;
    public final String[] defaultJavaArgs;
    public final String log4j;
    public final String[] classpath;

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", javaHome=" + this.javaHome);
        sb.append(", defaultJavaArgs=" + Arrays.toString(this.defaultJavaArgs));
        sb.append(", log4j=" + this.log4j);
        sb.append(", classpath=" + Arrays.toString(this.classpath));
    }

    public JavaServiceConfiguration(String component, Configuration config) throws ConfigurationException {
        super(JavaServiceConfiguration.getClassName(component, config), config);
        this.javaHome = JavaServiceConfiguration.getJavaHome(component, config);
        this.defaultJavaArgs = JavaServiceConfiguration.getDefaultJavaArgs(component, config);
        this.log4j = JavaServiceConfiguration.getLog4j(component, config);
        this.classpath = JavaServiceConfiguration.getClasspath(component, config);
    }

    @Override
    public JavaServiceStarter newServiceStarter(IServiceListener listener) throws Exception {
        return new JavaServiceStarter(listener);
    }

    public static String getClassName(String component, Configuration config) throws ConfigurationException {
        return (String)config.getEntry(component, "className", String.class, (Object)component);
    }

    public static File getJavaHome(String component, Configuration config) throws ConfigurationException {
        File javaHome = (File)config.getEntry(component, "javaHome", File.class, null);
        if (javaHome == null) {
            javaHome = (File)config.getEntry(Options.NAMESPACE, "javaHome", File.class, (Object)new File(System.getProperty("java.home")));
        }
        return javaHome;
    }

    public static String getLog4j(String component, Configuration config) throws ConfigurationException {
        String log4j = (String)config.getEntry(component, "log4j", String.class, null);
        if (log4j == null) {
            log4j = (String)config.getEntry(Options.NAMESPACE, "log4j", String.class, null);
        }
        return log4j;
    }

    public static String[] getDefaultJavaArgs(String className, Configuration config) throws ConfigurationException {
        if (config.getEntry(className, "defaultJavaArgs", String[].class, null) != null) {
            throw new ConfigurationException("Only permitted in global scope: defaultJavaArgs");
        }
        return (String[])config.getEntry(Options.NAMESPACE, "defaultJavaArgs", String[].class, (Object)new String[0]);
    }

    public static String[] getClasspath(String className, Configuration config) throws ConfigurationException {
        return JavaServiceConfiguration.getStringArray("classpath", className, config, null);
    }

    public class JavaServiceStarter<V extends ProcessHelper>
    extends ServiceConfiguration.AbstractServiceStarter<V> {
        public final Class cls;

        protected JavaServiceStarter(IServiceListener listener) {
            super(JavaServiceConfiguration.this, listener);
            try {
                this.cls = Class.forName(JavaServiceConfiguration.this.className);
            }
            catch (Exception t) {
                throw new RuntimeException("className=" + JavaServiceConfiguration.this.className, t);
            }
        }

        @Override
        protected void setUpEnvironment(Map<String, String> env) {
            super.setUpEnvironment(env);
            if (JavaServiceConfiguration.this.classpath == null) {
                env.put("CLASSPATH", System.getProperty("java.class.path"));
            }
        }

        @Override
        protected void setUp() throws Exception {
            super.setUp();
        }

        @Override
        protected void addCommand(List<String> cmds) {
            cmds.add(new File(new File(JavaServiceConfiguration.this.javaHome, "bin"), "java").toString());
        }

        @Override
        protected void addCommandArgs(List<String> cmds) {
            for (String arg : JavaServiceConfiguration.this.defaultJavaArgs) {
                cmds.add(arg);
            }
            super.addCommandArgs(cmds);
            if (JavaServiceConfiguration.this.classpath != null) {
                cmds.add("-cp");
                StringBuilder sb = new StringBuilder();
                for (String e : JavaServiceConfiguration.this.classpath) {
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(e);
                }
                cmds.add(sb.toString());
            }
            if (JavaServiceConfiguration.this.log4j != null) {
                cmds.add("-Dlog4j.configuration=" + JavaServiceConfiguration.this.log4j);
            }
            cmds.add(JavaServiceConfiguration.this.className);
        }
    }

    public static interface Options
    extends ServiceConfiguration.Options {
        public static final String JAVA_HOME = "javaHome";
        public static final String DEFAULT_JAVA_ARGS = "defaultJavaArgs";
        public static final String CLASSPATH = "classpath";
        public static final String LOG4J = "log4j";
        public static final String CLASS_NAME = "className";
    }
}

