/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.AbstractHostConstraint;
import com.bigdata.jini.start.config.ServiceConfiguration;
import com.bigdata.jini.start.process.JiniCoreServicesProcessHelper;
import com.bigdata.service.jini.JiniClientConfig;
import com.sun.jini.start.ServiceStarter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscoveryManager;

public class JiniCoreServicesConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 4601254369003651017L;
    public final File configFile;

    public JiniCoreServicesConfiguration(Configuration config) throws ConfigurationException {
        super("jini", config);
        this.configFile = (File)config.getEntry("jini", "configFile", File.class, null);
    }

    @Override
    protected long getDefaultTimeout() {
        return 2000L;
    }

    @Override
    public JiniCoreServicesStarter newServiceStarter(IServiceListener listener) throws Exception {
        throw new UnsupportedOperationException();
    }

    public JiniCoreServicesStarter newServiceStarter(IServiceListener listener, JiniClientConfig clientConfig) throws Exception {
        return new JiniCoreServicesStarter(listener, clientConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceRegistrar[] getServiceRegistrars(int maxCount, String[] groups, LookupLocator[] locators, long timeout, TimeUnit unit) throws InterruptedException, IOException {
        final Object signal = new Object();
        LookupDiscoveryManager discovery = new LookupDiscoveryManager(groups, locators, new DiscoveryListener(){

            public void discarded(DiscoveryEvent e) {
                if (ServiceConfiguration.log.isDebugEnabled()) {
                    ServiceConfiguration.log.debug((Object)("discarded: " + e));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void discovered(DiscoveryEvent e) {
                if (ServiceConfiguration.log.isDebugEnabled()) {
                    ServiceConfiguration.log.debug((Object)("discovered: " + e));
                }
                Object object = signal;
                synchronized (object) {
                    signal.notifyAll();
                }
            }
        });
        try {
            long nanos;
            ServiceRegistrar[] registrars = new ServiceRegistrar[]{};
            long begin = System.nanoTime();
            long remaining = nanos = unit.toNanos(timeout);
            while (registrars.length < maxCount && (remaining = nanos - (System.nanoTime() - begin)) > 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("timeout=" + TimeUnit.NANOSECONDS.toMillis(timeout) + "ms, remaining: " + TimeUnit.NANOSECONDS.toMillis(remaining) + "ms, #registrars=" + registrars.length));
                }
                Object object = signal;
                synchronized (object) {
                    try {
                        signal.wait(TimeUnit.NANOSECONDS.toMillis(remaining));
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"woke up");
                    }
                }
                registrars = discovery.getRegistrars();
            }
            if (log.isInfoEnabled()) {
                long elapsed = System.nanoTime() - begin;
                log.info((Object)("Found " + registrars.length + " registrars in " + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms."));
            }
            ServiceRegistrar[] serviceRegistrarArray = registrars;
            return serviceRegistrarArray;
        }
        finally {
            discovery.terminate();
        }
    }

    public class JiniCoreServicesStarter<V extends JiniCoreServicesProcessHelper>
    extends ServiceConfiguration.AbstractServiceStarter<V> {
        final JiniClientConfig clientConfig;

        protected JiniCoreServicesStarter(IServiceListener listener, JiniClientConfig clientConfig) {
            super(JiniCoreServicesConfiguration.this, listener);
            if (clientConfig == null) {
                throw new IllegalArgumentException();
            }
            this.clientConfig = clientConfig;
        }

        @Override
        protected V newProcessHelper(String className, ProcessBuilder processBuilder, IServiceListener listener) throws IOException {
            if (JiniCoreServicesConfiguration.this.configFile == null) {
                throw new NullPointerException("no entry named 'configFile' in test configuration [under namespace 'jini' ]");
            }
            if (!JiniCoreServicesConfiguration.this.configFile.exists()) {
                throw new FileNotFoundException(JiniCoreServicesConfiguration.this.configFile.toString());
            }
            return (V)new JiniCoreServicesProcessHelper(className, processBuilder, listener);
        }

        @Override
        protected void addCommand(List<String> cmds) {
            String javaHome = System.getProperty("java.home");
            String javaPath = javaHome != null ? javaHome + File.separator + "bin" + File.separator + "java" : "java";
            cmds.add(javaPath);
        }

        @Override
        protected void addCommandArgs(List<String> cmds) {
            super.addCommandArgs(cmds);
            cmds.add(ServiceStarter.class.getName());
            if (JiniCoreServicesConfiguration.this.configFile == null) {
                throw new NullPointerException("no entry named 'configFile' in test configuration [under namespace 'jini' ]");
            }
            cmds.add(JiniCoreServicesConfiguration.this.configFile.toString());
        }

        @Override
        protected void awaitServiceStart(V processHelper, long timeout, TimeUnit unit) throws Exception, TimeoutException, InterruptedException {
            long begin = System.nanoTime();
            long nanos = unit.toNanos(timeout);
            LinkedList<LookupLocator> lst = new LinkedList<LookupLocator>();
            for (LookupLocator l : this.clientConfig.locators) {
                if (!AbstractHostConstraint.isLocalHost(l.getHost())) continue;
                lst.add(l);
                if (!ServiceConfiguration.log.isInfoEnabled()) continue;
                ServiceConfiguration.log.info((Object)("Will verify using locator: " + l));
            }
            Object[] locators = lst.toArray(new LookupLocator[0]);
            long remaining = nanos - (System.nanoTime() - begin);
            ServiceRegistrar[] registrars = JiniCoreServicesConfiguration.getServiceRegistrars(1, this.clientConfig.groups, (LookupLocator[])locators, remaining, TimeUnit.NANOSECONDS);
            long elapsed = System.nanoTime() - begin;
            if (ServiceConfiguration.log.isInfoEnabled()) {
                ServiceConfiguration.log.info((Object)("Registrars: #found=" + registrars.length + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed)));
            }
            if (registrars.length == 0) {
                throw new TimeoutException("Registrar not found: timeout=" + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms, locators=" + (locators == null ? null : Arrays.toString(locators)));
            }
        }
    }

    public static interface Options
    extends ServiceConfiguration.Options {
        public static final String NAMESPACE = "jini";
        public static final String CONFIG_FILE = "configFile";
    }
}

