/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.lookup.entry.Hostname;
import com.bigdata.jini.lookup.entry.HostnameFilter;
import com.bigdata.jini.lookup.entry.ServiceItemFilterChain;
import com.bigdata.jini.start.config.MaxServicesPerHostConstraint;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.lookup.DataServiceFilter;
import com.bigdata.util.config.NicUtil;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceItemFilter;

public class MaxDataServicesPerHostConstraint
extends MaxServicesPerHostConstraint {
    private static final long serialVersionUID = 4146058645608689955L;

    public MaxDataServicesPerHostConstraint(int maxServices) {
        super(maxServices);
    }

    @Override
    public boolean allow(JiniFederation fed) throws Exception {
        boolean allowed;
        String hostname;
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        LookupCache lookupCache = fed.getDataServicesClient().getLookupCache();
        ServiceItemFilterChain filter = new ServiceItemFilterChain();
        filter.add(DataServiceFilter.INSTANCE);
        String canonicalHostname = hostname = NicUtil.getIpAddress("default.nic", "default", false);
        filter.add(new HostnameFilter(new Hostname[]{new Hostname(hostname), new Hostname(canonicalHostname)}));
        ServiceItem[] serviceItems = lookupCache.lookup((ServiceItemFilter)filter, this.maxServices);
        boolean bl = allowed = serviceItems.length < this.maxServices;
        if (log.isInfoEnabled()) {
            log.info((Object)("New instance: allowed=" + allowed + ", maxServices=" + this.maxServices + ", #found=" + serviceItems.length + ", host=" + canonicalHostname));
        }
        return allowed;
    }
}

