/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.start.ServicesManagerServer;
import com.bigdata.jini.start.config.BigdataServiceConfiguration;
import com.bigdata.jini.start.config.ClientServerConfiguration;
import com.bigdata.jini.start.config.DataServerConfiguration;
import com.bigdata.jini.start.config.JavaServiceConfiguration;
import com.bigdata.jini.start.config.JiniCoreServicesConfiguration;
import com.bigdata.jini.start.config.LoadBalancerConfiguration;
import com.bigdata.jini.start.config.MetadataServerConfiguration;
import com.bigdata.jini.start.config.ServiceConfiguration;
import com.bigdata.jini.start.config.TransactionServerConfiguration;
import com.bigdata.jini.start.config.ZookeeperServerConfiguration;
import com.bigdata.service.jini.ClientServer;
import com.bigdata.service.jini.DataServer;
import com.bigdata.service.jini.LoadBalancerServer;
import com.bigdata.service.jini.MetadataServer;
import com.bigdata.service.jini.TransactionServer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

public class ServicesManagerConfiguration
extends BigdataServiceConfiguration {
    private static final long serialVersionUID = 5087489087279869212L;
    public final String[] services;
    public final long zookeeperDiscoveryTimeoutNanos;

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(", services=" + Arrays.toString(this.services));
        sb.append(", zookeeperDiscoveryTimeout=" + this.zookeeperDiscoveryTimeoutNanos);
    }

    public ServicesManagerConfiguration(Configuration config) throws ConfigurationException {
        super(ServicesManagerServer.class, config);
        this.services = (String[])config.getEntry(ServicesManagerServer.class.getName(), "services", String[].class);
        this.zookeeperDiscoveryTimeoutNanos = (Long)config.getEntry(ServicesManagerServer.class.getName(), "zookeeperDiscoveryTimeout", Long.TYPE, (Object)Options.DEFAULT_ZOOKEEPER_DISCOVERY_TIMEOUT_NANOS);
    }

    public ServiceConfiguration[] getServiceConfigurations(Configuration config) throws ConfigurationException {
        LinkedList<ServiceConfiguration> v = new LinkedList<ServiceConfiguration>();
        for (String a : this.services) {
            if (a == null) {
                throw new ConfigurationException("services: Contains null elements.");
            }
            if (a.equals("jini")) {
                v.add(new JiniCoreServicesConfiguration(config));
                continue;
            }
            if (a.equals(QuorumPeerMain.class.getName())) {
                v.add(new ZookeeperServerConfiguration(config));
                continue;
            }
            if (a.equals(TransactionServer.class.getName())) {
                v.add(new TransactionServerConfiguration(config));
                continue;
            }
            if (a.equals(MetadataServer.class.getName())) {
                v.add(new MetadataServerConfiguration(config));
                continue;
            }
            if (a.equals(DataServer.class.getName())) {
                v.add(new DataServerConfiguration(config));
                continue;
            }
            if (a.equals(LoadBalancerServer.class.getName())) {
                v.add(new LoadBalancerConfiguration(config));
                continue;
            }
            if (a.equals(ClientServer.class.getName())) {
                v.add(new ClientServerConfiguration(config));
                continue;
            }
            v.add(new JavaServiceConfiguration(a, config));
        }
        return v.toArray(new ServiceConfiguration[0]);
    }

    public static interface Options
    extends BigdataServiceConfiguration.Options {
        public static final String SERVICES = "services";
        public static final String ZOOKEEPER_DISCOVERY_TIMEOUT_NANOS = "zookeeperDiscoveryTimeout";
        public static final long DEFAULT_ZOOKEEPER_DISCOVERY_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(3L);
    }
}

