/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.process;

import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.HostAllowConstraint;
import com.bigdata.jini.start.config.JiniCoreServicesConfiguration;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.service.jini.JiniClientConfig;
import com.bigdata.util.config.NicUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.jini.config.Configuration;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;

public class JiniCoreServicesProcessHelper
extends ProcessHelper {
    public JiniCoreServicesProcessHelper(String name, ProcessBuilder builder, IServiceListener listener) throws IOException {
        super(name, builder, listener);
    }

    public static boolean startCoreServices(Configuration config, IServiceListener listener) throws Exception {
        JiniCoreServicesConfiguration serviceConfig = new JiniCoreServicesConfiguration(config);
        if (!serviceConfig.canStartService(null)) {
            throw new RuntimeException("Constraints do not permit start: " + serviceConfig);
        }
        JiniClientConfig clientConfig = new JiniClientConfig(null, config);
        LookupLocator[] locators = clientConfig.locators;
        if (locators.length > 0) {
            String[] allowed = new String[locators.length];
            int i = 0;
            for (LookupLocator locator : locators) {
                allowed[i++] = locator.getHost();
            }
            if (!new HostAllowConstraint(allowed).allow()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Host not selected by locator(s).");
                }
                return false;
            }
        }
        if (!serviceConfig.canStartService(null)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Constraint(s) do not allow service start: " + config));
            }
            return false;
        }
        ServiceRegistrar[] registrars = JiniCoreServicesConfiguration.getServiceRegistrars(Integer.MAX_VALUE, clientConfig.groups, clientConfig.locators, 1500L, TimeUnit.MILLISECONDS);
        if (log.isInfoEnabled()) {
            log.info((Object)("registrars: #found=" + registrars.length + ", #desired=" + serviceConfig.serviceCount));
        }
        if (registrars.length >= serviceConfig.serviceCount) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Enough instances - will not start another.");
            }
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will start instance: " + NicUtil.getIpAddress("default.nic", "default", false) + ", config=" + config));
        }
        JiniCoreServicesConfiguration.JiniCoreServicesStarter serviceStarter = serviceConfig.newServiceStarter(listener, clientConfig);
        JiniCoreServicesProcessHelper processHelper = (JiniCoreServicesProcessHelper)serviceStarter.call();
        return true;
    }
}

