/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.process;

import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.ZookeeperServerConfiguration;
import com.bigdata.jini.start.config.ZookeeperServerEntry;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.util.config.NicUtil;
import com.bigdata.zookeeper.ZooHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public class ZookeeperProcessHelper
extends ProcessHelper {
    protected final int clientPort;
    protected static InetAddress thisInetAddr = null;

    public ZookeeperProcessHelper(String name, ProcessBuilder builder, IServiceListener listener, int clientPort) throws IOException {
        super(name, builder, listener);
        this.clientPort = clientPort;
    }

    @Override
    public int kill(boolean immediateShutdown) throws InterruptedException {
        try {
            ZooHelper.kill(this.clientPort);
        }
        catch (IOException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return super.kill(immediateShutdown);
        }
        try {
            int exitValue = this.exitValue(5L, TimeUnit.SECONDS);
            this.listener.remove(this);
            return exitValue;
        }
        catch (TimeoutException e) {
            log.error((Object)this, (Throwable)e);
            return super.kill(immediateShutdown);
        }
    }

    public static int startZookeeper(Configuration config, IServiceListener listener) throws ConfigurationException, IOException {
        ZookeeperServerConfiguration serverConfig = new ZookeeperServerConfiguration(config);
        if (ZooHelper.isRunning(thisInetAddr, serverConfig.clientPort)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Zookeeper already running: " + thisInetAddr.getCanonicalHostName() + ":" + serverConfig.clientPort));
            }
            return 0;
        }
        if (!serverConfig.canStartService(null)) {
            throw new RuntimeException("Constraints do not permit start: " + serverConfig);
        }
        ZookeeperServerEntry[] entries = serverConfig.getZookeeperServerEntries();
        int nstart = 0;
        for (ZookeeperServerEntry entry : entries) {
            if (!entry.isLocalHost()) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Zookeeper instance is local: " + entry));
            }
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will try to start: " + entry));
                }
                serverConfig.newServiceStarter(listener, entry).call();
                ++nstart;
            }
            catch (ZookeeperServerConfiguration.ZookeeperRunningException ex) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Already running: " + entry));
            }
            catch (Exception ex) {
                log.error((Object)("Could not start: entry=" + entry), (Throwable)ex);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("started=" + nstart + " instances"));
        }
        return nstart;
    }

    static {
        try {
            thisInetAddr = InetAddress.getByName(NicUtil.getIpAddress("default.nic", "default", false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

