/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BaseIndexStats;
import com.bigdata.btree.DumpIndex;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.NodeSerializer;
import com.bigdata.btree.data.IAbstractNodeData;
import com.bigdata.htree.AbstractHTree;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.CommitRecordIndex;
import com.bigdata.journal.FileMetadata;
import com.bigdata.journal.IBufferStrategy;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.journal.RWStrategy;
import com.bigdata.journal.RootBlockView;
import com.bigdata.relation.RelationSchema;
import com.bigdata.rwstore.IRWStrategy;
import com.bigdata.rwstore.IStore;
import com.bigdata.rwstore.RWStore;
import com.bigdata.sparse.GlobalRowStoreSchema;
import com.bigdata.sparse.ITPS;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.stream.Stream;
import com.bigdata.util.ChecksumUtility;
import com.bigdata.util.InnerCause;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DumpJournal {
    private static final Logger log = Logger.getLogger(DumpJournal.class);
    private static final boolean dumpGRS = false;
    private static final boolean validateDeleteBlocks = false;
    private final Journal journal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String arg;
        int i;
        if (args.length == 0) {
            System.err.println("usage: (-history|-indices|-pages|-tuples) <filename>+");
            System.exit(1);
        }
        LinkedList<String> namespaces = new LinkedList<String>();
        boolean dumpHistory = false;
        boolean dumpIndices = false;
        boolean dumpPages = false;
        boolean showTuples = false;
        boolean alternateRootBlock = false;
        LinkedList<Long> addrs = new LinkedList<Long>();
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("-history")) {
                dumpHistory = true;
                continue;
            }
            if (arg.equals("-namespace")) {
                namespaces.add(args[i + 1]);
                continue;
            }
            if (arg.equals("-indices")) {
                dumpIndices = true;
                continue;
            }
            if (arg.equals("-pages")) {
                dumpPages = true;
                continue;
            }
            if (arg.equals("-tuples")) {
                showTuples = true;
                continue;
            }
            if (arg.equals("-alternateRootBlock")) {
                alternateRootBlock = true;
                continue;
            }
            if (arg.equals("-addr")) {
                addrs.add(Long.valueOf(args[i + 1]));
                ++i;
                continue;
            }
            throw new RuntimeException("Unknown argument: " + arg);
        }
        while (i < args.length) {
            File file = new File(args[i]);
            try {
                System.out.println("File: " + file);
                if (!file.exists()) {
                    System.err.println("No such file");
                    System.exit(1);
                }
                if (!file.isFile()) {
                    System.err.println("Not a regular file");
                    System.exit(1);
                }
                System.out.println("Length: " + file.length());
                System.out.println("Last Modified: " + new Date(file.lastModified()));
                Properties properties = new Properties();
                properties.setProperty(Options.FILE, file.toString());
                properties.setProperty(Options.READ_ONLY, "true");
                if (alternateRootBlock) {
                    properties.setProperty(Options.ALTERNATE_ROOT_BLOCK, "true");
                }
                properties.setProperty(Options.BUFFER_MODE, BufferMode.Disk.toString());
                System.out.println("Opening (read-only): " + file);
                try (Journal journal = new Journal(properties);){
                    DumpJournal dumpJournal = new DumpJournal(journal);
                    try (PrintWriter out = new PrintWriter(System.out, true);){
                        dumpJournal.dumpJournal(out, namespaces, dumpHistory, dumpPages, dumpIndices, showTuples);
                        for (Long addr : addrs) {
                            out.println("addr=" + addr + ", offset=" + journal.getOffset(addr) + ", length=" + journal.getByteCount(addr));
                            out.println(dumpJournal.dumpRawRecord(addr));
                        }
                        out.flush();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.err.println("Error: " + t + " on file: " + file);
                System.exit(1);
            }
            System.out.println("==================================");
            ++i;
        }
        System.out.println("Normal completion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpJournal(boolean dumpHistory, boolean dumpPages, boolean dumpIndices, boolean showTuples) {
        PrintWriter w = new PrintWriter(System.out, true);
        this.dumpJournal(w, null, dumpHistory, dumpPages, dumpIndices, showTuples);
        w.flush();
    }

    public void dumpJournal(PrintWriter out, List<String> namespaces, boolean dumpHistory, boolean dumpPages, boolean dumpIndices, boolean showTuples) {
        ByteBuffer rootBlock1;
        ByteBuffer rootBlock0;
        FileMetadata fmd = this.journal.getFileMetadata();
        if (fmd != null) {
            out.println("magic=" + Integer.toHexString(fmd.magic));
            out.println("version=" + Integer.toHexString(fmd.version));
            long bytesAvailable = fmd.userExtent - fmd.nextOffset;
            out.println("extent=" + fmd.extent + "(" + fmd.extent / 0x100000L + "M)" + ", userExtent=" + fmd.userExtent + "(" + fmd.userExtent / 0x100000L + "M)" + ", bytesAvailable=" + bytesAvailable + "(" + bytesAvailable / 0x100000L + "M)" + ", nextOffset=" + fmd.nextOffset);
        }
        if ((rootBlock0 = this.journal.getBufferStrategy().readRootBlock(true)) != null) {
            out.println(new RootBlockView(true, rootBlock0, new ChecksumUtility()).toString());
        }
        if ((rootBlock1 = this.journal.getBufferStrategy().readRootBlock(false)) != null) {
            out.println(new RootBlockView(false, rootBlock1, new ChecksumUtility()).toString());
        }
        out.println("The current root block is #" + (this.journal.getRootBlockView().isRootBlock0() ? 0 : 1));
        IBufferStrategy strategy = this.journal.getBufferStrategy();
        if (strategy instanceof RWStrategy) {
            RWStore store = ((RWStrategy)strategy).getStore();
            StringBuilder sb = new StringBuilder();
            store.showAllocators(sb);
            out.println(sb);
        }
        CommitRecordIndex commitRecordIndex = this.journal.getReadOnlyCommitRecordIndex();
        out.println("There are " + commitRecordIndex.getEntryCount() + " commit points.");
        if (dumpHistory) {
            out.println("Historical commit points follow in temporal sequence (first to last):");
            ITupleIterator itr = commitRecordIndex.rangeIterator();
            while (itr.hasNext()) {
                out.println("----");
                CommitRecordIndex.Entry entry = (CommitRecordIndex.Entry)itr.next().getObject();
                out.print("Commit Record: " + entry.commitTime + ", addr=" + this.journal.toString(entry.addr) + ", ");
                ICommitRecord commitRecord = this.journal.getCommitRecord(entry.commitTime);
                out.println(commitRecord.toString());
                this.dumpNamedIndicesMetadata(out, namespaces, commitRecord, dumpPages, dumpIndices, showTuples);
            }
        } else {
            ICommitRecord commitRecord = this.journal.getCommitRecord();
            out.println(commitRecord.toString());
            this.dumpNamedIndicesMetadata(out, namespaces, commitRecord, dumpPages, dumpIndices, showTuples);
        }
    }

    public DumpJournal(Journal journal) {
        if (journal == null) {
            throw new IllegalArgumentException();
        }
        this.journal = journal;
    }

    private void dumpGlobalRowStore(PrintWriter out) {
        ITPS tps;
        SparseRowStore grs = this.journal.getGlobalRowStore(this.journal.getLastCommitTime());
        Iterator<? extends ITPS> itr = grs.rangeIterator(GlobalRowStoreSchema.INSTANCE);
        while (itr.hasNext()) {
            tps = itr.next();
            out.println(tps.toString());
        }
        itr = grs.rangeIterator(RelationSchema.INSTANCE);
        while (itr.hasNext()) {
            tps = itr.next();
            out.println(tps.toString());
        }
    }

    private void dumpNamedIndicesMetadata(PrintWriter out, List<String> namespaces, ICommitRecord commitRecord, boolean dumpPages, boolean dumpIndices, boolean showTuples) {
        Iterator<String> nitr = this.journal.indexNameScan(null, commitRecord.getTimestamp());
        TreeMap<String, BaseIndexStats> pageStats = new TreeMap<String, BaseIndexStats>();
        while (nitr.hasNext()) {
            ICheckpointProtocol ndx;
            String name = nitr.next();
            if (namespaces != null && !namespaces.isEmpty()) {
                boolean found = false;
                for (String namespace : namespaces) {
                    if (!name.startsWith(namespace)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            out.println("name=" + name);
            try {
                ndx = this.journal.getIndexWithCommitRecord(name, commitRecord);
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, ClassNotFoundException.class)) {
                    log.warn((Object)("Could not load index: " + InnerCause.getInnerCause(t, ClassNotFoundException.class)));
                    continue;
                }
                throw new RuntimeException(t);
            }
            out.println("\t" + ndx.getCheckpoint());
            out.println("\t" + ndx.getIndexMetadata());
            BaseIndexStats stats = ndx.dumpPages(dumpPages);
            out.println("\t" + stats);
            pageStats.put(name, stats);
            if (!dumpIndices || !(ndx instanceof AbstractBTree)) continue;
            DumpIndex.dumpIndex((AbstractBTree)ndx, showTuples);
        }
        boolean first = true;
        for (Map.Entry e : pageStats.entrySet()) {
            String name = (String)e.getKey();
            BaseIndexStats stats = (BaseIndexStats)e.getValue();
            if (stats == null) {
                ICheckpointProtocol tmp = this.journal.getIndexWithCommitRecord(name, commitRecord);
                out.println("name: " + name + ", class=" + tmp.getClass() + ", checkpoint=" + tmp.getCheckpoint());
                continue;
            }
            if (first) {
                out.println(stats.getHeaderRow());
                first = false;
            }
            out.println(stats.getDataRow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpRawRecord(long addr) {
        ByteBuffer buf;
        if (this.journal.getBufferStrategy() instanceof IRWStrategy) {
            IStore store = ((IRWStrategy)this.journal.getBufferStrategy()).getStore();
            try {
                InputStream is = store.getInputStream(addr);
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return "Address is stream: addr=" + addr;
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        try {
            buf = this.journal.read(addr);
        }
        catch (Throwable t) {
            String msg = "Could not read: addr=" + addr + ", ex=" + t;
            log.error((Object)msg, t);
            return msg;
        }
        if (buf == null) {
            throw new IllegalArgumentException("Nothing at that address");
        }
        Object obj = this.decodeData(buf);
        if (obj == null) {
            return "Could not decode: addr=" + addr;
        }
        return obj.toString();
    }

    private Object decodeData(ByteBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        try {
            return SerializerUtil.deserialize(buf.duplicate());
        }
        catch (RuntimeException ex) {
            long commitTime = this.journal.getLastCommitTime();
            Iterator<String> nitr = this.journal.indexNameScan(null, commitTime);
            block11: while (nitr.hasNext()) {
                String name = nitr.next();
                ICheckpointProtocol ndx = this.journal.getIndexLocal(name, commitTime);
                IndexTypeEnum indexType = ndx.getCheckpoint().getIndexType();
                switch (indexType) {
                    case BTree: {
                        IAbstractNodeData nodeOrLeaf;
                        AbstractBTree btree = (AbstractBTree)ndx;
                        Object nodeSer = btree.getNodeSerializer();
                        try {
                            nodeOrLeaf = ((NodeSerializer)nodeSer).decode(buf.duplicate());
                            log.warn((Object)("Record decoded from index=" + name));
                            return nodeOrLeaf;
                        }
                        catch (Throwable t) {
                            continue block11;
                        }
                    }
                    case HTree: {
                        IAbstractNodeData nodeOrLeaf;
                        AbstractHTree htree = (AbstractHTree)ndx;
                        Object nodeSer = htree.getNodeSerializer();
                        try {
                            nodeOrLeaf = ((com.bigdata.htree.NodeSerializer)nodeSer).decode(buf.duplicate());
                            log.warn((Object)("Record decoded from index=" + name));
                            return nodeOrLeaf;
                        }
                        catch (Throwable t) {
                            continue block11;
                        }
                    }
                    case Stream: {
                        Stream stream = (Stream)ndx;
                        continue block11;
                    }
                }
                throw new UnsupportedOperationException("Unknown indexType=" + (Object)((Object)indexType));
            }
            return null;
        }
    }
}

