/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.bfs.GlobalFileSystemHelper;
import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.journal.Name2Addr;
import com.bigdata.journal.ResourceLockService;
import com.bigdata.journal.TemporaryRawStore;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.sparse.GlobalRowStoreHelper;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class TemporaryStore
extends TemporaryRawStore
implements IBTreeManager {
    private static final Logger log = Logger.getLogger(TemporaryStore.class);
    private final int liveIndexCacheCapacity = 20;
    private final long liveIndexCacheTimeout = Long.parseLong("60000");
    private final Name2Addr name2Addr;
    private final GlobalRowStoreHelper globalRowStoreHelper = new GlobalRowStoreHelper(this);
    private final GlobalFileSystemHelper globalFileSystemHelper = new GlobalFileSystemHelper(this);
    private final DefaultResourceLocator<?> resourceLocator;
    private final ExecutorService executorService;
    private final ResourceLockService resourceLockManager = new ResourceLockService();

    public TemporaryStore() {
        this(42);
    }

    public TemporaryStore(int offsetBits) {
        this(offsetBits, TemporaryStore.getTempFile());
    }

    public TemporaryStore(int offsetBits, File file) {
        super(0L, offsetBits, file);
        this.name2Addr = Name2Addr.create(this);
        this.name2Addr.setupCache(20, this.liveIndexCacheTimeout);
        this.executorService = Executors.newCachedThreadPool(new DaemonThreadFactory(this.getClass().getName() + ".executorService"));
        this.resourceLocator = new DefaultResourceLocator(this, null);
    }

    @Override
    public void registerIndex(IndexMetadata metadata) {
        this.registerIndex(metadata.getName(), metadata);
    }

    @Override
    public BTree registerIndex(String name, IndexMetadata metadata) {
        return (BTree)this.register(name, metadata);
    }

    @Override
    public ICheckpointProtocol register(String name, IndexMetadata metadata) {
        ICheckpointProtocol ndx = Checkpoint.create(this, metadata);
        this.register(name, ndx);
        return ndx;
    }

    @Override
    public final BTree registerIndex(String name, BTree btree) {
        this.registerIndex(name, btree);
        return btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void register(String name, ICheckpointProtocol ndx) {
        Name2Addr name2Addr = this.name2Addr;
        synchronized (name2Addr) {
            this.assertOpen();
            this.name2Addr.registerIndex(name, ndx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropIndex(String name) {
        Name2Addr name2Addr = this.name2Addr;
        synchronized (name2Addr) {
            this.assertOpen();
            this.name2Addr.dropIndex(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> indexNameScan(String prefix, long timestampIsIgnored) {
        LinkedList<String> names = new LinkedList<String>();
        Name2Addr name2Addr = this.name2Addr;
        synchronized (name2Addr) {
            Iterator<String> itr = Name2Addr.indexNameScan(prefix, this.name2Addr);
            while (itr.hasNext()) {
                names.add(itr.next());
            }
        }
        return names.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICheckpointProtocol getUnisolatedIndex(String name) {
        Name2Addr name2Addr = this.name2Addr;
        synchronized (name2Addr) {
            this.assertOpen();
            return this.name2Addr.getIndex(name);
        }
    }

    @Override
    public BTree getIndex(String name) {
        return (BTree)this.getUnisolatedIndex(name);
    }

    @Override
    public BTree getIndex(String name, long timestamp) {
        return (BTree)this.getIndexLocal(name, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICheckpointProtocol getIndexLocal(String name, long commitTime) {
        this.assertOpen();
        if (commitTime == -1L) {
            long checkpointAddr;
            Name2Addr name2Addr = this.name2Addr;
            synchronized (name2Addr) {
                Name2Addr.Entry entry = this.name2Addr.getEntry(name);
                if (entry == null) {
                    log.warn((Object)("No such index: name=" + name + ", timestamp=" + TimestampUtility.toString(commitTime)));
                    return null;
                }
                checkpointAddr = entry.checkpointAddr;
            }
            ICheckpointProtocol ndx = Checkpoint.loadFromCheckpoint(this, checkpointAddr, true);
            return ndx;
        }
        if (commitTime == 0L) {
            return this.getUnisolatedIndex(name);
        }
        return this.getUnisolatedIndex(name);
    }

    @Override
    public SparseRowStore getGlobalRowStore() {
        this.assertOpen();
        return this.globalRowStoreHelper.getGlobalRowStore();
    }

    @Override
    public SparseRowStore getGlobalRowStore(long timestamp) {
        return this.globalRowStoreHelper.get(timestamp);
    }

    @Override
    public BigdataFileSystem getGlobalFileSystem() {
        this.assertOpen();
        return this.globalFileSystemHelper.getGlobalFileSystem();
    }

    @Override
    public DefaultResourceLocator<?> getResourceLocator() {
        this.assertOpen();
        return this.resourceLocator;
    }

    @Override
    public ExecutorService getExecutorService() {
        this.assertOpen();
        return this.executorService;
    }

    @Override
    public final IResourceLockService getResourceLockService() {
        return this.resourceLockManager;
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
        super.close();
    }

    @Override
    public long getLastCommitTime() {
        return 0L;
    }

    @Override
    public boolean isGroupCommit() {
        return false;
    }

    @Override
    public TemporaryStore getTempStore() {
        return this;
    }

    @Override
    public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return null;
    }

    @Override
    public boolean getCollectPlatformStatistics() {
        return false;
    }

    @Override
    public boolean getCollectQueueStatistics() {
        return false;
    }

    @Override
    public int getHttpdPort() {
        return -1;
    }
}

