/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.striped.StripedCounters;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumPipeline;
import com.bigdata.ha.QuorumRead;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.msg.HARebuildRequest;
import com.bigdata.ha.msg.HAWriteMessage;
import com.bigdata.ha.msg.IHALogRequest;
import com.bigdata.ha.msg.IHARebuildRequest;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.writecache.IBackingReader;
import com.bigdata.io.writecache.WriteCache;
import com.bigdata.io.writecache.WriteCacheCounters;
import com.bigdata.io.writecache.WriteCacheService;
import com.bigdata.journal.AbstractBufferStrategy;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.FileMetadata;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.IDiskBasedStrategy;
import com.bigdata.journal.IHABufferStrategy;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.Options;
import com.bigdata.journal.OverflowException;
import com.bigdata.journal.StoreState;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumException;
import com.bigdata.util.ChecksumError;
import com.bigdata.util.ChecksumUtility;
import com.bigdata.util.MergeStreamWithSnapshotData;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WORMStrategy
extends AbstractBufferStrategy
implements IDiskBasedStrategy,
IHABufferStrategy,
IBackingReader {
    private final File file;
    private final String fileMode;
    private final boolean temporaryStore;
    private boolean fileOpened;
    private volatile RandomAccessFile raf;
    private final int headerSize;
    private long extent;
    private long userExtent;
    private final long minimumExtension;
    private final Quorum<?, ?> quorum;
    private final ReentrantReadWriteLock extensionLock = new ReentrantReadWriteLock();
    private volatile WORMWriteCacheService writeCacheService;
    private final boolean useChecksums;
    private final int writeCacheBufferCount;
    private final int readCacheBufferCount;
    private final int hotCacheThreshold;
    private final int hotCacheSize;
    private final String compressorKey;
    private final boolean isQuorumUsed;
    private final AtomicReference<UUID> storeUUIDRef = new AtomicReference();
    private final AtomicReference<StoreCounters> storeCounters = new AtomicReference();
    private long lastBlockSequence = 0L;
    private final IReopenChannel<FileChannel> opener = new IReopenChannel<FileChannel>(){

        @Override
        public String toString() {
            return WORMStrategy.this.file.toString();
        }

        @Override
        public FileChannel reopenChannel() throws IOException {
            return WORMStrategy.this.reopenChannel();
        }
    };
    private final Object writeOnCacheLock = new Object();
    private final ByteBuffer _checkbuf;

    @Override
    public WORMWriteCacheService getWriteCacheService() {
        return this.writeCacheService;
    }

    @Override
    public boolean useChecksums() {
        return this.useChecksums;
    }

    private void flushWriteCache() {
        if (this.writeCacheService != null) {
            try {
                this.writeCacheService.flush(false);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public final int getHeaderSize() {
        return this.headerSize;
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    @Override
    public final RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    @Override
    public final FileChannel getChannel() {
        RandomAccessFile raf = this.getRandomAccessFile();
        if (raf == null) {
            return null;
        }
        return raf.getChannel();
    }

    public StoreCounters<?> getStoreCounters() {
        return this.storeCounters.get();
    }

    public void setStoreCounters(StoreCounters<?> storeCounters) {
        if (storeCounters == null) {
            throw new IllegalArgumentException();
        }
        this.storeCounters.set(storeCounters);
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("nextOffset", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WORMStrategy.this.nextOffset.get());
            }
        });
        root.addCounter("extent", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WORMStrategy.this.extent);
            }
        });
        root.attach(this.storeCounters.get().getCounters());
        if (this.writeCacheService != null) {
            CounterSet tmp = root.makePath("writeCache");
            tmp.attach(this.writeCacheService.getCounters());
        }
        return root;
    }

    WORMStrategy(long maximumExtent, long minimumExtension, FileMetadata fileMetadata, Quorum<?, ?> quorum) {
        super(Long.valueOf(fileMetadata.getProperty(Options.INITIAL_EXTENT, "10485760")), maximumExtent, fileMetadata.offsetBits, fileMetadata.nextOffset, fileMetadata.getBufferMode(), fileMetadata.readOnly);
        boolean useWriteCacheService;
        this.file = fileMetadata.file;
        this.fileMode = fileMetadata.fileMode;
        this.temporaryStore = fileMetadata.getBufferMode() == BufferMode.Temporary;
        this.raf = fileMetadata.raf;
        boolean bl = this.fileOpened = this.raf != null;
        if (!this.temporaryStore && !this.fileOpened) {
            throw new RuntimeException("File not open and not a temporary store");
        }
        this.extent = fileMetadata.extent;
        this.headerSize = 688;
        this.userExtent = this.extent - (long)this.headerSize;
        this.minimumExtension = minimumExtension;
        this.quorum = quorum;
        this.useChecksums = fileMetadata.useChecksums;
        this.storeUUIDRef.set(fileMetadata.rootBlock.getUUID());
        this.storeCounters.set(new StoreCounters(10));
        this.writeCacheBufferCount = fileMetadata.writeCacheBufferCount;
        this.readCacheBufferCount = Integer.valueOf(fileMetadata.getProperty(Options.READ_CACHE_BUFFER_COUNT, "0"));
        this.hotCacheThreshold = Integer.valueOf(fileMetadata.getProperty(Options.HOT_CACHE_THRESHOLD, "1"));
        this.hotCacheSize = Integer.valueOf(fileMetadata.getProperty(Options.HOT_CACHE_SIZE, "10"));
        this.compressorKey = fileMetadata.getProperty("HALogCompressor", "DBS");
        this.isQuorumUsed = quorum != null;
        boolean bl2 = useWriteCacheService = fileMetadata.writeCacheEnabled && !fileMetadata.readOnly && fileMetadata.closeTime == 0L || this.isQuorumUsed;
        if (useWriteCacheService) {
            this.writeCacheService = this.newWriteCacheService();
            this._checkbuf = null;
        } else {
            this.writeCacheService = null;
            this._checkbuf = this.useChecksums ? ByteBuffer.allocateDirect(4) : null;
        }
    }

    private WORMWriteCacheService newWriteCacheService() {
        try {
            return new WORMWriteCacheService(this.writeCacheBufferCount, this.useChecksums, this.extent, this.opener, this.quorum);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final boolean isStable() {
        return true;
    }

    @Override
    public boolean isFullyBuffered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean metadata) {
        this.assertOpen();
        try {
            this.flushWriteCache();
            if (!this.temporaryStore) {
                this.getChannel().force(metadata);
            }
            StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
            try {
                ++c.nforce;
            }
            finally {
                c.release();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void commit() {
        this.flushWriteCache();
        if (this.writeCacheService != null) {
            this.lastBlockSequence = this.writeCacheService.resetSequence();
        }
        super.commit();
    }

    @Override
    public long getBlockSequence() {
        return this.lastBlockSequence;
    }

    @Override
    public long getCurrentBlockSequence() {
        WORMWriteCacheService tmp = this.writeCacheService;
        if (tmp == null) {
            return 0L;
        }
        return tmp.getSequence();
    }

    @Override
    public void abort() {
        super.abort();
        if (this.writeCacheService != null) {
            try {
                if (this.quorum != null) {
                    this.writeCacheService.close();
                    this.writeCacheService = this.newWriteCacheService();
                } else {
                    this.writeCacheService.reset();
                    this.writeCacheService.setExtent(this.extent);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        block7: {
            super.close();
            this.releaseWriteCache();
            try {
                if (this.raf == null) break block7;
                IReopenChannel<FileChannel> iReopenChannel = this.opener;
                synchronized (iReopenChannel) {
                    if (this.raf != null && this.raf.getChannel().isOpen()) {
                        this.raf.close();
                    }
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (!this.bufferMode.isStable() && this.file.exists() && !this.file.delete()) {
            log.warn((Object)("Unable to delete temporary file: " + this.file));
        }
    }

    @Override
    public void deleteResources() {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        if (this.fileOpened && this.file.exists() && !this.file.delete()) {
            log.warn((Object)("Could not delete file: " + this.file.getAbsoluteFile()));
        }
    }

    @Override
    public final long getExtent() {
        return this.extent;
    }

    @Override
    public final long getUserExtent() {
        return this.userExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long addr) {
        try {
            ByteBuffer ret = this.readFromLocalStore(addr);
            return ret;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ChecksumError e) {
            try {
                log.error((Object)(e + " : addr=" + this.toString(addr)), (Throwable)e);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
            try {
                ++c.checksumErrorCount;
            }
            finally {
                c.release();
            }
            if (this.quorum != null && this.quorum.isHighlyAvailable() && this.quorum.isQuorumMet()) {
                try {
                    byte[] a = ((QuorumRead)((Object)this.quorum.getMember())).readFromQuorum(this.storeUUIDRef.get(), addr);
                    return ByteBuffer.wrap(a);
                }
                catch (Throwable t) {
                    throw new RuntimeException("While handling: " + e, t);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readFromLocalStore(long addr) throws InterruptedException {
        ByteBuffer tmp;
        long begin = System.nanoTime();
        if (addr == 0L) {
            throw new IllegalArgumentException("Address is 0L");
        }
        long offset = this.getOffset(addr);
        long paddr = this.offset2PhysicalAddress(offset);
        int nbytes = this.getByteCount(addr);
        if (nbytes == 0) {
            throw new IllegalArgumentException("Record length is zero");
        }
        if (offset + (long)nbytes > this.nextOffset.get()) {
            throw new IllegalArgumentException("Address never written.");
        }
        StoreCounters storeCounters = (StoreCounters)this.storeCounters.get().acquire();
        try {
            if ((long)nbytes > storeCounters.maxReadSize) {
                storeCounters.maxReadSize = nbytes;
            }
        }
        finally {
            storeCounters.release();
        }
        if (this.writeCacheService != null && (tmp = this.writeCacheService.read(paddr, nbytes)) != null) {
            StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
            try {
                ++c.nreads;
                c.bytesRead += (long)nbytes;
                c.elapsedReadNanos += System.nanoTime() - begin;
            }
            finally {
                c.release();
            }
            return tmp;
        }
        long beginDisk = System.nanoTime();
        ByteBuffer dst = ByteBuffer.allocate(nbytes);
        this.readRaw(paddr, dst);
        if (this.useChecksums) {
            int chk = dst.getInt(nbytes - 4);
            dst.limit(nbytes - 4);
            if (chk != ChecksumUtility.threadChk.get().checksum(dst)) {
                throw new ChecksumError("address=" + paddr + ", nbytes=" + nbytes);
            }
        }
        StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
        try {
            ++c.nreads;
            c.bytesRead += (long)nbytes;
            c.bytesReadFromDisk += (long)nbytes;
            c.elapsedReadNanos += System.nanoTime() - begin;
            c.elapsedDiskReadNanos += System.nanoTime() - beginDisk;
        }
        finally {
            c.release();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("diskRead: addr=" + this.toString(addr)));
        }
        return dst;
    }

    private long offset2PhysicalAddress(long offset) {
        return offset + (long)this.headerSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readRaw(long offset, ByteBuffer dst) {
        ReentrantReadWriteLock.ReadLock readLock = this.extensionLock.readLock();
        readLock.lock();
        try {
            int startPos = dst.position();
            try {
                long pos = offset;
                int ndiskRead = FileChannelUtility.readAll(this.opener, dst, pos);
                StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
                try {
                    c.ndiskRead += (long)ndiskRead;
                }
                finally {
                    c.release();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            dst.position(startPos);
            ByteBuffer byteBuffer = dst;
            return byteBuffer;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileChannel reopenChannel() throws IOException {
        FileChannel channel;
        RandomAccessFile tmp = this.raf;
        if (tmp != null && (channel = tmp.getChannel()).isOpen()) {
            return channel;
        }
        IReopenChannel<FileChannel> iReopenChannel = this.opener;
        synchronized (iReopenChannel) {
            block14: {
                this.assertOpen();
                if (this.raf != null && this.raf.getChannel().isOpen()) {
                    return this.raf.getChannel();
                }
                if (this.temporaryStore && !this.fileOpened) {
                    throw new AssertionError((Object)("TemporaryStore not yet open: " + this.file));
                }
                this.raf = new RandomAccessFile(this.file, this.fileMode);
                if (log.isInfoEnabled()) {
                    log.info((Object)("(Re-)opened file: " + this.file));
                }
                try {
                    boolean readOnly = "r".equals(this.fileMode);
                    if (this.raf.getChannel().tryLock(0L, Long.MAX_VALUE, readOnly) != null) break block14;
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new IOException("File already locked? file=" + this.file);
                }
                catch (IOException ex) {
                    if (!log.isInfoEnabled()) break block14;
                    log.info((Object)("FileLock not supported: file=" + this.file), (Throwable)ex);
                }
            }
            StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
            try {
                ++c.nreopen;
            }
            finally {
                c.release();
            }
            return this.raf.getChannel();
        }
    }

    private long allocate(int nbytes) {
        long offset = this.nextOffset.get();
        this.overflow(offset, nbytes);
        long addr = this.toAddr(nbytes, offset);
        this.nextOffset.addAndGet(nbytes);
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer data) {
        long addr;
        if (data == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException("Read only");
        }
        int remaining = data.remaining();
        int nwrite = remaining + (this.useChecksums ? 4 : 0);
        if (remaining == 0) {
            throw new IllegalArgumentException("Zero bytes remaining in buffer");
        }
        long begin = System.nanoTime();
        int chk = this.useChecksums ? ChecksumUtility.threadChk.get().checksum(data) : 0;
        try {
            Object object = this.writeOnCacheLock;
            synchronized (object) {
                addr = this.allocate(nwrite);
                long offset = this.getOffset(addr);
                long paddr = this.offset2PhysicalAddress(offset);
                boolean wroteOnCache = false;
                if (this.writeCacheService != null) {
                    if (!this.writeCacheService.write(paddr, data, chk)) {
                        throw new AssertionError();
                    }
                    wroteOnCache = true;
                }
                if (!wroteOnCache) {
                    ReentrantReadWriteLock.ReadLock readLock = this.extensionLock.readLock();
                    readLock.lock();
                    try {
                        this.writeOnDisk(data, paddr);
                        if (this.useChecksums) {
                            ByteBuffer b = this._checkbuf;
                            b.clear();
                            b.putInt(chk);
                            b.flip();
                            this.writeOnDisk(b, paddr + (long)remaining);
                        }
                    }
                    finally {
                        readLock.unlock();
                    }
                }
            }
            StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
            try {
                ++c.nwrites;
                c.bytesWritten += (long)nwrite;
                c.elapsedWriteNanos += System.nanoTime() - begin;
                if ((long)nwrite > c.maxWriteSize) {
                    c.maxWriteSize = nwrite;
                }
            }
            finally {
                c.release();
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return addr;
    }

    private void overflow(long offset, int nbytes) {
        long needed = offset + (long)nbytes - this.userExtent;
        if (needed > 0L && !this.overflow(needed)) {
            throw new OverflowException();
        }
    }

    @Override
    protected long getMinimumExtension() {
        return this.minimumExtension;
    }

    private final void createBackingFile() {
        if (!this.fileOpened && this.temporaryStore) {
            try {
                this.fileOpened = true;
                this.reopenChannel();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Opened backing file for temporary store: " + this.file));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open temp file: file=" + this.file, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeOnDisk(ByteBuffer data, long offset) {
        assert (offset >= 0L) : "offset=" + offset;
        assert (this.extensionLock.getReadHoldCount() > 0 || this.extensionLock.getWriteHoldCount() > 0);
        long begin = System.nanoTime();
        this.createBackingFile();
        int nbytes = data.remaining();
        assert (offset >= (long)this.headerSize);
        long pos = offset;
        try {
            int nwrites = FileChannelUtility.writeAll(this.opener, data, pos);
            long elapsed = System.nanoTime() - begin;
            StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
            try {
                c.ndiskWrite += (long)nwrites;
                c.bytesWrittenOnDisk += (long)nbytes;
                c.elapsedDiskWriteNanos += elapsed;
            }
            finally {
                c.release();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("wrote on disk: bytes=" + nbytes + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms; totals: write=" + TimeUnit.NANOSECONDS.toMillis(this.storeCounters.get().elapsedDiskWriteNanos) + "ms, read=" + TimeUnit.NANOSECONDS.toMillis(this.storeCounters.get().elapsedDiskReadNanos) + "ms"));
            }
            return nwrites;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ByteBuffer readRootBlock(boolean rootBlock0) {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        ByteBuffer tmp = ByteBuffer.allocate(340);
        try {
            FileChannelUtility.readAll(this.opener, tmp, rootBlock0 ? 8L : 348L);
            tmp.position(0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRootBlock(IRootBlockView rootBlock, ForceEnum forceOnCommit) {
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        try {
            ByteBuffer data = rootBlock.asReadOnlyBuffer();
            long pos = rootBlock.isRootBlock0() ? 8L : 348L;
            ReentrantReadWriteLock.ReadLock lock = this.extensionLock.readLock();
            lock.lock();
            try {
                FileChannelUtility.writeAll(this.opener, data, pos);
                if (!this.temporaryStore) {
                    this.getChannel().force(forceOnCommit == ForceEnum.ForceMetadata);
                }
                StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
                try {
                    ++c.nwriteRootBlock;
                }
                finally {
                    c.release();
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("wrote root block: " + rootBlock));
        }
    }

    @Override
    public void truncate(long newExtent) {
        long newUserExtent = newExtent - (long)this.headerSize;
        if (newUserExtent < this.getNextOffset()) {
            throw new IllegalArgumentException("Would truncate written data.");
        }
        if (newUserExtent == this.getUserExtent()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.extensionLock.writeLock();
        writeLock.lock();
        try {
            this.createBackingFile();
            this.getRandomAccessFile().setLength(newExtent);
            if (this.writeCacheService != null) {
                try {
                    this.writeCacheService.setExtent(newExtent);
                }
                catch (InterruptedException t) {
                    throw new RuntimeException(t);
                }
            }
            this.userExtent = newUserExtent;
            this.extent = newExtent;
            ++this.storeCounters.get().ntruncate;
            if (!this.temporaryStore) {
                this.extensionLock.readLock().lock();
                this.extensionLock.writeLock().unlock();
                this.force(true);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("newLength=" + cf.format(newExtent) + ", file=" + this.file));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)this.getCounters().toString());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.extensionLock.readLock().unlock();
        }
    }

    @Override
    public synchronized long transferTo(RandomAccessFile out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.flushWriteCache();
        return AbstractBufferStrategy.transferFromDiskTo(this, out);
    }

    @Override
    public void closeForWrites() {
        super.closeForWrites();
        try {
            this.writeCacheService.reset();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private final void releaseWriteCache() {
        if (this.writeCacheService != null) {
            this.writeCacheService.close();
        }
    }

    @Override
    public void delete(long addr) {
        if (this.writeCacheService != null) {
            this.writeCacheService.clearWrite(addr, 0);
        }
    }

    @Override
    public void writeRawBuffer(IHAWriteMessage msg, IBufferAccess b) throws IOException, InterruptedException {
        final ByteBuffer xb = msg.expand(b.buffer());
        log.warn((Object)("Buffer, position: " + xb.position() + ", limit: " + xb.limit()));
        IBufferAccess ba = new IBufferAccess(){

            @Override
            public ByteBuffer buffer() {
                return xb;
            }

            @Override
            public void release() throws InterruptedException {
            }

            @Override
            public void release(long timeout, TimeUnit unit) throws InterruptedException {
            }
        };
        WriteCache writeCache = this.writeCacheService.newWriteCache(ba, this.useChecksums, true, this.opener, msg.getFileExtent());
        writeCache.closeForWrites();
        long firstOffset = msg.getFirstOffset();
        if (firstOffset < (long)this.getHeaderSize()) {
            throw new IllegalArgumentException("firstOffset must be beyond header: firstOffset=" + firstOffset + ", headerSize=" + this.getHeaderSize());
        }
        if (firstOffset < this.getNextOffset()) {
            throw new IllegalArgumentException("firstOffset must be beyond nextOffset: firstOffset=" + firstOffset + ", nextOffset=" + this.getNextOffset());
        }
        ((WriteCacheImpl)writeCache).setFirstOffset(firstOffset);
        ByteBuffer bb = ba.buffer();
        int limit = bb.limit();
        bb.position(limit);
        writeCache.flush(false);
        this.writeCacheService.installReads(writeCache);
    }

    @Override
    public Future<Void> sendHALogBuffer(IHALogRequest req, IHAWriteMessage msg, IBufferAccess b) throws IOException, InterruptedException {
        ByteBuffer clientBuffer = b.buffer();
        assert (clientBuffer.remaining() > 0) : "Empty buffer: " + clientBuffer;
        QuorumPipeline quorumMember = (QuorumPipeline)((Object)this.quorum.getMember());
        Future<Void> remoteWriteFuture = quorumMember.replicate(req, msg, clientBuffer);
        return remoteWriteFuture;
    }

    @Override
    public Future<Void> sendRawBuffer(IHARebuildRequest req, long sequence, long quorumToken, long fileExtent, long offset, int nbytes, ByteBuffer b) throws IOException, InterruptedException {
        ByteBuffer clientBuffer = b;
        clientBuffer.position(0);
        clientBuffer.limit(nbytes);
        this.readRaw(offset, clientBuffer);
        assert (clientBuffer.remaining() > 0) : "Empty buffer: " + clientBuffer;
        QuorumPipeline quorumMember = (QuorumPipeline)((Object)this.quorum.getMember());
        int chk = ChecksumUtility.threadChk.get().checksum(b);
        HAWriteMessage msg = new HAWriteMessage(this.storeUUIDRef.get(), -1L, -1L, sequence, nbytes, chk, StoreTypeEnum.WORM, quorumToken, fileExtent, offset);
        Future<Void> remoteWriteFuture = quorumMember.replicate(req, msg, clientBuffer);
        return remoteWriteFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOnStream(OutputStream os, AbstractJournal.ISnapshotData snapshotData, Quorum<HAGlue, QuorumService<HAGlue>> quorum, long token) throws IOException, QuorumException {
        try (FileChannelUtility.ReopenerInputStream instr = new FileChannelUtility.ReopenerInputStream(this.opener);){
            MergeStreamWithSnapshotData.process(instr, snapshotData, os);
            if (!quorum.getClient().isJoinedMember(token)) {
                throw new QuorumException();
            }
        }
    }

    @Override
    public void setExtentForLocalStore(long extent) throws IOException, InterruptedException {
        this.truncate(extent);
    }

    @Override
    public void resetFromHARootBlock(IRootBlockView rootBlock) {
        long rbNextOffset = rootBlock.getNextOffset();
        this.nextOffset.set(rbNextOffset);
        this.commitOffset.set(rbNextOffset);
        this.storeUUIDRef.set(rootBlock.getUUID());
    }

    @Override
    public void postHACommit(IRootBlockView rootBlock) {
        long rbNextOffset = rootBlock.getNextOffset();
        this.nextOffset.set(rbNextOffset);
        this.commitOffset.set(rbNextOffset);
    }

    @Override
    public Object snapshotAllocators() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeDigest(Object snapshot, MessageDigest digest) throws DigestException, IOException {
        if (snapshot != null) {
            throw new UnsupportedOperationException();
        }
        IBufferAccess buf = null;
        try {
            long fileExtent;
            long totalBytes;
            try {
                buf = DirectBufferPool.INSTANCE.acquire();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            ByteBuffer b = buf.buffer();
            int bufferCapacity = b.capacity();
            long remaining = totalBytes = (fileExtent = this.getExtent());
            long offset = 0L;
            long sequence = 0L;
            if (log.isInfoEnabled()) {
                log.info((Object)("Computing digest: nbytes=" + totalBytes));
            }
            while (remaining > 0L) {
                int nbytes = (int)Math.min((long)bufferCapacity, remaining);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Computing digest: sequence=" + sequence + ", offset=" + offset + ", nbytes=" + nbytes));
                }
                b.position(0);
                b.limit(nbytes);
                this.readRaw(offset, b);
                digest.update(b);
                remaining -= (long)nbytes;
                offset += (long)nbytes;
                ++sequence;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Computed digest: #blocks=" + sequence + ", #bytes=" + totalBytes));
            }
            return;
        }
        finally {
            if (buf != null) {
                try {
                    buf.release();
                }
                catch (InterruptedException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    @Override
    public void writeRawBuffer(HARebuildRequest req, IHAWriteMessage msg, ByteBuffer transfer) throws IOException {
        ByteBuffer xtransfer = msg.expand(transfer);
        FileChannelUtility.writeAll(this.opener, xtransfer, msg.getFirstOffset());
    }

    @Override
    public StoreState getStoreState() {
        return new WormStoreState();
    }

    public static class WormStoreState
    implements StoreState {
        private static final long serialVersionUID = 1L;

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof WormStoreState)) {
                return false;
            }
            WormStoreState other = (WormStoreState)obj;
            return true;
        }
    }

    private class WriteCacheImpl
    extends WriteCache.FileChannelWriteCache {
        public WriteCacheImpl(long baseOffset, IBufferAccess buf, boolean useChecksum, boolean bufferHasData, IReopenChannel<FileChannel> opener, long fileExtent) throws InterruptedException {
            super(baseOffset, buf, useChecksum, WORMStrategy.this.isQuorumUsed, bufferHasData, opener, fileExtent);
        }

        @Override
        protected String getCompressorKey() {
            return WORMStrategy.this.compressorKey;
        }

        @Override
        protected void setFirstOffset(long firstOffset) {
            super.setFirstOffset(firstOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean writeOnChannel(ByteBuffer data, long firstOffset, Map<Long, WriteCache.RecordMetadata> recordMapIsIgnored, long nanos) throws InterruptedException, IOException {
            long begin = System.nanoTime();
            long remaining = nanos;
            ReentrantReadWriteLock.ReadLock readLock = WORMStrategy.this.extensionLock.readLock();
            if (!readLock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
                return false;
            }
            try {
                remaining = nanos - (System.nanoTime() - begin);
                int dpos = data.position();
                int nbytes = data.remaining();
                int nwrites = WORMStrategy.this.writeOnDisk(data, firstOffset);
                WriteCacheCounters counters = (WriteCacheCounters)this.counters.get();
                counters.nchannelWrite += (long)nwrites;
                counters.bytesWritten += (long)nbytes;
                counters.elapsedWriteNanos += System.nanoTime() - begin;
                if (WriteCache.log.isTraceEnabled()) {
                    WriteCache.log.trace((Object)("wroteOnDisk: dpos=" + dpos + ", nbytes=" + nbytes + ", firstOffset=" + firstOffset + ", nrecords=" + recordMapIsIgnored.size()));
                }
                boolean bl = true;
                return bl;
            }
            finally {
                readLock.unlock();
            }
        }
    }

    private class WORMWriteCacheService
    extends WriteCacheService {
        WORMWriteCacheService(int nbuffers, boolean useChecksum, long fileExtent, IReopenChannel<? extends Channel> opener, Quorum quorum) throws InterruptedException {
            super(WORMStrategy.this.writeCacheBufferCount, 0, WORMStrategy.this.readCacheBufferCount, false, 100, WORMStrategy.this.hotCacheSize, WORMStrategy.this.hotCacheThreshold, WORMStrategy.this.useChecksums, WORMStrategy.this.extent, opener, quorum, WORMStrategy.this);
        }

        @Override
        public WriteCacheImpl newWriteCache(IBufferAccess buf, boolean useChecksum, boolean bufferHasData, IReopenChannel<? extends Channel> opener, long fileExtent) throws InterruptedException {
            return new WriteCacheImpl(0L, buf, useChecksum, bufferHasData, opener, fileExtent);
        }
    }

    public static class StoreCounters<T extends StoreCounters<T>>
    extends StripedCounters<T> {
        public volatile long nreads;
        public volatile long ndiskRead;
        public volatile long bytesRead;
        public volatile long bytesReadFromDisk;
        public volatile long elapsedReadNanos;
        public volatile long elapsedDiskReadNanos;
        public volatile long checksumErrorCount;
        public volatile long nwrites;
        public volatile long ndiskWrite;
        public volatile long maxReadSize;
        public volatile long maxWriteSize;
        public volatile long bytesWritten;
        public volatile long bytesWrittenOnDisk;
        public volatile long elapsedWriteNanos;
        public volatile long elapsedDiskWriteNanos;
        public volatile long nforce;
        public volatile long ntruncate;
        public volatile long nreopen;
        public volatile long nwriteRootBlock;

        public StoreCounters() {
        }

        public StoreCounters(int batchSize) {
            super(batchSize);
        }

        public StoreCounters(int nstripes, int batchSize) {
            super(nstripes, batchSize);
        }

        @Override
        public void add(T o) {
            super.add(o);
            this.nreads += ((StoreCounters)o).nreads;
            this.ndiskRead += ((StoreCounters)o).ndiskRead;
            this.bytesRead += ((StoreCounters)o).bytesRead;
            this.bytesReadFromDisk += ((StoreCounters)o).bytesReadFromDisk;
            this.maxReadSize = Math.max(this.maxReadSize, ((StoreCounters)o).maxReadSize);
            this.elapsedReadNanos += ((StoreCounters)o).elapsedReadNanos;
            this.elapsedDiskReadNanos += ((StoreCounters)o).elapsedDiskReadNanos;
            this.checksumErrorCount += ((StoreCounters)o).checksumErrorCount;
            this.nwrites += ((StoreCounters)o).nwrites;
            this.ndiskWrite += ((StoreCounters)o).ndiskWrite;
            this.maxWriteSize = Math.max(this.maxWriteSize, ((StoreCounters)o).maxWriteSize);
            this.bytesWritten += ((StoreCounters)o).bytesWritten;
            this.bytesWrittenOnDisk += ((StoreCounters)o).bytesWrittenOnDisk;
            this.elapsedWriteNanos += ((StoreCounters)o).elapsedWriteNanos;
            this.elapsedDiskWriteNanos += ((StoreCounters)o).elapsedDiskWriteNanos;
            this.nforce += ((StoreCounters)o).nforce;
            this.ntruncate += ((StoreCounters)o).ntruncate;
            this.nreopen += ((StoreCounters)o).nreopen;
            this.nwriteRootBlock += ((StoreCounters)o).nwriteRootBlock;
        }

        @Override
        public T subtract(T o) {
            StoreCounters t = (StoreCounters)super.subtract(o);
            t.nreads -= ((StoreCounters)o).nreads;
            t.ndiskRead -= ((StoreCounters)o).ndiskRead;
            t.bytesRead -= ((StoreCounters)o).bytesRead;
            t.bytesReadFromDisk -= ((StoreCounters)o).bytesReadFromDisk;
            t.maxReadSize -= ((StoreCounters)o).maxReadSize;
            t.elapsedReadNanos -= ((StoreCounters)o).elapsedReadNanos;
            t.elapsedDiskReadNanos -= ((StoreCounters)o).elapsedDiskReadNanos;
            t.checksumErrorCount -= ((StoreCounters)o).checksumErrorCount;
            t.nwrites -= ((StoreCounters)o).nwrites;
            t.ndiskWrite -= ((StoreCounters)o).ndiskWrite;
            t.maxWriteSize -= ((StoreCounters)o).maxWriteSize;
            t.bytesWritten -= ((StoreCounters)o).bytesWritten;
            t.bytesWrittenOnDisk -= ((StoreCounters)o).bytesWrittenOnDisk;
            t.elapsedWriteNanos -= ((StoreCounters)o).elapsedWriteNanos;
            t.elapsedDiskWriteNanos -= ((StoreCounters)o).elapsedDiskWriteNanos;
            t.nforce -= ((StoreCounters)o).nforce;
            t.ntruncate -= ((StoreCounters)o).ntruncate;
            t.nreopen -= ((StoreCounters)o).nreopen;
            t.nwriteRootBlock -= ((StoreCounters)o).nwriteRootBlock;
            return (T)t;
        }

        @Override
        public void clear() {
            this.nreads = 0L;
            this.ndiskRead = 0L;
            this.bytesRead = 0L;
            this.bytesReadFromDisk = 0L;
            this.maxReadSize = 0L;
            this.elapsedReadNanos = 0L;
            this.elapsedDiskReadNanos = 0L;
            this.checksumErrorCount = 0L;
            this.nwrites = 0L;
            this.ndiskWrite = 0L;
            this.maxWriteSize = 0L;
            this.bytesWritten = 0L;
            this.bytesWrittenOnDisk = 0L;
            this.elapsedWriteNanos = 0L;
            this.elapsedDiskWriteNanos = 0L;
            this.nforce = 0L;
            this.ntruncate = 0L;
            this.nreopen = 0L;
            this.nwriteRootBlock = 0L;
        }

        @Override
        public CounterSet getCounters() {
            CounterSet root = super.getCounters();
            root.addCounter("nreads", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nreads);
                }
            });
            root.addCounter("bytesRead", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bytesRead);
                }
            });
            root.addCounter("readSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double elapsedReadSecs = (double)StoreCounters.this.elapsedReadNanos / 1.0E9;
                    this.setValue(elapsedReadSecs);
                }
            });
            root.addCounter("bytesReadPerSec", new Instrument<Double>(){

                @Override
                public void sample() {
                    double readSecs = (double)StoreCounters.this.elapsedReadNanos / 1.0E9;
                    double bytesReadPerSec = readSecs == 0.0 ? 0.0 : (double)StoreCounters.this.bytesRead / readSecs;
                    this.setValue(bytesReadPerSec);
                }
            });
            root.addCounter("maxReadSize", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.maxReadSize);
                }
            });
            root.addCounter("checksumErrorCount", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.checksumErrorCount);
                }
            });
            root.addCounter("nwrites", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nwrites);
                }
            });
            root.addCounter("bytesWritten", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bytesWritten);
                }
            });
            root.addCounter("writeSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double writeSecs = (double)StoreCounters.this.elapsedWriteNanos / 1.0E9;
                    this.setValue(writeSecs);
                }
            });
            root.addCounter("bytesWrittenPerSec", new Instrument<Double>(){

                @Override
                public void sample() {
                    double writeSecs = (double)StoreCounters.this.elapsedWriteNanos / 1.0E9;
                    double bytesWrittenPerSec = writeSecs == 0.0 ? 0.0 : (double)StoreCounters.this.bytesWritten / writeSecs;
                    this.setValue(bytesWrittenPerSec);
                }
            });
            root.addCounter("maxWriteSize", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.maxWriteSize);
                }
            });
            CounterSet disk = root.makePath("disk");
            disk.addCounter("nreads", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.ndiskRead);
                }
            });
            disk.addCounter("bytesRead", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bytesReadFromDisk);
                }
            });
            disk.addCounter("bytesPerRead", new Instrument<Double>(){

                @Override
                public void sample() {
                    double bytesPerDiskRead = StoreCounters.this.ndiskRead == 0L ? 0.0 : (double)StoreCounters.this.bytesReadFromDisk / (double)StoreCounters.this.ndiskRead;
                    this.setValue(bytesPerDiskRead);
                }
            });
            disk.addCounter("readSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskReadSecs = (double)StoreCounters.this.elapsedDiskReadNanos / 1.0E9;
                    this.setValue(diskReadSecs);
                }
            });
            disk.addCounter("bytesReadPerSec", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskReadSecs = (double)StoreCounters.this.elapsedDiskReadNanos / 1.0E9;
                    double bytesReadPerSec = diskReadSecs == 0.0 ? 0.0 : (double)StoreCounters.this.bytesReadFromDisk / diskReadSecs;
                    this.setValue(bytesReadPerSec);
                }
            });
            disk.addCounter("secsPerRead", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskReadSecs = (double)StoreCounters.this.elapsedDiskReadNanos / 1.0E9;
                    double readLatency = diskReadSecs == 0.0 ? 0.0 : diskReadSecs / (double)StoreCounters.this.ndiskRead;
                    this.setValue(readLatency);
                }
            });
            disk.addCounter("nwrites", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.ndiskWrite);
                }
            });
            disk.addCounter("bytesWritten", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bytesWrittenOnDisk);
                }
            });
            disk.addCounter("bytesPerWrite", new Instrument<Double>(){

                @Override
                public void sample() {
                    double bytesPerDiskWrite = StoreCounters.this.ndiskWrite == 0L ? 0.0 : (double)StoreCounters.this.bytesWrittenOnDisk / (double)StoreCounters.this.ndiskWrite;
                    this.setValue(bytesPerDiskWrite);
                }
            });
            disk.addCounter("writeSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskWriteSecs = (double)StoreCounters.this.elapsedDiskWriteNanos / 1.0E9;
                    this.setValue(diskWriteSecs);
                }
            });
            disk.addCounter("bytesWrittenPerSec", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskWriteSecs = (double)StoreCounters.this.elapsedDiskWriteNanos / 1.0E9;
                    double bytesWrittenPerSec = diskWriteSecs == 0.0 ? 0.0 : (double)StoreCounters.this.bytesWrittenOnDisk / diskWriteSecs;
                    this.setValue(bytesWrittenPerSec);
                }
            });
            disk.addCounter("secsPerWrite", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskWriteSecs = (double)StoreCounters.this.elapsedDiskWriteNanos / 1.0E9;
                    double writeLatency = diskWriteSecs == 0.0 ? 0.0 : diskWriteSecs / (double)StoreCounters.this.ndiskWrite;
                    this.setValue(writeLatency);
                }
            });
            disk.addCounter("nforce", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nforce);
                }
            });
            disk.addCounter("nextend", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.ntruncate);
                }
            });
            disk.addCounter("nreopen", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nreopen);
                }
            });
            disk.addCounter("rootBlockWrites", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nwriteRootBlock);
                }
            });
            return root;
        }
    }
}

