/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.journal.jini.ha.IRestorePolicy;
import com.bigdata.journal.jini.ha.SnapshotIndex;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DefaultRestorePolicy
implements IRestorePolicy {
    private static final Logger log = Logger.getLogger(DefaultRestorePolicy.class);
    public static final long DEFAULT_MIN_SNAPSHOT_AGE_MILLIS = TimeUnit.DAYS.toMillis(7L);
    public static final int DEFAULT_MIN_SNAPSHOTS = 1;
    public static final int DEFAULT_MIN_RESTORE_POINTS = 0;
    private final long minRestoreAgeMillis;
    private final int minSnapshots;
    private final int minRestorePoints;

    public String toString() {
        return DefaultRestorePolicy.class.getSimpleName() + "{minRestoreAge=" + this.minRestoreAgeMillis + "ms" + ",minSnapshots=" + this.minSnapshots + ",minRestorePoints=" + this.minRestorePoints + "}";
    }

    public DefaultRestorePolicy() {
        this(DEFAULT_MIN_SNAPSHOT_AGE_MILLIS, 1, 0);
    }

    public DefaultRestorePolicy(long minRestoreAgeMillis) {
        this(minRestoreAgeMillis, 1, 0);
    }

    public DefaultRestorePolicy(long minRestoreAgeMillis, int minSnapshots, int minRestorePoints) {
        if (minRestoreAgeMillis < 0L) {
            throw new IllegalArgumentException("minRestoreAgeMillis must be GTE ZERO (0), not " + minRestoreAgeMillis);
        }
        if (minSnapshots < 1) {
            throw new IllegalArgumentException("minSnapshots must be GTE ONE (1), not " + minSnapshots);
        }
        if (minRestorePoints < 0) {
            throw new IllegalArgumentException("minRestorePoints must be GTE ZERO (0), not " + minRestorePoints);
        }
        this.minRestoreAgeMillis = minRestoreAgeMillis;
        this.minSnapshots = minSnapshots;
        this.minRestorePoints = minRestorePoints;
    }

    private long getEarliestRestorableCommitCounterByAge(HAJournal jnl, long commitCounterOnJournal) {
        IRootBlockView rootBlock;
        long now = System.currentTimeMillis();
        long then = now - this.minRestoreAgeMillis;
        SnapshotIndex.ISnapshotRecord sr = jnl.getSnapshotManager().find(then);
        IRootBlockView iRootBlockView = rootBlock = sr == null ? null : sr.getRootBlock();
        if (rootBlock == null) {
            return commitCounterOnJournal;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("minRestoreAgeMillis=" + this.minRestoreAgeMillis + ", now=" + now + ", then=" + then + ", rootBlock=" + rootBlock));
        }
        return rootBlock.getCommitCounter();
    }

    private long getEarliestRestorableCommitCounterBySnapshots(HAJournal jnl, long commitCounterOnJournal) {
        SnapshotIndex.ISnapshotRecord r = jnl.getSnapshotManager().getSnapshotByReverseIndex(this.minSnapshots - 1);
        if (r == null) {
            return 0L;
        }
        return r.getRootBlock().getCommitCounter();
    }

    private long getEarliestRestorableCommitCounterByCommitPoints(HAJournal jnl, long commitCounterOnJournal) {
        long desiredCommitCounter = commitCounterOnJournal - (long)this.minRestorePoints;
        if (desiredCommitCounter <= 0L) {
            return 0L;
        }
        SnapshotIndex.ISnapshotRecord r = jnl.getSnapshotManager().findByCommitCounter(desiredCommitCounter);
        if (r == null) {
            return commitCounterOnJournal;
        }
        return r.getRootBlock().getCommitCounter();
    }

    @Override
    public long getEarliestRestorableCommitPoint(HAJournal jnl) {
        long commitCounterOnJournal = jnl.getRootBlockView().getCommitCounter();
        long commitCounterRetainedByAge = this.getEarliestRestorableCommitCounterByAge(jnl, commitCounterOnJournal);
        long commitCounterRetainedBySnapshotCount = this.getEarliestRestorableCommitCounterBySnapshots(jnl, commitCounterOnJournal);
        long commitCounterRetainedByHALogCount = this.getEarliestRestorableCommitCounterByCommitPoints(jnl, commitCounterOnJournal);
        long commitCounterRetained = Math.min(commitCounterRetainedByAge, Math.min(commitCounterRetainedBySnapshotCount, commitCounterRetainedByHALogCount));
        if (log.isInfoEnabled()) {
            log.info((Object)("policy=" + this + ", commitCounterOnJournal=" + commitCounterOnJournal + ", commitCounterByAge=" + commitCounterRetainedByAge + ", commitCounterBySnapshots=" + commitCounterRetainedBySnapshotCount + ", commitCounterByHALogs=" + commitCounterRetainedByHALogCount + ", effectiveCommitCounterRetained=" + commitCounterRetained));
        }
        return commitCounterRetained;
    }
}

