/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.btree.BytesUtil;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.IndexManagerCallable;
import com.bigdata.ha.halog.IHALogReader;
import com.bigdata.journal.jini.ha.HAClient;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.journal.jini.ha.HALogIndex;
import com.bigdata.journal.jini.ha.HALogNexus;
import com.bigdata.journal.jini.ha.SnapshotIndex;
import com.bigdata.journal.jini.ha.SnapshotManager;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.zk.ZKQuorumClient;
import cutthecrap.utils.striterators.EmptyIterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class DumpLogDigests {
    private static final Logger log = Logger.getLogger(DumpLogDigests.class);
    private static final int DEFAULT_SERVICE_THREADS = 5;
    private static final int DEFAULT_BATCH = 50;
    final HAClient client;

    public DumpLogDigests(String[] configFiles) throws ConfigurationException, IOException, InterruptedException {
        this.client = new HAClient(configFiles);
    }

    public void shutdown() {
        this.client.disconnect(true);
    }

    public Iterator<ServiceLogs> summary(String serviceRoot) throws IOException, ExecutionException {
        return DumpLogDigests.summary(this.dump(serviceRoot, 50, 5));
    }

    public Iterator<ServiceLogs> dump(String serviceRoot) throws IOException, ExecutionException {
        return this.dump(serviceRoot, 50, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ServiceLogs> dump(String serviceRoot, int batchSize, int serviceThreads) throws IOException, ExecutionException {
        Iterator<ServiceLogs> iterator;
        List<HAGlue> services = this.services(serviceRoot);
        if (services.isEmpty()) {
            throw new IllegalArgumentException("No services found for " + serviceRoot);
        }
        ArrayList<HAGlue> pinners = new ArrayList<HAGlue>();
        try {
            long startCC = -1L;
            long endCC = -1L;
            for (HAGlue pinner : services) {
                LogDigestParams params = pinner.submit(new PinLogs(), false).get();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Pinning startCC: " + params.startCC + ", endCC: " + params.endCC + ", last snapshot: " + params.snapshotCC));
                }
                if (params.startCC != -1L) {
                    if (startCC == -1L || startCC > params.startCC) {
                        startCC = params.startCC;
                    }
                    if (endCC < params.endCC) {
                        endCC = params.endCC;
                    }
                }
                pinners.add(pinner);
            }
            ArrayList<Future<List<HALogInfo>>> results = new ArrayList<Future<List<HALogInfo>>>();
            long batchStart = startCC;
            long batchEnd = batchStart + (long)batchSize - 1L;
            int tasks = 0;
            while (true) {
                if (batchEnd > endCC) {
                    batchEnd = endCC;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Running batch start: " + batchStart + ", end: " + batchEnd + " across " + services));
                }
                for (HAGlue glue : services) {
                    results.add(glue.submit(new GetLogInfo(batchStart, batchEnd, serviceThreads), false));
                    ++tasks;
                }
                if (batchEnd == endCC) break;
                batchStart += (long)batchSize;
                batchEnd += (long)batchSize;
            }
            final ArrayList<ServiceLogWait> logs = new ArrayList<ServiceLogWait>();
            for (int t = 0; t < tasks; ++t) {
                int s = t % services.size();
                logs.add(new ServiceLogWait(services.get(s).getServiceUUID().toString(), (Future)results.get(t), s, services.size()));
            }
            iterator = new Iterator<ServiceLogs>(){
                final Iterator<ServiceLogWait> src;
                {
                    this.src = logs.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.src.hasNext();
                }

                @Override
                public ServiceLogs next() {
                    ServiceLogWait data = this.src.next();
                    try {
                        return new ServiceLogs(data.service, data.waitlogInfos.get(), data.item, data.batch);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Throwable throwable) {
            try {
                for (HAGlue pinner : pinners) {
                    try {
                        pinner.submit(new UnpinLogs(), false);
                    }
                    catch (Throwable t) {
                        log.error((Object)"Problem submitting UnpinLogs", t);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (KeeperException e) {
                throw new RuntimeException(e);
            }
        }
        for (HAGlue pinner : pinners) {
            try {
                pinner.submit(new UnpinLogs(), false);
            }
            catch (Throwable t) {
                log.error((Object)"Problem submitting UnpinLogs", t);
            }
        }
        return iterator;
    }

    public static void main(String[] args) throws ConfigurationException, IOException, InterruptedException, ExecutionException {
        if (args.length < 2 || args.length > 3) {
            System.err.println("required arguments: <configFile> <serviceRoot> [\"summary\"]");
            return;
        }
        String configFile = args[0];
        String serviceRoot = args[1];
        boolean summary = args.length > 2 ? "summary".equals(args[2]) : false;
        DumpLogDigests dld = new DumpLogDigests(new String[]{configFile});
        Iterator<ServiceLogs> slogs = summary ? dld.summary(serviceRoot) : dld.dump(serviceRoot);
        while (slogs.hasNext()) {
            ServiceLogs sl = slogs.next();
            if (sl.logInfos.size() <= 0) continue;
            System.out.println(sl.toString());
        }
    }

    public static Iterator<ServiceLogs> summary(final Iterator<ServiceLogs> slogs) {
        return new Iterator<ServiceLogs>(){
            Iterator<ServiceLogs> delta = new EmptyIterator<ServiceLogs>();

            @Override
            public boolean hasNext() {
                return this.delta.hasNext() || slogs.hasNext();
            }

            @Override
            public ServiceLogs next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.delta.hasNext()) {
                    return this.delta.next();
                }
                this.delta = DumpLogDigests.delta(slogs).iterator();
                return this.delta.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static List<ServiceLogs> delta(Iterator<ServiceLogs> slogs) {
        ArrayList<ServiceLogs> tmp = new ArrayList<ServiceLogs>();
        while (slogs.hasNext()) {
            ServiceLogs sl = slogs.next();
            tmp.add(sl);
            if (sl.item != sl.batch - 1) continue;
            break;
        }
        if (tmp.size() > 0) {
            ServiceLogs t = tmp.get(0);
            for (int n = 1; n < tmp.size(); ++n) {
                if (tmp.get((int)n).logInfos.size() == t.logInfos.size()) continue;
                return tmp;
            }
            for (int li = t.logInfos.size() - 1; li >= 0; --li) {
                int n;
                HALogInfo s = t.logInfos.get(li);
                boolean include = false;
                for (n = 1; n < tmp.size(); ++n) {
                    HALogInfo tst = tmp.get((int)n).logInfos.get(li);
                    if (BytesUtil.compareBytes(tst.digest, s.digest) == 0) continue;
                    include = true;
                }
                if (include) continue;
                for (n = 0; n < tmp.size(); ++n) {
                    tmp.get((int)n).logInfos.remove(li);
                }
            }
        }
        return tmp;
    }

    private List<HAGlue> services(String serviceRoot) throws IOException, ExecutionException, KeeperException, InterruptedException {
        HAGlue[] haglues;
        ArrayList<HAGlue> ret = new ArrayList<HAGlue>();
        HAClient.HAConnection cnxn = this.client.connect();
        Quorum<HAGlue, ZKQuorumClient<HAGlue>> quorum = cnxn.getHAGlueQuorum(serviceRoot);
        UUID[] uuids = quorum.getJoined();
        for (HAGlue haglue : haglues = cnxn.getHAGlueService(uuids)) {
            ret.add(haglue);
        }
        this.client.disconnect(true);
        return ret;
    }

    class ServiceLogWait {
        final Future<List<HALogInfo>> waitlogInfos;
        final String service;
        final int item;
        final int batch;

        ServiceLogWait(String service, Future<List<HALogInfo>> waitlogInfos, int batch, int item) {
            this.waitlogInfos = waitlogInfos;
            this.service = service;
            this.item = item;
            this.batch = batch;
        }
    }

    public static class ServiceLogs
    implements Serializable {
        public final List<HALogInfo> logInfos;
        public final String service;
        public final int item;
        public final int batch;

        ServiceLogs(String service, List<HALogInfo> logInfos, int batch, int item) {
            this.logInfos = logInfos;
            this.service = service;
            this.item = item;
            this.batch = batch;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Service: " + this.service + "\n");
            for (HALogInfo li : this.logInfos) {
                sb.append("CC[" + li.commitCounter + "]");
                sb.append(" " + (li.digest == null ? "NOT FOUND" : BytesUtil.toHexString(li.digest)));
                sb.append(" " + (li.isOpen ? "open" : "closed"));
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    public static class HALogInfo
    implements Serializable,
    Comparable<HALogInfo> {
        public final long commitCounter;
        public final boolean isOpen;
        public final byte[] digest;

        HALogInfo(long commitCounter, boolean isOpen, byte[] bs) {
            this.commitCounter = commitCounter;
            this.isOpen = isOpen;
            this.digest = bs;
        }

        @Override
        public int compareTo(HALogInfo other) {
            assert (this.commitCounter != other.commitCounter) : "self=" + this + ", other=" + other;
            return this.commitCounter < other.commitCounter ? -1 : 1;
        }

        public boolean exists() {
            return this.digest != null;
        }

        public String toString() {
            return this.getClass().getName() + "{commitCounter=" + this.commitCounter + ", isOpen=" + this.isOpen + ", digest=" + BytesUtil.toHexString(this.digest) + "}";
        }
    }

    static class GetLogInfo
    extends IndexManagerCallable<List<HALogInfo>> {
        private final long endCC;
        private final long startCC;
        private final int serviceThreads;

        GetLogInfo(long startCC, long endCC, int serviceThreads) {
            this.startCC = startCC;
            this.endCC = endCC;
            this.serviceThreads = serviceThreads;
            if (serviceThreads < 1 || serviceThreads > 20) {
                throw new IllegalArgumentException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<HALogInfo> call() throws Exception {
            final ConcurrentSkipListSet infos = new ConcurrentSkipListSet();
            HAJournal ha = (HAJournal)this.getIndexManager();
            final HALogNexus nexus = ha.getHALogNexus();
            nexus.addAccessor();
            try {
                long openCC = nexus.getCommitCounter();
                log.warn((Object)("Open Commit Counter: " + openCC + ", startCC: " + this.startCC + ", endCC: " + this.endCC));
                ThreadPoolExecutor es = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.serviceThreads);
                ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
                long cc = this.startCC;
                while (cc <= this.endCC) {
                    final long cur = cc++;
                    Future<Void> res = es.submit(new Callable<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            try {
                                File file = nexus.getHALogFile(cur);
                                log.warn((Object)("Found log file: " + file.getName()));
                                MessageDigest digest = MessageDigest.getInstance("MD5");
                                try (IHALogReader r = nexus.getReader(cur);){
                                    r.computeDigest(digest);
                                }
                                infos.add(new HALogInfo(cur, r.isLive(), digest.digest()));
                            }
                            catch (FileNotFoundException fnf) {
                                infos.add(new HALogInfo(cur, false, null));
                            }
                            catch (Throwable t) {
                                log.warn((Object)"Unexpected error", t);
                                infos.add(new HALogInfo(cur, false, "ERROR".getBytes()));
                            }
                            return null;
                        }
                    });
                    results.add(res);
                }
                for (Future future : results) {
                    future.get();
                }
                es.shutdown();
                ArrayList<HALogInfo> arrayList = new ArrayList<HALogInfo>(infos);
                return arrayList;
            }
            finally {
                nexus.releaseAccessor();
            }
        }
    }

    static class UnpinLogs
    extends IndexManagerCallable<Void> {
        UnpinLogs() {
        }

        @Override
        public Void call() throws Exception {
            HAJournal ha = (HAJournal)this.getIndexManager();
            ha.getHALogNexus().releaseAccessor();
            return null;
        }
    }

    static class PinLogs
    extends IndexManagerCallable<LogDigestParams> {
        PinLogs() {
        }

        @Override
        public LogDigestParams call() throws Exception {
            HAJournal ha = (HAJournal)this.getIndexManager();
            HALogNexus nexus = ha.getHALogNexus();
            Iterator<HALogIndex.IHALogRecord> logs = nexus.getHALogs();
            long endCC = nexus.getCommitCounter() + 1L;
            long startCC = logs.hasNext() ? logs.next().getCommitCounter() : endCC;
            SnapshotManager ssmgr = ha.getSnapshotManager();
            SnapshotIndex.ISnapshotRecord rec = ssmgr.getNewestSnapshot();
            long sscc = rec != null ? rec.getCommitCounter() : -1L;
            nexus.addAccessor();
            return new LogDigestParams(startCC, endCC, sscc);
        }
    }

    public static class LogDigestParams
    implements Serializable {
        public final long startCC;
        public final long endCC;
        public final long snapshotCC;

        LogDigestParams(long startCC, long endCC, long sscc) {
            this.startCC = startCC;
            this.endCC = endCC;
            this.snapshotCC = sscc;
        }
    }
}

