/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.concurrent.FutureTaskInvariantMon;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.RunState;
import com.bigdata.ha.halog.IHALogReader;
import com.bigdata.ha.msg.HADigestResponse;
import com.bigdata.ha.msg.HALogDigestResponse;
import com.bigdata.ha.msg.HALogRootBlocksResponse;
import com.bigdata.ha.msg.HARemoteRebuildRequest;
import com.bigdata.ha.msg.HASendStoreResponse;
import com.bigdata.ha.msg.HASnapshotDigestResponse;
import com.bigdata.ha.msg.IHADigestRequest;
import com.bigdata.ha.msg.IHADigestResponse;
import com.bigdata.ha.msg.IHALogDigestRequest;
import com.bigdata.ha.msg.IHALogDigestResponse;
import com.bigdata.ha.msg.IHALogRequest;
import com.bigdata.ha.msg.IHALogRootBlocksRequest;
import com.bigdata.ha.msg.IHALogRootBlocksResponse;
import com.bigdata.ha.msg.IHARebuildRequest;
import com.bigdata.ha.msg.IHARemoteRebuildRequest;
import com.bigdata.ha.msg.IHASendStoreResponse;
import com.bigdata.ha.msg.IHASnapshotDigestRequest;
import com.bigdata.ha.msg.IHASnapshotDigestResponse;
import com.bigdata.ha.msg.IHASnapshotRequest;
import com.bigdata.ha.msg.IHASnapshotResponse;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.CommitCounterUtility;
import com.bigdata.journal.IHABufferStrategy;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.Journal;
import com.bigdata.journal.jini.ha.HAClient;
import com.bigdata.journal.jini.ha.HAJournalServer;
import com.bigdata.journal.jini.ha.HALogNexus;
import com.bigdata.journal.jini.ha.SnapshotManager;
import com.bigdata.quorum.Quorum;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.RemoteAdministrable;
import com.bigdata.service.jini.RemoteDestroyAdmin;
import com.bigdata.service.proxy.ClientFuture;
import com.bigdata.service.proxy.RemoteFuture;
import com.bigdata.service.proxy.RemoteFutureImpl;
import com.bigdata.service.proxy.ThickFuture;
import com.bigdata.util.StackInfoReport;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import org.apache.log4j.Logger;

public class HAJournal
extends Journal {
    private static final Logger log = Logger.getLogger(HAJournal.class);
    private final HAJournalServer server;
    private final InetSocketAddress writePipelineAddr;
    private final long haPrepareTimeout;
    private final long haReleaseTimeConsensusTimeout;
    private final long maximumClockSkew;
    private final long haExtraDelayForRetrySend;
    private final SnapshotManager snapshotManager;
    private final HALogNexus haLogNexus;

    public HALogNexus getHALogNexus() {
        return this.haLogNexus;
    }

    public HAClient getHAClient() {
        return this.server.getHAClient();
    }

    public HAJournalServer getHAJournalServer() {
        return this.server;
    }

    @Override
    public IHABufferStrategy getBufferStrategy() {
        return (IHABufferStrategy)super.getBufferStrategy();
    }

    public HAJournal(HAJournalServer server, Configuration config, Quorum<HAGlue, QuorumService<HAGlue>> quorum) throws ConfigurationException, IOException {
        this(server, config, JiniClient.getProperties(HAJournal.class.getName(), config), quorum);
    }

    private HAJournal(HAJournalServer server, Configuration config, Properties properties, Quorum<HAGlue, QuorumService<HAGlue>> quorum) throws ConfigurationException, IOException {
        super(HAJournal.checkProperties(properties), quorum);
        this.server = server;
        this.writePipelineAddr = (InetSocketAddress)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "writePipelineAddr", InetSocketAddress.class);
        this.haReleaseTimeConsensusTimeout = (Long)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "haReleaseTimeConsensusTimeout", Long.TYPE, (Object)Long.MAX_VALUE);
        if (this.haReleaseTimeConsensusTimeout < 100L) {
            throw new ConfigurationException("haReleaseTimeConsensusTimeout=" + this.haReleaseTimeConsensusTimeout + " : must be GTE " + 100L);
        }
        this.haPrepareTimeout = (Long)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "haPrepareTimeout", Long.TYPE, (Object)Long.MAX_VALUE);
        if (this.haPrepareTimeout < 100L) {
            throw new ConfigurationException("haPrepareTimeout=" + this.haPrepareTimeout + " : must be GTE " + 100L);
        }
        this.maximumClockSkew = (Long)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "maximumClockSkew", Long.TYPE, (Object)5000L);
        if (this.maximumClockSkew < 100L) {
            throw new ConfigurationException("maximumClockSkew=" + this.maximumClockSkew + " : must be GTE " + 100L);
        }
        this.haExtraDelayForRetrySend = (Long)config.getEntry(HAJournalServer.ConfigurationOptions.COMPONENT, "haExtraDelayForRetrySend", Long.TYPE, (Object)5000L);
        if (this.haExtraDelayForRetrySend < 0L) {
            throw new ConfigurationException("haExtraDelayForRetrySend=" + this.haExtraDelayForRetrySend + " : must be non-negative");
        }
        this.haLogNexus = new HALogNexus(server, this, config);
        this.snapshotManager = new SnapshotManager(server, this, config);
        try {
            this.getExecutorService().submit(this.snapshotManager.init()).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Properties checkProperties(Properties properties) {
        boolean writeCacheEnabled;
        long minReleaseAge = Long.valueOf(properties.getProperty(AbstractTransactionService.Options.MIN_RELEASE_AGE, "1"));
        BufferMode bufferMode = BufferMode.valueOf(properties.getProperty(Options.BUFFER_MODE, Options.DEFAULT_BUFFER_MODE));
        switch (bufferMode) {
            case DiskRW: {
                if (minReleaseAge > 0L) break;
                throw new IllegalArgumentException(AbstractTransactionService.Options.MIN_RELEASE_AGE + "=" + minReleaseAge + " : must be GTE ONE (1) for HA.");
            }
            case DiskWORM: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Options.BUFFER_MODE + "=" + (Object)((Object)bufferMode) + " : does not support HA");
            }
        }
        if (!(writeCacheEnabled = Boolean.valueOf(properties.getProperty(Options.WRITE_CACHE_ENABLED, "true")).booleanValue())) {
            throw new IllegalArgumentException(Options.WRITE_CACHE_ENABLED + " : must be true.");
        }
        return properties;
    }

    @Override
    protected HAGlue newHAGlue(UUID serviceId) {
        return new HAGlueService(serviceId);
    }

    @Override
    protected final void clearQuorumToken(long newValue) {
        super.clearQuorumToken(newValue);
    }

    @Override
    protected final void setQuorumToken(long newValue) {
        super.setQuorumToken(newValue);
    }

    @Override
    protected final long getQuorumToken() {
        return super.getQuorumToken();
    }

    @Override
    public final long getHAPrepareTimeout() {
        return this.haPrepareTimeout;
    }

    @Override
    public final long getHAReleaseTimeConsensusTimeout() {
        return this.haReleaseTimeConsensusTimeout;
    }

    @Override
    public final long getMaximumClockSkewMillis() {
        return this.maximumClockSkew;
    }

    public final long getHAExtraDelayForRetrySend() {
        return this.haExtraDelayForRetrySend;
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    @Override
    protected void _close() {
        try {
            this.haLogNexus.getHALogWriter().disableHALog();
        }
        catch (IOException e) {
            haLog.error((Object)e, (Throwable)e);
        }
        super._close();
    }

    @Override
    public void deleteResources() {
        super.deleteResources();
        this.recursiveDelete(this.getHALogNexus().getHALogDir(), IHALogReader.HALOG_FILTER);
        this.recursiveDelete(this.getSnapshotManager().getSnapshotDir(), SnapshotManager.SNAPSHOT_FILTER);
    }

    private void recursiveDelete(File f, FileFilter fileFilter) {
        try {
            CommitCounterUtility.recursiveDelete(false, f, fileFilter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IRootBlockView[] getRootBlocks() {
        return super.getRootBlocks();
    }

    @Override
    protected void installRootBlocks(IRootBlockView rootBlock0, IRootBlockView rootBlock1) {
        super.installRootBlocks(rootBlock0, rootBlock1);
    }

    @Override
    protected void doLocalCommit(QuorumService<HAGlue> localService, IRootBlockView rootBlock) {
        super.doLocalCommit(localService, rootBlock);
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = super.getCounters();
        CounterSet tmp = root.makePath("Volumes");
        tmp.addCounter("Service Volume Bytes Available", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(HAJournal.getFreeSpace(HAJournal.this.server.getServiceDir()));
            }
        });
        tmp.addCounter("Data Volume Bytes Available", new Instrument<Long>(){

            @Override
            public void sample() {
                File dir = HAJournal.this.getDataDir();
                if (dir != null) {
                    this.setValue(HAJournal.getFreeSpace(dir));
                }
            }
        });
        tmp.addCounter("HALog Volume Bytes Available", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(HAJournal.getFreeSpace(HAJournal.this.getHALogNexus().getHALogDir()));
            }
        });
        tmp.addCounter("Snapshot Volume Bytes Available", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(HAJournal.getFreeSpace(HAJournal.this.getSnapshotManager().getSnapshotDir()));
            }
        });
        tmp.addCounter("Temp Volume Bytes Available", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(HAJournal.getFreeSpace(HAJournal.this.getTmpDir()));
            }
        });
        return root;
    }

    protected static long getFreeSpace(File dir) {
        try {
            if (!dir.exists()) {
                return -1L;
            }
            return dir.getUsableSpace();
        }
        catch (Throwable t) {
            log.error((Object)("Could not get free space: dir=" + dir + " : " + t), t);
            return -1L;
        }
    }

    protected class HAGlueService
    extends AbstractJournal.BasicHA
    implements RemoteAdministrable,
    RemoteDestroyAdmin {
        private final InvocationLayerFactory invocationLayerFactory;

        protected HAGlueService(UUID serviceId) {
            super(serviceId, HAJournal.this.writePipelineAddr);
            this.invocationLayerFactory = new BasicILFactory();
        }

        @Override
        protected void validateNewRootBlock(boolean isLeader, IRootBlockView oldRB, IRootBlockView newRB) {
            super.validateNewRootBlock(isLeader, oldRB, newRB);
            if (!isLeader) {
                IHAWriteMessage msg = HAJournal.this.getHALogNexus().lastLiveHAWriteMessage;
                if (msg == null) {
                    throw new IllegalStateException("Commit without write set?");
                }
                if (!msg.getUUID().equals(newRB.getUUID())) {
                    throw new IllegalStateException("Store UUID: lastLiveMsg=" + msg.getUUID() + " != newRB=" + newRB.getUUID());
                }
                if (msg.getCommitCounter() + 1L != newRB.getCommitCounter()) {
                    throw new IllegalStateException("commitCounter: ( lastLiveMsg=" + msg.getCommitCounter() + " + 1 ) != newRB=" + newRB.getCommitCounter());
                }
                if (msg.getSequence() + 1L != newRB.getBlockSequence()) {
                    throw new IllegalStateException("blockSequence: lastLiveMsg=" + msg.getSequence() + " + 1 != newRB=" + newRB.getBlockSequence());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IHALogRootBlocksResponse getHALogRootBlocksForWriteSet(IHALogRootBlocksRequest msg) throws IOException {
            Lock logLock = HAJournal.this.getHALogNexus().getLogLock();
            logLock.lock();
            try {
                HALogRootBlocksResponse hALogRootBlocksResponse;
                long token = HAJournal.this.getQuorum().token();
                this.getQuorumService().assertLeader(token);
                if (!HAJournal.this.getHALogNexus().isHALogOpen()) {
                    if (haLog.isInfoEnabled()) {
                        log.info((Object)"Live HALog does not exist on the quorum leader", (Throwable)new StackInfoReport());
                    }
                    HAJournal.this.getHALogNexus().conditionalCreateHALog();
                }
                long commitCounter = msg.getCommitCounter();
                File logFile = HAJournal.this.getHALogNexus().getHALogFile(commitCounter);
                if (!logFile.exists()) {
                    throw new FileNotFoundException(logFile.getName());
                }
                IHALogReader r = HAJournal.this.getHALogNexus().getReader(logFile);
                try {
                    HALogRootBlocksResponse resp = new HALogRootBlocksResponse(r.getOpeningRootBlock(), r.getClosingRootBlock());
                    if (haLog.isDebugEnabled()) {
                        haLog.debug((Object)("msg=" + msg + ", resp=" + resp));
                    }
                    hALogRootBlocksResponse = resp;
                }
                catch (Throwable throwable) {
                    r.close();
                    throw throwable;
                }
                r.close();
                return hALogRootBlocksResponse;
            }
            finally {
                logLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Future<Void> sendHALogForWriteSet(final IHALogRequest req) throws IOException {
            FutureTaskInvariantMon<Void> ft;
            boolean isLive;
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("req=" + req));
            }
            long commitCounter = req.getCommitCounter();
            final long token = HAJournal.this.getQuorum().token();
            IHALogReader r = null;
            try {
                r = HAJournal.this.getHALogNexus().getReader(commitCounter);
                isLive = r.isLive();
                ft = new FutureTaskInvariantMon<Void>((Callable)new SendHALogTask(req, r), HAJournal.this.getQuorum()){

                    @Override
                    protected void establishInvariants() {
                        this.assertQuorumMet();
                        this.assertJoined(HAGlueService.this.getServiceId());
                        this.assertMember(req.getServiceId());
                        this.assertInPipeline(req.getServiceId());
                        HAJournal.this.getQuorum().assertLeader(token);
                    }
                };
                HAJournal.this.getExecutorService().submit(ft);
                r = null;
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable t) {
                        log.error((Object)t, t);
                    }
                }
            }
            return this.getProxy(ft, isLive);
        }

        @Override
        public Future<IHASendStoreResponse> sendHAStore(final IHARebuildRequest req) throws IOException {
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("req=" + req));
            }
            final long token = HAJournal.this.getQuorum().token();
            FutureTaskInvariantMon<IHASendStoreResponse> ft = new FutureTaskInvariantMon<IHASendStoreResponse>((Callable)new SendStoreTask(req), HAJournal.this.getQuorum()){

                @Override
                protected void establishInvariants() {
                    this.assertQuorumMet();
                    this.assertJoined(HAGlueService.this.getServiceId());
                    this.assertMember(req.getServiceId());
                    this.assertInPipeline(req.getServiceId());
                    HAJournal.this.getQuorum().assertLeader(token);
                }
            };
            HAJournal.this.getExecutorService().submit(ft);
            return this.getProxy(ft, true);
        }

        @Override
        public IHADigestResponse computeDigest(IHADigestRequest req) throws IOException, NoSuchAlgorithmException, DigestException {
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("req=" + req));
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            HAJournal.this.getBufferStrategy().computeDigest(null, digest);
            HADigestResponse resp = new HADigestResponse(req.getStoreUUID(), digest.digest());
            if (haLog.isInfoEnabled()) {
                log.info((Object)("Request=" + req + ", Response=" + resp));
            }
            return resp;
        }

        @Override
        public IHALogDigestResponse computeHALogDigest(IHALogDigestRequest req) throws IOException, NoSuchAlgorithmException, DigestException {
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("req=" + req));
            }
            long commitCounter = req.getCommitCounter();
            IHALogReader r = HAJournal.this.getHALogNexus().getReader(commitCounter);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            r.computeDigest(digest);
            HALogDigestResponse resp = new HALogDigestResponse(req.getCommitCounter(), digest.digest());
            if (haLog.isInfoEnabled()) {
                log.info((Object)("Request=" + req + ", Response=" + resp));
            }
            return resp;
        }

        @Override
        public IHASnapshotDigestResponse computeHASnapshotDigest(IHASnapshotDigestRequest req) throws IOException, NoSuchAlgorithmException, DigestException {
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("req=" + req));
            }
            long commitCounter = req.getCommitCounter();
            MessageDigest digest = MessageDigest.getInstance("MD5");
            HAJournal.this.getSnapshotManager().getDigest(commitCounter, digest);
            HASnapshotDigestResponse resp = new HASnapshotDigestResponse(req.getCommitCounter(), digest.digest());
            if (haLog.isInfoEnabled()) {
                log.info((Object)("Request=" + req + ", Response=" + resp));
            }
            return resp;
        }

        @Override
        public Future<IHASnapshotResponse> takeSnapshot(IHASnapshotRequest req) throws IOException {
            Future<IHASnapshotResponse> ft = HAJournal.this.getSnapshotManager().takeSnapshot(req);
            return ft == null ? null : this.getProxy(ft, true);
        }

        @Override
        public Future<Void> rebuildFromLeader(IHARemoteRebuildRequest req) throws IOException {
            HAJournalServer.RunStateEnum innerRunState;
            HAJournalServer.HAQuorumService<HAGlue, HAJournal> localService = this.getQuorumService();
            HAJournalServer.RunStateEnum runStateEnum = innerRunState = localService == null ? null : localService.getRunStateEnum();
            if (innerRunState == null) {
                return null;
            }
            switch (innerRunState) {
                case Error: 
                case SeekConsensus: 
                case Operator: {
                    if (localService == null) {
                        return null;
                    }
                    Future<Void> f = localService.rebuildFromLeader(new HARemoteRebuildRequest());
                    if (f == null) {
                        return null;
                    }
                    haLog.warn((Object)("Started REBUILD: runState=" + (Object)((Object)innerRunState)));
                    return this.getProxy(f, true);
                }
                case Rebuild: 
                case Restore: 
                case Resync: 
                case RunMet: 
                case Shutdown: {
                    haLog.warn((Object)("Can not REBUILD: runState=" + (Object)((Object)innerRunState)));
                    return null;
                }
            }
            throw new AssertionError((Object)("innerRunState=" + (Object)((Object)innerRunState)));
        }

        protected Exporter getExporter(boolean enableDGC) {
            return new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), this.invocationLayerFactory, enableDGC, false);
        }

        @Override
        protected <E> Future<E> getProxy(Future<E> future, boolean asyncFuture) {
            RemoteFuture proxy;
            if (!asyncFuture) {
                return new ThickFuture<E>(future);
            }
            boolean enableDGC = true;
            Exporter exporter = this.getExporter(true);
            RemoteFutureImpl<E> impl = new RemoteFutureImpl<E>(future);
            try {
                proxy = (RemoteFuture)exporter.export(impl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exported proxy: proxy=" + proxy + "(" + proxy.getClass() + ")"));
                }
            }
            catch (ExportException ex) {
                throw new RuntimeException("Export error: " + ex, ex);
            }
            return new ClientFuture(proxy);
        }

        public Object getAdmin() throws RemoteException {
            if (log.isInfoEnabled()) {
                log.info((Object)("serviceID=" + HAJournal.this.server.getServiceID()));
            }
            return HAJournal.this.server.getProxy();
        }

        @Override
        public void destroy() {
            HAJournal.this.server.runShutdown(true);
        }

        @Override
        public void shutdown() {
            HAJournal.this.server.runShutdown(false);
        }

        @Override
        public void shutdownNow() {
            HAJournal.this.server.runShutdown(false);
        }

        @Override
        public int getNSSPort() {
            return HAJournal.this.server.getNSSPort();
        }

        @Override
        public RunState getRunState() {
            return HAJournal.this.server.getRunState();
        }

        protected HAJournalServer.HAQuorumService<HAGlue, HAJournal> getQuorumService() {
            HAJournalServer.HAQuorumService quorumService = (HAJournalServer.HAQuorumService)HAJournal.this.getQuorum().getClient();
            return quorumService;
        }

        @Override
        public String getExtendedRunState() {
            HAJournalServer server = HAJournal.this.getHAJournalServer();
            HAJournalServer.HAQuorumService<HAGlue, HAJournal> quorumService = this.getQuorumService();
            HAJournalServer.RunStateEnum innerRunState = quorumService == null ? null : quorumService.getRunStateEnum();
            HAJournal journal = HAJournal.this;
            StringBuilder innerRunStateStr = new StringBuilder();
            if (innerRunState != null) {
                innerRunStateStr.append(innerRunState.name());
            } else {
                innerRunStateStr.append("N/A");
            }
            boolean debug = true;
            innerRunStateStr.append(" @ " + journal.getRootBlockView().getCommitCounter());
            innerRunStateStr.append(", haReady=" + HAJournal.this.getHAReady());
            innerRunStateStr.append(", haStatus=" + (Object)((Object)this.getHAStatus()));
            innerRunStateStr.append(", serviceId=" + (quorumService == null ? "N/A" : quorumService.getServiceId()));
            innerRunStateStr.append(", now=" + System.currentTimeMillis());
            String msg = server.getOperatorAlert();
            if (msg != null) {
                innerRunStateStr.append(", msg=[" + msg + "]");
            }
            return "{server=" + (Object)((Object)server.getRunState()) + ", quorumService=" + innerRunStateStr + "}";
        }

        private class SendStoreTask
        implements Callable<IHASendStoreResponse> {
            private final IHARebuildRequest req;

            public SendStoreTask(IHARebuildRequest req) {
                if (req == null) {
                    throw new IllegalArgumentException();
                }
                this.req = req;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IHASendStoreResponse call() throws Exception {
                long quorumToken = HAJournal.this.getQuorumToken();
                long txId = HAJournal.this.newTx(-1L);
                IRootBlockView[] rootBlocks = HAJournal.this.getRootBlocks();
                IBufferAccess buf = null;
                try {
                    HASendStoreResponse resp;
                    long totalBytes;
                    try {
                        buf = DirectBufferPool.INSTANCE.acquire();
                    }
                    catch (InterruptedException ex) {
                        throw new IOException(ex);
                    }
                    ByteBuffer b = buf.buffer();
                    int bufferCapacity = b.capacity();
                    int headerSize = 688;
                    long fileExtent = HAJournal.this.getBufferStrategy().getExtent();
                    long remaining = totalBytes = fileExtent - 688L;
                    long offset = 688L;
                    long sequence = 0L;
                    if (haLog.isInfoEnabled()) {
                        haLog.info((Object)("Sending store file: nbytes=" + totalBytes));
                    }
                    while (remaining > 0L) {
                        int nbytes = (int)Math.min((long)bufferCapacity, remaining);
                        if (sequence == 0L && nbytes == bufferCapacity && remaining > (long)bufferCapacity) {
                            nbytes -= 688;
                        }
                        if (haLog.isDebugEnabled()) {
                            haLog.debug((Object)("Sending block: sequence=" + sequence + ", offset=" + offset + ", nbytes=" + nbytes));
                        }
                        Future<Void> ft = HAJournal.this.getBufferStrategy().sendRawBuffer(this.req, sequence, quorumToken, fileExtent, offset, nbytes, b);
                        ft.get();
                        remaining -= (long)nbytes;
                        offset += (long)nbytes;
                        ++sequence;
                    }
                    if (haLog.isInfoEnabled()) {
                        haLog.info((Object)("Sent store file: #blocks=" + sequence + ", #bytes=" + (fileExtent - 688L)));
                    }
                    HASendStoreResponse hASendStoreResponse = resp = new HASendStoreResponse(rootBlocks[0], rootBlocks[1], totalBytes, sequence);
                    return hASendStoreResponse;
                }
                finally {
                    if (buf != null) {
                        try {
                            buf.release();
                        }
                        catch (InterruptedException e) {
                            haLog.warn((Object)e);
                        }
                    }
                    HAJournal.this.abort(txId);
                }
            }
        }

        private class SendHALogTask
        implements Callable<Void> {
            private final IHALogRequest req;
            private final IHALogReader r;

            public SendHALogTask(IHALogRequest req, IHALogReader r) {
                this.req = req;
                this.r = r;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public Void call() throws Exception {
                try {
                    long nsent = 0L;
                    boolean success = false;
                    IBufferAccess buf = DirectBufferPool.INSTANCE.acquire();
                    try {
                        IHABufferStrategy strategy;
                        while (this.r.hasMoreBuffers()) {
                            strategy = HAJournal.this.getBufferStrategy();
                            IHAWriteMessage msg = this.r.processNextBuffer(buf.buffer());
                            if (haLog.isDebugEnabled()) {
                                haLog.debug((Object)("req=" + this.req + ", msg=" + msg));
                            }
                            Future<Void> ft = strategy.sendHALogBuffer(this.req, msg, buf);
                            ft.get();
                            ++nsent;
                        }
                        success = true;
                        strategy = null;
                        return strategy;
                    }
                    catch (Exception e) {
                        if (haLog.isDebugEnabled()) {
                            haLog.debug((Object)"Interrupted", (Throwable)e);
                        }
                        throw e;
                    }
                    finally {
                        buf.release();
                        if (haLog.isDebugEnabled()) {
                            haLog.debug((Object)("req=" + this.req + ", nsent=" + nsent + ", success=" + success));
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.r.close();
                }
            }
        }
    }

    public static interface IHAJournalCounters {
        public static final String Volumes = "Volumes";
        public static final String ServiceDirBytesAvailable = "Service Volume Bytes Available";
        public static final String DataDirBytesAvailable = "Data Volume Bytes Available";
        public static final String HALogDirBytesAvailable = "HALog Volume Bytes Available";
        public static final String SnapshotDirBytesAvailable = "Snapshot Volume Bytes Available";
        public static final String TmpDirBytesAvailable = "Temp Volume Bytes Available";
    }

    public static interface Options
    extends Journal.Options {
    }
}

